/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseProcedureParameter;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedureParameter;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectWithScript;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;

public abstract class AltibaseProcedureBase
extends GenericProcedure
implements DBSObjectWithScript {
    protected static final Log log = Log.getLog(AltibaseProcedureBase.class);
    protected List<GenericProcedureParameter> columns;
    private DBSProcedureType procedureType;

    public AltibaseProcedureBase(GenericStructContainer container, String procedureName, String specificName, String description, DBSProcedureType procedureType, GenericFunctionResultType functionResultType) {
        super(container, procedureName, specificName, description, procedureType, functionResultType);
        this.procedureType = procedureType;
    }

    public void addColumn(GenericProcedureParameter column) {
        if (this.columns == null) {
            this.columns = new ArrayList<GenericProcedureParameter>();
        }
        this.columns.add(new AltibaseProcedureParameter(column));
    }

    @Nullable
    public Collection<GenericProcedureParameter> getParameters(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.columns == null) {
            this.loadProcedureColumns(monitor);
        }
        return this.columns;
    }

    @Property(viewable=false, hidden=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Property(viewable=false, hidden=true, order=3)
    public GenericCatalog getCatalog() {
        return ((GenericStructContainer)this.getContainer()).getCatalog();
    }

    @Property(viewable=false, hidden=true, order=7)
    public GenericFunctionResultType getFunctionResultType() {
        return super.getFunctionResultType();
    }

    public void setProcedureType(DBSProcedureType procedureType) {
        this.procedureType = procedureType;
    }

    public String getProcedureTypeName() {
        if (this.procedureType == DBSProcedureType.UNKNOWN) {
            return "TYPESET";
        }
        return this.procedureType.name();
    }

    @Property(hidden=true, editable=true, updatable=true)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return super.getObjectDefinitionText(monitor, options);
    }

    public void setObjectDefinitionText(String source) {
        super.setSource(source);
    }
}

