/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataSource;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseGrantee;
import org.jkiss.dbeaver.ext.altibase.model.AltibasePriv;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectLazy;

public class AltibasePrivRole
extends AltibasePriv
implements DBSObjectLazy<AltibaseDataSource> {
    private Object role;
    private String grantor;

    public AltibasePrivRole(AltibaseGrantee user, ResultSet resultSet) {
        super(user, JDBCUtils.safeGetString((ResultSet)resultSet, (String)"ROLE_NAME"));
        this.role = this.name;
        this.grantor = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"GRANTOR_NAME");
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getGrantor() {
        return this.grantor;
    }

    @Property(id="name", viewable=true, order=2, supportsPreview=true)
    public Object getRole(DBRProgressMonitor monitor) throws DBException {
        if (monitor == null) {
            return this.role;
        }
        return AltibaseUtils.resolveLazyReference(monitor, this.getDataSource(), this.getDataSource().roleCache, this, null);
    }

    @Nullable
    public Object getLazyReference(Object propertyId) {
        return this.role;
    }
}

