/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.altibase.AltibaseConstants;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseMetaModel;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericPackage;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class AltibasePackage
extends GenericPackage {
    private String source;
    private boolean status;
    private boolean hasBody;

    public AltibasePackage(GenericStructContainer container, String packageName, JDBCResultSet dbResult) {
        super(container, packageName, true);
        this.status = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"STATUS") == 0;
    }

    public void setBody(boolean hasBody) {
        this.hasBody = hasBody;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.source == null) {
            this.source = "-- Package specification " + AltibaseConstants.NEW_LINE + ((AltibaseMetaModel)this.getDataSource().getMetaModel()).getPackageDDL(monitor, this, 6) + AltibaseConstants.NEW_LINE + "-- Package body " + AltibaseConstants.NEW_LINE;
            this.source = this.hasBody ? String.valueOf(this.source) + ((AltibaseMetaModel)this.getDataSource().getMetaModel()).getPackageDDL(monitor, this, 7) : String.valueOf(this.source) + "-- No body definition";
        }
        return this.source;
    }

    @Property(viewable=true, order=5)
    public boolean isValid() {
        return this.status;
    }

    @Property(viewable=false, hidden=true, order=3)
    public GenericCatalog getCatalog() {
        return super.getCatalog();
    }
}

