/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.altibase.AltibaseConstants;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseGrantee;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseMetaModel;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseReplication;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseReplicationItem;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseRole;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseSQLDialect;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseSchema;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseSynonym;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseTablespace;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseUser;
import org.jkiss.dbeaver.ext.altibase.model.plan.AltibaseQueryPlanner;
import org.jkiss.dbeaver.ext.altibase.model.session.AltibaseServerSessionManager;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSynonym;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionResult;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.output.DBCOutputWriter;
import org.jkiss.dbeaver.model.exec.output.DBCServerOutputReader;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructLookupCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class AltibaseDataSource
extends GenericDataSource
implements DBPObjectStatisticsCollector {
    private static final Log log = Log.getLog(AltibaseDataSource.class);
    final TablespaceCache tablespaceCache = new TablespaceCache();
    final UserCache userCache = new UserCache();
    final RoleCache roleCache = new RoleCache();
    final ReplicationCache replCache;
    private boolean hasStatistics;
    private GenericSchema publicSchema;
    private boolean isPasswordExpireWarningShown;
    private AltibaseOutputReader outputReader;
    private String dbName;
    String queryGetActiveDB;

    public AltibaseDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, AltibaseMetaModel metaModel) throws DBException {
        super(monitor, container, (GenericMetaModel)metaModel, (SQLDialect)new AltibaseSQLDialect());
        this.queryGetActiveDB = CommonUtils.toString((Object)container.getDriver().getDriverParameter("query-get-active-db"));
        this.replCache = new ReplicationCache(this);
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        this.publicSchema = new GenericSchema((GenericDataSource)this, null, "PUBLIC");
        this.publicSchema.setVirtual(true);
    }

    protected void initializeContextState(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext context, JDBCExecutionContext initFrom) throws DBException {
        super.initializeContextState(monitor, context, initFrom);
        if (this.outputReader == null) {
            this.outputReader = new AltibaseOutputReader();
        }
        this.outputReader.enableServerOutput(monitor, (DBCExecutionContext)context, this.outputReader.isServerOutputEnabled());
    }

    @NotNull
    public AltibaseMetaModel getMetaModel() {
        return (AltibaseMetaModel)super.getMetaModel();
    }

    public String getDbName(JDBCSession session) throws DBException {
        if (this.dbName == null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement(this.queryGetActiveDB);){
                    Throwable throwable2 = null;
                    Object var6_10 = null;
                    try (JDBCResultSet resultSet = dbStat.executeQuery();){
                        resultSet.next();
                        this.dbName = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (int)1);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e, (DBPDataSource)this);
            }
        }
        return this.dbName;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.tablespaceCache.clearCache();
        this.userCache.clearCache();
        this.roleCache.clearCache();
        this.replCache.clearCache();
        this.hasStatistics = false;
        this.initialize(monitor);
        return this;
    }

    @Nullable
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBCServerOutputReader.class) {
            return adapter.cast(this.outputReader);
        }
        if (adapter == DBCQueryPlanner.class) {
            return adapter.cast((Object)new AltibaseQueryPlanner(this));
        }
        if (adapter == DBAServerSessionManager.class) {
            return adapter.cast(new AltibaseServerSessionManager(this));
        }
        return (T)super.getAdapter(adapter);
    }

    protected Connection openConnection(@NotNull DBRProgressMonitor monitor, @Nullable JDBCExecutionContext context, @NotNull String purpose) throws DBCException {
        Connection connection = super.openConnection(monitor, context, purpose);
        try {
            SQLWarning warninig = connection.getWarnings();
            while (warninig != null && !this.isPasswordExpireWarningShown) {
                if (this.checkForPasswordWillExpireWarning(warninig)) {
                    this.isPasswordExpireWarningShown = true;
                }
                warninig = warninig.getNextWarning();
            }
        }
        catch (SQLException e) {
            log.debug((Object)"Can't get connection warnings", (Throwable)e);
        }
        return connection;
    }

    private boolean checkForPasswordWillExpireWarning(@NotNull SQLWarning warning) {
        if (warning != null && warning.getErrorCode() == 334457) {
            DBWorkbench.getPlatformUI().showWarningMessageBox("SQL Warning", warning.getMessage() + AltibaseConstants.NEW_LINE + "Change the password or contact the DBA.");
            return true;
        }
        return false;
    }

    @NotNull
    public AltibaseDataSource getDataSource() {
        return this;
    }

    public boolean splitProceduresAndFunctions() {
        return true;
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return AltibaseSchema.class;
    }

    public DBSObject findSynonymTargetObject(DBRProgressMonitor monitor, @Nullable String refSchemaName, @NotNull String refObjName) throws DBException {
        GenericTableBase refObj = null;
        AltibaseSchema refSchema = (AltibaseSchema)this.getSchema(refSchemaName);
        if (refSchema != null) {
            if (refObj == null) {
                refObj = refSchema.getTable(monitor, refObjName);
            }
            if (refObj == null) {
                refObj = refSchema.getSequence(monitor, refObjName);
            }
            if (refObj == null) {
                refObj = refSchema.getSynonym(monitor, refObjName);
            }
            if (refObj == null) {
                refObj = refSchema.getProcedureByName(monitor, refObjName);
            }
            if (refObj == null) {
                refObj = refSchema.getPackage(monitor, refObjName);
            }
            if (refObj == null) {
                refObj = refSchema.getIndex(monitor, refObjName);
            }
            if (refObj == null) {
                refObj = refSchema.getTableTrigger(monitor, refObjName);
            }
        } else if (refObj == null && (refObj = this.publicSchema.getSynonym(monitor, refObjName)) != null) {
            ((AltibaseSynonym)refObj).setPublicSynonym();
        }
        return refObj;
    }

    public Collection<? extends GenericSynonym> getPublicSynonyms(DBRProgressMonitor monitor) throws DBException {
        return this.publicSchema.getSynonyms(monitor);
    }

    @Association
    public Collection<AltibaseTablespace> getTablespaces(DBRProgressMonitor monitor) throws DBException {
        return this.tablespaceCache.getAllObjects(monitor, (DBSObject)this);
    }

    public TablespaceCache getTablespaceCache() {
        return this.tablespaceCache;
    }

    @Association
    public Collection<AltibaseUser> getUsers(DBRProgressMonitor monitor) throws DBException {
        return this.userCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public AltibaseUser getUser(DBRProgressMonitor monitor, String name) throws DBException {
        return (AltibaseUser)this.userCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<AltibaseRole> getRoles(DBRProgressMonitor monitor) throws DBException {
        return this.roleCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public AltibaseRole getRole(DBRProgressMonitor monitor, String name) throws DBException {
        return (AltibaseRole)this.roleCache.getObject(monitor, (DBSObject)this, name);
    }

    public AltibaseGrantee getGrantee(DBRProgressMonitor monitor, String name) throws DBException {
        AltibaseUser user = (AltibaseUser)this.userCache.getObject(monitor, (DBSObject)this, name);
        if (user != null) {
            return user;
        }
        return (AltibaseGrantee)this.roleCache.getObject(monitor, (DBSObject)this, name);
    }

    public ReplicationCache getReplicationCache() {
        return this.replCache;
    }

    @Association
    public Collection<AltibaseReplication> getReplications(DBRProgressMonitor monitor) throws DBException {
        return this.replCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public AltibaseReplication getReplication(DBRProgressMonitor monitor, String name) throws DBException {
        return (AltibaseReplication)this.replCache.getObject(monitor, (DBSObject)this, name);
    }

    public boolean isStatisticsCollected() {
        return this.hasStatistics;
    }

    void resetStatistics() {
        this.hasStatistics = false;
    }

    public void collectObjectStatistics(DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        if (this.hasStatistics && !forceRefresh) {
            return;
        }
        try {
            try {
                for (AltibaseTablespace tbs : this.tablespaceCache.getAllObjects(monitor, (DBSObject)this)) {
                    AltibaseTablespace tablespace = (AltibaseTablespace)this.tablespaceCache.getObject(monitor, (DBSObject)this, tbs.getName());
                    if (tablespace == null) continue;
                    tablespace.loadSizes(monitor);
                }
            }
            catch (DBException e) {
                throw new DBException("Can't read tablespace statistics", (Throwable)e, (DBPDataSource)this.getDataSource());
            }
        }
        finally {
            this.hasStatistics = true;
        }
    }

    private class AltibaseOutputReader
    implements DBCServerOutputReader {
        private StringBuilder callBackMsg = new StringBuilder();

        private AltibaseOutputReader() {
        }

        public boolean isServerOutputEnabled() {
            return AltibaseDataSource.this.getContainer().getPreferenceStore().getBoolean("altibase.dbms.output");
        }

        public boolean isAsyncOutputReadSupported() {
            return false;
        }

        public void enableServerOutput(DBRProgressMonitor monitor, DBCExecutionContext context, boolean enable) throws DBCException {
            Connection conn = null;
            ClassLoader classLoader = null;
            Class<?> class4MsgCallback = null;
            Object instance4Callback = null;
            Method method2RegisterCallback = null;
            String connClassNamePrefix = "Altibase";
            Object className4Connection = "N/A";
            Object className4MessageCallback = "N/A";
            try {
                Throwable throwable = null;
                Object var13_15 = null;
                try (JDBCSession session = (JDBCSession)context.openSession(monitor, DBCExecutionPurpose.UTIL, (enable ? "Enable" : "Disable") + " DBMS output");){
                    conn = session.getOriginal();
                    classLoader = conn.getClass().getClassLoader();
                    if (classLoader == null) {
                        throw new SecurityException("Failed to load ClassLoader");
                    }
                    connClassNamePrefix = conn.getClass().getName().split("\\.")[0];
                    className4Connection = connClassNamePrefix + ".jdbc.driver.AltibaseConnection";
                    className4MessageCallback = connClassNamePrefix + ".jdbc.driver.AltibaseMessageCallback";
                    class4MsgCallback = classLoader.loadClass((String)className4MessageCallback);
                    if (class4MsgCallback == null) {
                        throw new ClassNotFoundException("Failed to load class: " + (String)className4MessageCallback);
                    }
                    instance4Callback = Proxy.newProxyInstance(classLoader, new Class[]{class4MsgCallback}, new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            if ("print".equals(method.getName())) {
                                AltibaseOutputReader.this.callBackMsg.append((String)args[0]);
                            }
                            return null;
                        }
                    });
                    if (instance4Callback == null) {
                        throw new InstantiationException("Failed to instantiate class: " + (String)className4MessageCallback);
                    }
                    method2RegisterCallback = classLoader.loadClass((String)className4Connection).getMethod("registerMessageCallback", class4MsgCallback);
                    if (method2RegisterCallback == null) {
                        throw new NoSuchMethodException(String.format("Failed to get method: %s of class %s ", "registerMessageCallback", className4MessageCallback));
                    }
                    method2RegisterCallback.invoke((Object)conn, instance4Callback);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to register DBMS output message callback method: " + e.getMessage()));
                throw new DBCException((Throwable)e, context);
            }
        }

        public void readServerOutput(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @Nullable DBCExecutionResult executionResult, @Nullable DBCStatement statement, @NotNull DBCOutputWriter output) throws DBCException {
            if (this.callBackMsg != null) {
                output.println(null, this.callBackMsg.toString());
                this.callBackMsg.delete(0, this.callBackMsg.length());
            }
        }
    }

    static class ReplicationCache
    extends JDBCStructLookupCache<GenericStructContainer, AltibaseReplication, AltibaseReplicationItem> {
        final AltibaseDataSource dataSource;

        protected ReplicationCache(AltibaseDataSource dataSource) {
            super((Object)"Replication");
            this.dataSource = dataSource;
            this.setListOrderComparator(DBUtils.nameComparatorIgnoreCase());
        }

        public AltibaseDataSource getDataSource() {
            return this.dataSource;
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable AltibaseReplication object, @Nullable String objectName) throws SQLException {
            String replName = object != null ? object.getName() : objectName;
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT r.replication_name, DECODE( r.is_started, 0, 'Stop',  1,'Start',  'Unknown') AS status, DECODE( r.conflict_resolution, 0, 'Default',  1, 'Master',  2, 'Slave',  'Unknown') AS conflict_resolution, DECODE( r.repl_mode,  0, 'Lazy',  2,'Eager',  'Unknown') AS repl_mode,  DECODE( r.role, 0, 'General', 1, 'Log Analyzer', 2, 'Propagable Logging', 3, 'Propagation', 4, 'Propagation for Log Analyzer ', 'Unknown') AS role, r.options, DECODE( r.invalid_recovery, 0, 'Valid', 1, 'Invalid', 'Unknown') AS recoverable, parallel_applier_count, rh.host_ip || ':' || rh.port_no AS remote_addr, rh.conn_type AS remote_conn_type, r.xsn, r.remote_last_ddl_xsn, r.remote_fault_detect_time, r.give_up_time, r.give_up_xsn, r.remote_xsn, r.applier_init_buffer_size, r.peer_replication_name FROM system_.sys_replications_ r, system_.sys_repl_hosts_ rh WHERE r.replication_name = rh.replication_name" + (CommonUtils.isEmpty((String)replName) ? "" : " AND r.replication_name = ?") + " ORDER BY r.replication_name");
            if (CommonUtils.isNotEmpty((String)replName)) {
                dbStat.setString(1, replName);
            }
            return dbStat;
        }

        @Nullable
        protected AltibaseReplication fetchObject(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new AltibaseReplication(owner, dbResult);
        }

        protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @NotNull AltibaseReplication forTable) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM system_.sys_repl_items_ WHERE replication_name = ? ORDER BY local_user_name, local_table_name, local_partition_name,  remote_user_name, remote_table_name, remote_partition_name");
            dbStat.setString(1, forTable.getName());
            return dbStat;
        }

        protected AltibaseReplicationItem fetchChild(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @NotNull AltibaseReplication replication, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new AltibaseReplicationItem(replication, dbResult);
        }
    }

    static class RoleCache
    extends JDBCObjectCache<AltibaseDataSource, AltibaseRole> {
        RoleCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull AltibaseDataSource owner) throws SQLException {
            return session.prepareStatement("SELECT *  FROM SYSTEM_.SYS_USERS_ u  WHERE u.user_type = 'R' AND u.user_name <> 'PUBLIC' ORDER BY user_name");
        }

        protected AltibaseRole fetchObject(@NotNull JDBCSession session, @NotNull AltibaseDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new AltibaseRole(owner, (ResultSet)resultSet);
        }
    }

    static class TablespaceCache
    extends JDBCObjectCache<AltibaseDataSource, AltibaseTablespace> {
        TablespaceCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull AltibaseDataSource owner) throws SQLException {
            return session.prepareStatement("SELECT * FROM V$TABLESPACES ORDER BY NAME ASC");
        }

        protected AltibaseTablespace fetchObject(@NotNull JDBCSession session, @NotNull AltibaseDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new AltibaseTablespace(owner, (ResultSet)resultSet);
        }
    }

    static class UserCache
    extends JDBCObjectCache<AltibaseDataSource, AltibaseUser> {
        UserCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull AltibaseDataSource owner) throws SQLException {
            return session.prepareStatement("SELECT u.*, tbs1.name AS default_tbs_name, tbs2.name AS temp_tbs_name FROM SYSTEM_.SYS_USERS_ u, V$TABLESPACES tbs1, V$TABLESPACES tbs2 WHERE u.user_type = 'U' AND u.DEFAULT_TBS_ID = tbs1.id AND u.TEMP_TBS_ID = tbs2.id ORDER BY user_name");
        }

        protected AltibaseUser fetchObject(@NotNull JDBCSession session, @NotNull AltibaseDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new AltibaseUser(owner, resultSet);
        }
    }
}

