/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseMaterializedView;
import org.jkiss.dbeaver.ext.generic.edit.GenericViewManager;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class AltibaseMaterializedViewManager
extends GenericViewManager {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    public boolean canCreateObject(Object container) {
        return true;
    }

    protected String getDropViewType(GenericTableBase table) {
        return "MATERIALIZED VIEW";
    }

    protected GenericTableBase createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        GenericStructContainer structContainer = (GenericStructContainer)container;
        String tableName = this.getNewChildName(monitor, (DBSObject)structContainer, "NewMView");
        GenericTableBase viewImpl = structContainer.getDataSource().getMetaModel().createTableOrViewImpl(structContainer, tableName, "MATERIALIZED VIEW", null);
        if (viewImpl instanceof AltibaseMaterializedView) {
            ((AltibaseMaterializedView)viewImpl).setObjectDefinitionText("CREATE MATERIALIZED VIEW " + viewImpl.getFullyQualifiedName(DBPEvaluationContext.DDL) + " AS SELECT 1 as A\n");
        }
        return viewImpl;
    }

    protected String getBaseObjectName() {
        return "NewMView";
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop view", "DROP MATERIALIZED VIEW " + ((GenericTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        AltibaseMaterializedView view = (AltibaseMaterializedView)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create " + "MATERIALIZED VIEW".toLowerCase(), view.getDDL()));
    }
}

