/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.bigquery.model.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Reader;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.bigquery.model.BigQueryDataSource;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCollection;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCComposite;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCompositeMap;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCStructValueHandler;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public class BigQueryStructValueHandler
extends JDBCStructValueHandler {
    private static final Log log = Log.getLog(BigQueryStructValueHandler.class);
    private static final Gson gson = new GsonBuilder().create();
    private DBSDataType structDataType;
    private DBSDataType arrayDataType;
    private ColumnFieldInfo[] columnFields;

    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        try {
            BigQueryDataSource dataSource = (BigQueryDataSource)session.getDataSource();
            if (dataSource.getContainer().getPreferenceStore().getBoolean("resultset.transform.complex.type") && this.structDataType == null) {
                List rsColumnsMeta;
                Object columnMetaData;
                List nestedTypes;
                this.structDataType = dataSource.getLocalDataType("STRUCT");
                this.arrayDataType = dataSource.getLocalDataType("ARRAY");
                ResultSet bqResultSet = resultSet.getOriginal();
                if (bqResultSet.getClass().getName().startsWith("com.simba.googlebigquery.jdbc") && (nestedTypes = (List)BeanUtils.invokeObjectDeclaredMethod(columnMetaData = (rsColumnsMeta = (List)BeanUtils.invokeObjectDeclaredMethod((Object)bqResultSet, (String)"getResultSetColumns", (Class[])new Class[0], (Object[])new Object[0])).get(index - 1), (String)"getNestedTypes", (Class[])new Class[0], (Object[])new Object[0])) != null) {
                    this.columnFields = this.collectNestedTypes(nestedTypes);
                }
            }
        }
        catch (Throwable e) {
            log.debug((Object)"Error reading BQ struct metadata", e);
        }
        return super.fetchColumnValue(session, resultSet, type, index);
    }

    /*
     * WARNING - void declaration
     */
    private ColumnFieldInfo[] collectNestedTypes(List<?> nestedTypes) throws Exception {
        ColumnFieldInfo[] fields = new ColumnFieldInfo[nestedTypes.size()];
        int i = 0;
        while (i < nestedTypes.size()) {
            Object meta = nestedTypes.get(i);
            fields[i] = new ColumnFieldInfo((String)BeanUtils.readObjectProperty(meta, (String)"name"), (String)BeanUtils.readObjectProperty(meta, (String)"type"), (String)BeanUtils.readObjectProperty(meta, (String)"mode"));
            Object fieldsObj = BeanUtils.readObjectProperty(meta, (String)"fields");
            Object object = fieldsObj;
            if (object instanceof List) {
                void list;
                List cfr_ignored_0 = (List)object;
                List cfr_ignored_1 = (List)object;
                fields[i].fields = this.collectNestedTypes((List<?>)list);
            }
            ++i;
        }
        return fields;
    }

    /*
     * WARNING - void declaration
     */
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object instanceof DBDValue) {
            return object;
        }
        String typeName = type.getTypeName();
        if (object == null) {
            return null;
        }
        if (this.structDataType != null) {
            Object object2 = object;
            if (object2 instanceof String) {
                String string = (String)object2;
                String cfr_ignored_0 = (String)object2;
                try {
                    void strValue;
                    Map map = JSONUtils.parseMap((Gson)gson, (Reader)new StringReader((String)strValue));
                    return this.convertStructToValue(session, this.columnFields, map);
                }
                catch (Exception e) {
                    throw new DBCException("Can't parse json: " + typeName, (Throwable)e);
                }
            }
            return super.getValueFromObject(session, type, object, copy, validateValue);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private Object convertStructToValue(DBCSession session, ColumnFieldInfo[] columnFields, Map<String, Object> struct) throws DBCException {
        void vm;
        LinkedHashMap result = new LinkedHashMap();
        Map<String, Object> value = struct.get("v");
        if (value == null) {
            value = struct;
        }
        List fieldValues = null;
        Map<String, Object> map = value;
        if (!(map instanceof Map)) {
            return this.transformValue(session, value, null);
        }
        Map<String, Object> map2 = map;
        fieldValues = JSONUtils.getObjectList((Map)vm, (String)"f");
        if (!CommonUtils.isEmpty((Collection)fieldValues)) {
            int i = 0;
            while (i < fieldValues.size()) {
                Map field = (Map)fieldValues.get(i);
                Object fieldValue = field.get("v");
                if (fieldValue == null) {
                    log.debug((Object)"Field value missing");
                } else if (columnFields == null) {
                    result.put("1", fieldValue);
                } else if (i < columnFields.length) {
                    ColumnFieldInfo columnField = columnFields[i];
                    fieldValue = this.transformValue(session, fieldValue, columnField);
                    result.put(columnField.name, fieldValue);
                } else {
                    log.debug((Object)("Field value out of index (" + i + ">=" + columnFields.length));
                }
                ++i;
            }
        }
        return new JDBCCompositeMap(session, this.structDataType, result);
    }

    /*
     * WARNING - void declaration
     */
    private Object transformValue(DBCSession session, Object fieldValue, ColumnFieldInfo columnField) throws DBCException {
        Object object = fieldValue;
        if (object instanceof List) {
            void listValue;
            List list = (List)object;
            List cfr_ignored_0 = (List)object;
            ArrayList<Object> result = new ArrayList<Object>(listValue.size());
            for (Object item : listValue) {
                result.add(this.transformValue(session, item, columnField));
            }
            fieldValue = new JDBCCollection(session.getProgressMonitor(), this.arrayDataType, (DBDValueHandler)this, result.toArray());
        } else {
            Object object2 = fieldValue;
            if (object2 instanceof Map) {
                Map result = (Map)object2;
                Map cfr_ignored_1 = (Map)object2;
                if (columnField != null && !ArrayUtils.isEmpty((Object[])columnField.fields)) {
                    fieldValue = this.convertStructToValue(session, columnField.fields, (Map<String, Object>)mapValue);
                } else {
                    Object nestedValue = mapValue.get("v");
                    if (nestedValue != null) {
                        fieldValue = nestedValue;
                    }
                }
            }
        }
        return fieldValue;
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        Object[] values;
        if (value instanceof JDBCComposite && !ArrayUtils.isEmpty((Object[])(values = ((JDBCComposite)value).getValues()))) {
            return DBValueFormatting.getDefaultValueDisplayString((Object)values, (DBDDisplayFormat)format);
        }
        return super.getValueDisplayString(column, value, format);
    }

    private static class ColumnFieldInfo {
        private final String name;
        private final String type;
        private final String mode;
        private ColumnFieldInfo[] fields;

        public ColumnFieldInfo(String name, String type, String mode) {
            this.name = name;
            this.type = type;
            this.mode = mode;
        }

        public String toString() {
            return this.name + "; type=" + this.type + "; mode=" + this.mode + "; fields=(" + Arrays.toString(this.fields) + ")";
        }
    }
}

