/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.security;

import com.dbeaver.model.internal.ModelMessages;
import com.dbeaver.model.security.DBPasswordValidator;
import com.google.gson.Gson;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.function.IntPredicate;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;

public class DefaultPasswordValidator
implements DBPasswordValidator {
    private int minLength = 8;
    private int minLetterCount = 1;
    private int minNumberCount = 1;
    private int minSymbolCount = 0;
    private boolean requireMixedCase = true;

    @NotNull
    public static DefaultPasswordValidator fromJson(@NotNull Reader reader) throws DBException {
        try {
            return (DefaultPasswordValidator)new Gson().fromJson(reader, DefaultPasswordValidator.class);
        }
        catch (Exception e) {
            throw new DBException("Failed to deserialize password policy", (Throwable)e);
        }
    }

    @Override
    public void validate(@NotNull String password) throws DBException {
        int symbolCount;
        int numberCount;
        int letterCount;
        if (this.minLength > 0 && password.length() < this.minLength) {
            throw new DBException(MessageFormat.format(ModelMessages.dialog_password_provider_min_length, this.minLength));
        }
        if (this.minLetterCount > 0 && (letterCount = DefaultPasswordValidator.countCodepoints(password, Character::isLetter)) < this.minLetterCount) {
            throw new DBException(MessageFormat.format(ModelMessages.dialog_password_provider_min_letters, this.minLetterCount));
        }
        if (this.minNumberCount > 0 && (numberCount = DefaultPasswordValidator.countCodepoints(password, Character::isDigit)) < this.minNumberCount) {
            throw new DBException(MessageFormat.format(ModelMessages.dialog_password_provider_min_numbers, this.minNumberCount));
        }
        if (this.minSymbolCount > 0 && (symbolCount = DefaultPasswordValidator.countCodepoints(password, DefaultPasswordValidator::isSymbol)) < this.minSymbolCount) {
            throw new DBException(MessageFormat.format(ModelMessages.dialog_password_provider_min_symbols, this.minSymbolCount));
        }
        if (this.requireMixedCase) {
            int upperCaseCount = DefaultPasswordValidator.countCodepoints(password, Character::isUpperCase);
            int lowerCaseCount = DefaultPasswordValidator.countCodepoints(password, Character::isLowerCase);
            if (upperCaseCount < 1 || lowerCaseCount < 1) {
                throw new DBException(ModelMessages.dialog_password_provider_mixed_case);
            }
        }
    }

    private static int countCodepoints(@NotNull String text, @NotNull IntPredicate predicate) {
        return (int)text.codePoints().filter(predicate).count();
    }

    private static boolean isSymbol(int codePoint) {
        return !Character.isLetterOrDigit(codePoint);
    }
}

