/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.auth;

import com.dbeaver.model.auth.SMServerAPI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.security.SMAuthCredentialsProfile;
import org.jkiss.dbeaver.model.security.SMAuthProviderCustomConfiguration;
import org.jkiss.dbeaver.model.security.SMAuthProviderDescriptor;
import org.jkiss.utils.CommonUtils;

public class SMAuthPromptConfiguration
implements Callback {
    private final SMServerAPI apiInfo;
    private final SMAuthProviderDescriptor[] providers;
    private String selectedProviderId;
    private String selectedProfileId;
    private String selectedConfigurationId;
    private Map<String, Object> authCredentials;
    private String authTitle;
    private SMSession mainSession;

    public SMAuthPromptConfiguration(SMServerAPI apiInfo, SMAuthProviderDescriptor[] providers, String defaultProviderId, Map<String, Object> authCredentials) {
        this.apiInfo = apiInfo;
        this.providers = providers;
        this.selectedProviderId = defaultProviderId;
        this.authCredentials = authCredentials;
    }

    public SMServerAPI getApiInfo() {
        return this.apiInfo;
    }

    public SMAuthProviderDescriptor[] getProviders() {
        return this.providers;
    }

    public SMAuthProviderDescriptor getSelectedProvider() {
        SMAuthProviderDescriptor[] sMAuthProviderDescriptorArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            SMAuthProviderDescriptor provider = sMAuthProviderDescriptorArray[n2];
            if (provider.getId().equals(this.selectedProviderId)) {
                return provider;
            }
            ++n2;
        }
        return null;
    }

    public String getSelectedProviderId() {
        return this.selectedProviderId;
    }

    public void setSelectedProviderId(String selectedProviderId) {
        this.selectedProviderId = selectedProviderId;
    }

    public SMAuthCredentialsProfile getSelectedProfile() {
        SMAuthProviderDescriptor provider = this.getSelectedProvider();
        if (provider == null) {
            return null;
        }
        List profiles = provider.getCredentialProfiles();
        if (CommonUtils.isEmpty((Collection)profiles)) {
            return null;
        }
        if (profiles.size() == 1) {
            return (SMAuthCredentialsProfile)profiles.get(0);
        }
        for (SMAuthCredentialsProfile profile : profiles) {
            if (!profile.getId().equals(this.selectedProfileId)) continue;
            return profile;
        }
        return null;
    }

    public String getSelectedProfileId() {
        return this.selectedProfileId;
    }

    public void setSelectedProfileId(String selectedProfileId) {
        this.selectedProfileId = selectedProfileId;
    }

    public SMAuthProviderCustomConfiguration getSelectedCustomConfiguration() {
        if (this.selectedConfigurationId == null) {
            return null;
        }
        SMAuthProviderDescriptor[] sMAuthProviderDescriptorArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            SMAuthProviderDescriptor ap = sMAuthProviderDescriptorArray[n2];
            if (ap.getCustomConfigurations() != null) {
                for (SMAuthProviderCustomConfiguration cc : ap.getCustomConfigurations()) {
                    if (!cc.getId().equals(this.selectedConfigurationId)) continue;
                    return cc;
                }
            }
            ++n2;
        }
        return null;
    }

    public String getSelectedConfigurationId() {
        return this.selectedConfigurationId;
    }

    public void setSelectedConfigurationId(String selectedConfigurationId) {
        this.selectedConfigurationId = selectedConfigurationId;
    }

    public Map<String, Object> getAuthCredentials() {
        return this.authCredentials;
    }

    public void setAuthCredentials(Map<String, Object> authCredentials) {
        this.authCredentials = authCredentials;
    }

    public SMSession getMainSession() {
        return this.mainSession;
    }

    public void setMainSession(SMSession mainSession) {
        this.mainSession = mainSession;
    }

    public String getAuthTitle() {
        return this.authTitle;
    }

    public void setAuthTitle(String authTitle) {
        this.authTitle = authTitle;
    }
}

