/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.utils.Base64;
import org.jkiss.utils.xml.XMLConstants;
import org.jkiss.utils.xml.XMLUtils;

public class XMLBuilder {
    private static final int STATE_NOTHING = 0;
    private static final int STATE_ELEM_OPENED = 1;
    private static final int STATE_TEXT_ADDED = 2;
    private static final int IO_BUFFER_SIZE = 8192;
    private Writer writer;
    private int state = 0;
    private Element element = null;
    private boolean butify = false;
    private List<Element> trashElements = new ArrayList<Element>();

    public XMLBuilder(OutputStream stream, String documentEncoding) throws IOException {
        this(stream, documentEncoding, true);
    }

    public XMLBuilder(OutputStream stream, String documentEncoding, boolean printHeader) throws IOException {
        if (documentEncoding == null) {
            this.init(new OutputStreamWriter(stream), null, printHeader);
        } else {
            this.init(new OutputStreamWriter(stream, documentEncoding), documentEncoding, printHeader);
        }
    }

    public XMLBuilder(Writer writer, String documentEncoding) throws IOException {
        this(writer, documentEncoding, true);
    }

    public XMLBuilder(Writer writer, String documentEncoding, boolean printHeader) throws IOException {
        this.init(writer, documentEncoding, printHeader);
    }

    private Element createElement(Element parent, String name) {
        if (this.trashElements.isEmpty()) {
            return new Element(parent, name);
        }
        Element element = this.trashElements.remove(this.trashElements.size() - 1);
        element.init(parent, name);
        return element;
    }

    private void deleteElement(Element element) {
        this.trashElements.add(element);
    }

    private void init(Writer writer, String documentEncoding, boolean printHeader) throws IOException {
        this.writer = new BufferedWriter(writer, 8192);
        if (printHeader) {
            if (documentEncoding != null) {
                this.writer.write(XMLConstants.XML_HEADER(documentEncoding));
            } else {
                this.writer.write(XMLConstants.XML_HEADER());
            }
        }
    }

    public boolean isButify() {
        return this.butify;
    }

    public void setButify(boolean butify) {
        this.butify = butify;
    }

    public Element startElement(String elementName) throws IOException {
        return this.startElement(null, null, elementName);
    }

    public Element startElement(String nsURI, String elementName) throws IOException {
        return this.startElement(nsURI, null, elementName);
    }

    public Element startElement(String nsURI, String nsPrefix, String elementName) throws IOException {
        boolean addNamespace;
        switch (this.state) {
            case 1: {
                this.writer.write(62);
            }
            case 0: {
                if (!this.butify) break;
                this.writer.write(10);
                break;
            }
        }
        if (this.butify && this.element != null) {
            int i = 0;
            while (i <= this.element.getLevel()) {
                this.writer.write(9);
                ++i;
            }
        }
        this.writer.write(60);
        boolean bl = addNamespace = nsURI != null;
        if (nsURI != null && nsPrefix == null && this.element != null && (nsPrefix = this.element.getNamespacePrefix(nsURI)) != null) {
            addNamespace = false;
        }
        if (nsPrefix != null) {
            elementName = nsPrefix + ":" + (String)elementName;
        }
        this.writer.write((String)elementName);
        this.state = 1;
        this.element = this.createElement(this.element, (String)elementName);
        if (addNamespace) {
            this.addNamespace(nsURI, nsPrefix);
            this.element.addNamespace(nsURI, nsPrefix);
        }
        return this.element;
    }

    public XMLBuilder endElement() throws IOException, IllegalStateException {
        if (this.element == null) {
            throw new IllegalStateException("Close tag without open");
        }
        switch (this.state) {
            case 1: {
                this.writer.write("/>");
                break;
            }
            case 0: {
                if (this.butify) {
                    this.writer.write(10);
                    int i = 0;
                    while (i < this.element.getLevel()) {
                        this.writer.write(9);
                        ++i;
                    }
                }
            }
            case 2: {
                this.writer.write("</");
                this.writer.write(this.element.getName());
                this.writer.write(62);
            }
        }
        this.deleteElement(this.element);
        this.element = this.element.parent;
        this.state = 0;
        return this;
    }

    public XMLBuilder addNamespace(String nsURI) throws IOException {
        return this.addNamespace(nsURI, null);
    }

    public XMLBuilder addNamespace(String nsURI, String nsPrefix) throws IOException, IllegalStateException {
        if (this.element == null) {
            throw new IllegalStateException("Namespace outside of element");
        }
        Object attrName = "xmlns";
        if (nsPrefix != null) {
            attrName = (String)attrName + ":" + nsPrefix;
            this.element.addNamespace(nsURI, nsPrefix);
        }
        this.addAttribute(null, (String)attrName, nsURI, true);
        return this;
    }

    public XMLBuilder addAttribute(String attributeName, String attributeValue) throws IOException {
        return this.addAttribute(null, attributeName, attributeValue, true);
    }

    public XMLBuilder addAttribute(String attributeName, int attributeValue) throws IOException {
        return this.addAttribute(null, attributeName, String.valueOf(attributeValue), false);
    }

    public XMLBuilder addAttribute(String attributeName, long attributeValue) throws IOException {
        return this.addAttribute(null, attributeName, String.valueOf(attributeValue), false);
    }

    public XMLBuilder addAttribute(String attributeName, boolean attributeValue) throws IOException {
        return this.addAttribute(null, attributeName, String.valueOf(attributeValue), false);
    }

    public XMLBuilder addAttribute(String attributeName, float attributeValue) throws IOException {
        return this.addAttribute(null, attributeName, String.valueOf(attributeValue), false);
    }

    public XMLBuilder addAttribute(String attributeName, double attributeValue) throws IOException {
        return this.addAttribute(null, attributeName, String.valueOf(attributeValue), false);
    }

    public XMLBuilder addAttribute(String nsURI, String attributeName, String attributeValue) throws IOException {
        return this.addAttribute(nsURI, attributeName, attributeValue, true);
    }

    private XMLBuilder addAttribute(String nsURI, String attributeName, String attributeValue, boolean escape) throws IOException, IllegalStateException {
        switch (this.state) {
            case 1: {
                if (nsURI != null) {
                    String nsPrefix = this.element.getNamespacePrefix(nsURI);
                    if (nsPrefix == null) {
                        throw new IllegalStateException("Unknown attribute '" + (String)attributeName + "' namespace URI '" + nsURI + "' in element '" + this.element.getName() + "'");
                    }
                    attributeName = nsPrefix + ":" + (String)attributeName;
                }
                this.writer.write(32);
                this.writer.write((String)attributeName);
                this.writer.write("=\"");
                this.writer.write(escape ? XMLUtils.escapeXml(attributeValue) : attributeValue);
                this.writer.write(34);
                break;
            }
            case 0: 
            case 2: {
                throw new IllegalStateException("Attribute ouside of element");
            }
        }
        return this;
    }

    public XMLBuilder addText(CharSequence textValue) throws IOException {
        return this.addText(textValue, true);
    }

    public XMLBuilder addText(CharSequence textValue, boolean escape) throws IOException {
        switch (this.state) {
            case 1: {
                this.writer.write(62);
            }
            case 0: 
            case 2: {
                break;
            }
        }
        this.writeText(textValue, escape);
        this.state = 2;
        return this;
    }

    public XMLBuilder addText(Reader reader) throws IOException {
        switch (this.state) {
            case 1: {
                this.writer.write(62);
            }
            case 0: 
            case 2: {
                break;
            }
        }
        this.writer.write("<![CDATA[");
        char[] writeBuffer = new char[8192];
        int br = reader.read(writeBuffer);
        while (br != -1) {
            this.writer.write(new String(writeBuffer, 0, br));
            br = reader.read(writeBuffer);
        }
        this.writer.write("]]>");
        this.state = 2;
        return this;
    }

    public XMLBuilder addTextData(String text) throws IOException {
        switch (this.state) {
            case 1: {
                this.writer.write(62);
            }
            case 0: 
            case 2: {
                break;
            }
        }
        this.writer.write("<![CDATA[");
        this.writer.write(text);
        this.writer.write("]]>");
        this.state = 2;
        return this;
    }

    public XMLBuilder addBinary(InputStream stream, int length) throws IOException {
        switch (this.state) {
            case 1: {
                this.writer.write(62);
            }
            case 0: 
            case 2: {
                break;
            }
        }
        Base64.encode(stream, (long)length, this.writer);
        this.state = 2;
        return this;
    }

    public XMLBuilder addBinary(byte[] buffer) throws IOException {
        switch (this.state) {
            case 1: {
                this.writer.write(62);
            }
            case 0: 
            case 2: {
                break;
            }
        }
        Base64.encode(buffer, 0, buffer.length, this.writer);
        this.state = 2;
        return this;
    }

    public XMLBuilder addContent(CharSequence textValue) throws IOException {
        this.writer.write(textValue.toString());
        return this;
    }

    public XMLBuilder addComment(String commentValue) throws IOException {
        switch (this.state) {
            case 1: {
                this.writer.write(62);
            }
            case 0: {
                if (!this.butify) break;
                this.writer.write(10);
                break;
            }
        }
        this.writer.write("<!--");
        this.writer.write(commentValue);
        this.writer.write("-->");
        if (this.butify) {
            this.writer.write(10);
        }
        this.state = 2;
        return this;
    }

    public XMLBuilder addElement(String elementName, String elementValue) throws IOException {
        this.startElement(elementName);
        this.addText(elementValue);
        this.endElement();
        return this;
    }

    public XMLBuilder addElementText(String elementName, String elementValue) throws IOException {
        this.startElement(elementName);
        this.addTextData(elementValue);
        this.endElement();
        return this;
    }

    public XMLBuilder flush() throws IOException {
        this.writer.flush();
        return this;
    }

    private XMLBuilder writeText(CharSequence textValue, boolean escape) throws IOException {
        if (textValue != null) {
            this.writer.write(escape ? XMLUtils.escapeXml(textValue) : textValue.toString());
        }
        return this;
    }

    public final class Element
    implements AutoCloseable {
        private Element parent;
        private String name;
        private Map<String, String> nsStack = null;
        private int level;

        Element(Element parent, String name) {
            this.init(parent, name);
        }

        void init(Element parent, String name) {
            this.parent = parent;
            this.name = name;
            this.nsStack = null;
            this.level = parent == null ? 0 : parent.level + 1;
        }

        public String getName() {
            return this.name;
        }

        public int getLevel() {
            return this.level;
        }

        public void addNamespace(String nsURI, String nsPrefix) {
            if (this.nsStack == null) {
                this.nsStack = new HashMap<String, String>();
            }
            this.nsStack.put(nsURI, nsPrefix);
        }

        public String getNamespacePrefix(String nsURI) {
            String prefix;
            if (nsURI.equals("http://www.w3.org/TR/REC-xml")) {
                return "xml";
            }
            String string = prefix = this.nsStack == null ? null : this.nsStack.get(nsURI);
            return prefix != null ? prefix : (this.parent != null ? this.parent.getNamespacePrefix(nsURI) : null);
        }

        @Override
        public void close() throws IOException {
            XMLBuilder.this.endElement();
        }
    }
}

