/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.salesforce.ui;

import com.dbeaver.db.salesforce.model.auth.SalesForceOAuthModel;
import com.dbeaver.db.salesforce.ui.SalesForceUIMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class SalesForceOAuthConfigurator
implements IObjectPropertyConfigurator<SalesForceOAuthModel, DBPDataSourceContainer> {
    private Text clientIDText;
    private Text clientSecretText;

    public void createControl(@NotNull Composite authPanel, SalesForceOAuthModel object, @NotNull Runnable propertyChangeListener) {
        this.clientIDText = UIUtils.createLabelText((Composite)authPanel, (String)SalesForceUIMessages.auth_configurator_client_id, (String)"", (int)0x400800);
        this.clientIDText.setMessage(SalesForceUIMessages.auth_configurator_client_id_message);
        this.clientIDText.setToolTipText(SalesForceUIMessages.auth_configurator_client_id_tip);
        this.clientSecretText = UIUtils.createLabelText((Composite)authPanel, (String)SalesForceUIMessages.auth_configurator_client_secret, (String)"", (int)0x400800);
        this.clientSecretText.setMessage(SalesForceUIMessages.auth_configurator_client_secret_message);
        this.clientSecretText.setToolTipText(SalesForceUIMessages.auth_configurator_client_secret_tip);
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        DBPConnectionConfiguration connectionInfo = dataSourceContainer.getConnectionConfiguration();
        if (this.clientIDText != null && !this.clientIDText.isDisposed()) {
            this.clientIDText.setText(CommonUtils.notEmpty((String)connectionInfo.getAuthProperty("client_id")));
        }
        if (this.clientSecretText != null && !this.clientSecretText.isDisposed()) {
            this.clientSecretText.setText(CommonUtils.notEmpty((String)connectionInfo.getAuthProperty("client_secret")));
        }
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        DBPConnectionConfiguration connectionInfo = dataSourceContainer.getConnectionConfiguration();
        if (this.clientIDText != null && !this.clientIDText.isDisposed()) {
            connectionInfo.setAuthProperty("client_id", this.clientIDText.getText().trim());
        }
        if (this.clientSecretText != null && !this.clientSecretText.isDisposed()) {
            connectionInfo.setAuthProperty("client_secret", this.clientSecretText.getText().trim());
        }
    }

    public void resetSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        this.loadSettings(dataSourceContainer);
    }

    public boolean isComplete() {
        return !this.clientIDText.getText().isEmpty();
    }
}

