/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird;

import java.lang.reflect.InvocationTargetException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdProcedureParameter;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTrigger;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTriggerType;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedureParameter;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Version;

public class FireBirdUtils {
    private static final Log log = Log.getLog(FireBirdUtils.class);
    private static Pattern VERSION_PATTERN = Pattern.compile(".+\\-V([0-9]+\\.[0-9]+\\.[0-9]+).+");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getProcedureSource(DBRProgressMonitor monitor, GenericProcedure procedure) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)procedure, (String)"Load procedure source code");){
                String source = "";
                if (procedure.getProcedureType() == DBSProcedureType.PROCEDURE) {
                    DatabaseMetaData fbMetaData = session.getOriginal().getMetaData();
                    source = (String)fbMetaData.getClass().getMethod("getProcedureSourceCode", String.class).invoke((Object)fbMetaData, procedure.getName());
                    if (!CommonUtils.isEmpty((String)source)) return FireBirdUtils.getProcedureSourceWithHeader(monitor, procedure, source);
                    return null;
                }
                if (!((GenericDataSource)procedure.getDataSource()).isServerVersionAtLeast(3, 0)) return null;
                String sql = "SELECT RDB$FUNCTION_SOURCE FROM RDB$FUNCTIONS WHERE RDB$FUNCTION_NAME =?";
                Throwable throwable2 = null;
                Object var8_14 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
                    dbStat.setString(1, procedure.getName());
                    Throwable throwable3 = null;
                    Object var11_19 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (!dbResult.nextRow()) return FireBirdUtils.getProcedureSourceWithHeader(monitor, procedure, source);
                        source = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
                        return FireBirdUtils.getProcedureSourceWithHeader(monitor, procedure, source);
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                            throw throwable3;
                        }
                        if (throwable3 == throwable4) throw throwable3;
                        throwable3.addSuppressed(throwable4);
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                        throw throwable2;
                    }
                    if (throwable2 == throwable5) throw throwable2;
                    throwable2.addSuppressed(throwable5);
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                    throw throwable;
                }
                if (throwable == throwable6) throw throwable;
                throwable.addSuppressed(throwable6);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Can't read source code of procedure '" + procedure.getName() + "'", (Throwable)e);
        }
        catch (Exception e) {
            log.debug((Object)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getViewSource(DBRProgressMonitor monitor, GenericTableBase view) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)view, (String)"Load view source code");){
                DatabaseMetaData fbMetaData = session.getOriginal().getMetaData();
                String source = (String)fbMetaData.getClass().getMethod("getViewSourceCode", String.class).invoke((Object)fbMetaData, view.getName());
                if (!CommonUtils.isEmpty((String)source)) return FireBirdUtils.getViewSourceWithHeader(monitor, view, source);
                return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Can't read source code of view '" + view.getName() + "'", (Throwable)e);
        }
        catch (Exception e) {
            log.debug((Object)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getTriggerSource(DBRProgressMonitor monitor, FireBirdTrigger trigger) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)trigger, (String)"Load trigger source code");){
                DatabaseMetaData fbMetaData = session.getOriginal().getMetaData();
                String source = (String)fbMetaData.getClass().getMethod("getTriggerSourceCode", String.class).invoke((Object)fbMetaData, trigger.getName());
                if (!CommonUtils.isEmpty((String)source)) return FireBirdUtils.getTriggerSourceWithHeader(monitor, trigger, source);
                return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Can't read source code of trigger '" + trigger.getName() + "'", (Throwable)e);
        }
        catch (Exception e) {
            log.debug((Object)e);
            return null;
        }
    }

    private static String getProcedureSourceWithHeader(DBRProgressMonitor monitor, GenericProcedure procedure, String source) throws DBException {
        StringBuilder sql = new StringBuilder();
        boolean isFunction = procedure.getProcedureType() == DBSProcedureType.FUNCTION;
        sql.append("CREATE OR ALTER ");
        if (isFunction) {
            sql.append("FUNCTION");
        } else {
            sql.append("PROCEDURE");
        }
        sql.append(" ").append(procedure.getName()).append(" ");
        Collection parameters = procedure.getParameters(monitor);
        if (parameters != null && !parameters.isEmpty()) {
            GenericProcedureParameter param;
            ArrayList<GenericProcedureParameter> args = new ArrayList<GenericProcedureParameter>();
            ArrayList<GenericProcedureParameter> results = new ArrayList<GenericProcedureParameter>();
            for (GenericProcedureParameter param2 : parameters) {
                if (param2.getParameterKind() == DBSProcedureParameterKind.OUT || param2.getParameterKind() == DBSProcedureParameterKind.RETURN) {
                    results.add(param2);
                    continue;
                }
                args.add(param2);
            }
            Map<String, List<String>> domainNames = new HashMap();
            Object object = null;
            Object var10_14 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)procedure, (String)"Load domains used in procedure");){
                try {
                    Throwable throwable = null;
                    Object var13_20 = null;
                    try (JDBCPreparedStatement stmt = session.prepareStatement("SELECT RDB$PARAMETER_NAME, RDB$FIELD_SOURCE, RDB$DEFAULT_SOURCE FROM RDB$PROCEDURE_PARAMETERS rpp WHERE RDB$PROCEDURE_NAME = ? AND LEFT(rpp.RDB$FIELD_SOURCE, 4) <> 'RDB$'");){
                        stmt.setString(1, procedure.getName());
                        Throwable throwable2 = null;
                        Object var16_25 = null;
                        try (JDBCResultSet rs = stmt.executeQuery();){
                            while (rs.next()) {
                                String paramName = JDBCUtils.safeGetString((ResultSet)rs, (int)1);
                                String domainName = JDBCUtils.safeGetString((ResultSet)rs, (int)2);
                                String defaultValue = JDBCUtils.safeGetString((ResultSet)rs, (int)3);
                                if (paramName == null || domainName == null) continue;
                                if (CommonUtils.isNotEmpty((String)defaultValue)) {
                                    domainNames.put(paramName.trim(), new ArrayList<String>(Arrays.asList(domainName.trim(), defaultValue.trim())));
                                    continue;
                                }
                                domainNames.put(paramName.trim(), new ArrayList<String>(Collections.singletonList(domainName.trim())));
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw new DBException("Unable to load domains used in procedure", (Throwable)e);
                }
                domainNames = Collections.unmodifiableMap(domainNames);
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
            if (!args.isEmpty()) {
                sql.append("(");
                int i = 0;
                while (i < args.size()) {
                    param = (GenericProcedureParameter)args.get(i);
                    if (param.getParameterKind() != DBSProcedureParameterKind.RETURN) {
                        if (i > 0) {
                            sql.append(", ");
                        }
                        FireBirdUtils.printParam(sql, param, domainNames);
                    }
                    ++i;
                }
                sql.append(")\n");
            }
            if (!results.isEmpty()) {
                sql.append("RETURNS ");
                if (isFunction) {
                    GenericProcedureParameter param3 = (GenericProcedureParameter)results.get(0);
                    FireBirdUtils.addProcedureType(sql, param3);
                    sql.append("\n");
                } else {
                    sql.append("(\n");
                    int i = 0;
                    while (i < results.size()) {
                        sql.append('\t');
                        param = (GenericProcedureParameter)results.get(i);
                        FireBirdUtils.printParam(sql, param, domainNames);
                        if (i < results.size() - 1) {
                            sql.append(",");
                        }
                        sql.append('\n');
                        ++i;
                    }
                    sql.append(")\n");
                }
            }
        }
        sql.append("AS\n").append(source);
        return sql.toString();
    }

    private static void printParam(StringBuilder sql, GenericProcedureParameter param, Map<String, List<String>> domainNames) {
        String defaultValue;
        String paramName = DBUtils.getQuotedIdentifier((DBSObject)param);
        sql.append(paramName).append(" ");
        List<String> domainParameters = domainNames.get(paramName.trim());
        if (!CommonUtils.isEmpty(domainParameters)) {
            StringJoiner paramsJoiner = new StringJoiner(" ");
            for (String parameter : domainParameters) {
                paramsJoiner.add(parameter);
            }
            sql.append(paramsJoiner.toString());
            return;
        }
        FireBirdUtils.addProcedureType(sql, param);
        boolean notNull = param.isRequired();
        if (notNull) {
            sql.append(" NOT NULL");
        }
        if (param instanceof FireBirdProcedureParameter && param.getParameterKind() == DBSProcedureParameterKind.IN && !CommonUtils.isEmpty((String)(defaultValue = ((FireBirdProcedureParameter)param).getDefaultValue()))) {
            sql.append(" ").append(defaultValue);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static void addProcedureType(@NotNull StringBuilder sql, @NotNull GenericProcedureParameter param) {
        GenericDataSource dataSource = param.getDataSource();
        GenericProcedureParameter genericProcedureParameter = param;
        if (genericProcedureParameter instanceof FireBirdProcedureParameter) {
            void par;
            FireBirdProcedureParameter fireBirdProcedureParameter = (FireBirdProcedureParameter)genericProcedureParameter;
            FireBirdProcedureParameter cfr_ignored_0 = (FireBirdProcedureParameter)genericProcedureParameter;
            if (CommonUtils.isNotEmpty((String)par.getFieldName()) && CommonUtils.isNotEmpty((String)par.getRelationName())) {
                sql.append(" TYPE OF COLUMN ").append(DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)par.getRelationName())).append(".").append(DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)par.getFieldName()));
                return;
            }
        }
        sql.append(param.getTypeName());
        String typeModifiers = SQLUtils.getColumnTypeModifiers((DBPDataSource)dataSource, (DBSTypedObject)param, (String)param.getTypeName(), (DBPDataKind)param.getDataKind());
        if (typeModifiers == null) return;
        sql.append(typeModifiers);
    }

    public static String getViewSourceWithHeader(DBRProgressMonitor monitor, GenericTableBase view, String source) throws DBException {
        Version version = FireBirdUtils.getFireBirdServerVersion(view.getDataSource());
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE ");
        if (version.getMajor() > 2 || version.getMajor() == 2 && version.getMinor() >= 5) {
            sql.append("OR ALTER ");
        }
        sql.append("VIEW ").append(view.getName()).append(" ");
        List columns = view.getAttributes(monitor);
        if (columns != null) {
            sql.append("(");
            boolean first = true;
            for (GenericTableColumn column : columns) {
                if (!first) {
                    sql.append(", ");
                }
                first = false;
                sql.append(DBUtils.getQuotedIdentifier((DBSObject)column));
            }
            sql.append(")\n");
        }
        sql.append("AS\n").append(source);
        return sql.toString();
    }

    public static String getTriggerSourceWithHeader(DBRProgressMonitor monitor, FireBirdTrigger trigger, String source) throws DBException {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TRIGGER ").append(trigger.getName()).append(" ");
        FireBirdTriggerType type = trigger.getType();
        if (type.isDbEvent()) {
            sql.append(type.getDisplayName());
        } else if (trigger.getTable() != null) {
            sql.append("FOR ").append(DBUtils.getQuotedIdentifier((DBSObject)trigger.getTable()));
            sql.append(" ").append(type.getDisplayName());
        }
        sql.append("\n").append(source);
        return sql.toString();
    }

    public static String getPlan(JDBCPreparedStatement statement) {
        String plan = "";
        try {
            plan = (String)statement.getOriginal().getClass().getMethod("getExecutionPlan", new Class[0]).invoke((Object)statement.getOriginal(), new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return plan;
    }

    public static Version getFireBirdServerVersion(DBPDataSource dataSource) {
        String versionInfo = dataSource.getInfo().getDatabaseProductVersion();
        Matcher matcher = VERSION_PATTERN.matcher(versionInfo);
        if (matcher.matches()) {
            return new Version(matcher.group(1));
        }
        return new Version(0, 0, 0);
    }

    /*
     * Exception decompiling
     */
    public static Map<String, String> readColumnDomainTypes(DBRProgressMonitor monitor, GenericTableBase table) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

