/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.jdbc.DateObject;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;

public class TdsDateTime {
    private static final int BASEBIAS = 693595;
    private static final int BASEYEAR = 1;
    private static final int CENTURY_ADJUST = 52;
    private static final int TIMEMASK = 0x1FFFFFF;
    private static final int C300TH_P_HOUR = 1080000;
    private static final int C300TH_P_MIN = 18000;
    private static final int BASE_YEAR = 1970;
    private static final int[] MONTHDAYS = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] LMONTHDAYS = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int YEAR = 0;
    private static final int MONTH = 1;
    private static final int DAY = 2;
    private static final int HOUR = 3;
    private static final int MINUTE = 4;
    private static final int SECS = 5;
    public static final int DATETIME = 1;
    public static final int SMALLDATETIME = 2;
    public static final int DATE = 3;
    public static final int TIME = 4;
    public static final int BIGDATETIME = 5;
    public static final int BIGTIME = 6;
    public static final long MAXBIGDATETIME = 315569519999999999L;
    public static final long MINBIGDATETIME = 31622400000000L;
    private static final long microSecondsInADay = 86400000000L;
    private static final long microsecsInaSecond = 1000000L;
    private static final long microsecInaHour = 3600000000L;
    private static final long microSecInaMin = 60000000L;
    int[] _timestamp = new int[]{0, 0, 0, 0, 0, 0};
    long _nano = 0L;
    DateObject _dateObj = null;
    int _type = 0;

    public TdsDateTime(BigDecimal bigDecimal, int n) {
        this._type = n;
        long l = bigDecimal.longValue();
        if (n == 5) {
            this.calculateBigDatetime(l, this._timestamp);
        } else if (n == 6) {
            long l2 = l / 86400000000L;
            this.calculateBigtime(l, l2);
            this._timestamp[0] = 1;
            this._timestamp[1] = 0;
            this._timestamp[2] = 1;
        }
    }

    public TdsDateTime(int n, int n2, int n3) {
        this._type = n3;
        if (n3 == 1) {
            TdsDateTime.numToYearMonthDay(n, this._timestamp);
            this.convertFourByteTime(n2);
        } else if (n3 == 2) {
            TdsDateTime.numToYearMonthDay(n, this._timestamp);
            this.convertTwoByteTime(n2);
        } else if (n3 == 3) {
            TdsDateTime.numToYearMonthDay(n, this._timestamp);
        } else if (n3 == 4) {
            this.convertFourByteTime(n2);
            this._timestamp[0] = 1970;
            this._timestamp[1] = 0;
            this._timestamp[2] = 1;
        }
    }

    private void convertFourByteTime(int n) {
        this._timestamp[3] = (n &= 0x1FFFFFF) / 1080000;
        this._timestamp[4] = n / 18000 % 60;
        this._timestamp[5] = n / 300 % 60;
        this._nano = (long)n % 300L * 10000000L / 3L;
    }

    private void convertTwoByteTime(int n) {
        this._timestamp[3] = n / 60;
        this._timestamp[4] = n % 60;
    }

    public static int[] tdsDateTime(DateObject dateObject) {
        int[] nArray = new int[]{0, 0, 0};
        Calendar calendar = dateObject.getCalendar();
        int n = dateObject.getBaseType();
        int n2 = 1970;
        int n3 = 0;
        int n4 = 0;
        if (n == 91 || n == 93) {
            n2 = calendar.get(1);
            n3 = calendar.get(2);
            n4 = calendar.get(5) - 1;
        }
        nArray[0] = TdsDateTime.ymdToNum(n2, n3, n4);
        if (n == 92 || n == 93) {
            int n5 = calendar.get(11);
            int n6 = calendar.get(12);
            int n7 = calendar.get(13);
            double d = dateObject.getNanos();
            nArray[2] = n5 * 60 + n6;
            int n8 = (int)Math.round(d * 3.0 / 1.0E7);
            nArray[1] = (nArray[2] * 60 + n7) * 300 + n8;
            if (d != 0.0 && n8 == 300) {
                nArray[1] = nArray[1] - 1;
            }
        }
        return nArray;
    }

    public static long tdsDateTime(DateObject dateObject, int n) {
        long l;
        long l2;
        long l3;
        Calendar calendar = dateObject.getCalendar();
        int n2 = dateObject.getBaseType();
        int n3 = 1970;
        int n4 = 0;
        int n5 = 0;
        if (n2 == 91 || n2 == 93) {
            n3 = calendar.get(1);
            n4 = calendar.get(2);
            n5 = calendar.get(5) - 1;
        }
        int n6 = TdsDateTime.ymdToNum(n3, n4, n5);
        n6 += 693595;
        n6 += 366;
        int n7 = calendar.get(11);
        int n8 = calendar.get(12);
        int n9 = calendar.get(13);
        int n10 = dateObject.getNanos() % 10000000;
        long l4 = dateObject.getNanos() / 1000;
        if (n10 == 6666666 || n10 == 3333333 || n10 == 0) {
            l4 = calendar.get(14) * 1000;
        }
        long l5 = 0L;
        long l6 = n6;
        if (n == 187) {
            l5 = l6 * 86400000000L;
        }
        if ((l3 = (long)n7) > 0L) {
            l5 += l3 * 3600000000L;
        }
        if ((l2 = (long)n8) > 0L) {
            l5 += l2 * 60000000L;
        }
        if ((l = (long)n9) > 0L) {
            l5 += l * 1000000L;
        }
        long l7 = l4;
        if (l4 > 0L) {
            l5 += l7;
        }
        return l5;
    }

    public DateObject dateObjectValue() throws SQLException {
        return this.dateObjectValue(null);
    }

    public DateObject dateObjectValue(Calendar calendar) throws SQLException {
        if (this._dateObj == null) {
            this._dateObj = this.convertToDateObject(calendar);
        }
        return this._dateObj;
    }

    public String stringValue() {
        StringBuffer stringBuffer = new StringBuffer(26);
        if (this._type != 4 && this._type != 6) {
            for (int i = 4; Integer.toString(this._timestamp[0]).length() < i; --i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(this._timestamp[0]);
            stringBuffer.append('-');
            if (this._timestamp[1] < 9) {
                stringBuffer.append('0');
            }
            stringBuffer.append(this._timestamp[1] + 1);
            stringBuffer.append('-');
            if (this._timestamp[2] < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(this._timestamp[2]);
        }
        if (this._type != 3) {
            String string;
            double d = (double)this._nano / 1.0E9;
            if (d == 0.0) {
                string = this._type == 5 || this._type == 6 ? "000000" : "0.0";
            } else {
                string = String.valueOf(d);
                if (this._type == 5 || this._type == 6) {
                    int n = 6;
                    string = String.valueOf((int)this._nano / 1000);
                    while (string.length() < n) {
                        string = "0" + string;
                    }
                } else if (string.length() > 5) {
                    string = string.substring(0, 5);
                }
            }
            if (this._type != 4) {
                stringBuffer.append(' ');
            }
            if (this._timestamp[3] < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(this._timestamp[3]);
            stringBuffer.append(':');
            if (this._timestamp[4] < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(this._timestamp[4]);
            stringBuffer.append(':');
            if (this._timestamp[5] < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(this._timestamp[5]);
            stringBuffer.append('.');
            if (this._type == 5 || this._type == 6) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append(string.substring(2));
            }
        }
        return stringBuffer.toString();
    }

    private void calculateBigDatetime(long l, int[] nArray) {
        long l2 = l / 86400000000L;
        int n = (int)l2;
        n -= 693595;
        TdsDateTime.numToYearMonthDay(n -= 366, this._timestamp);
        this.calculateBigtime(l, l2);
    }

    private void calculateBigtime(long l, long l2) {
        long l3 = 86400000000L * l2;
        l3 = l - l3;
        long l4 = l3 / 3600000000L;
        this._timestamp[3] = (int)l4;
        long l5 = l3 % 3600000000L;
        long l6 = l5 / 60000000L;
        this._timestamp[4] = (int)l6;
        long l7 = (l5 %= 60000000L) / 1000000L;
        this._timestamp[5] = (int)l7;
        this._nano = (l5 %= 1000000L) * 1000L;
    }

    private static void numToYearMonthDay(int n, int[] nArray) {
        int n2;
        int n3;
        int n4 = (n += 693595) / 365;
        while ((n3 = n - (n4 * 365 + (n2 = TdsDateTime.leapcnt(n4)))) < 0) {
            --n4;
        }
        int[] nArray2 = MONTHDAYS;
        if (TdsDateTime.leapyear(n4)) {
            nArray2 = LMONTHDAYS;
        }
        ++n4;
        int n5 = n3;
        int n6 = 0;
        while (n5 >= nArray2[n6]) {
            n5 -= nArray2[n6];
            ++n6;
        }
        nArray[0] = n4;
        nArray[1] = n6;
        nArray[2] = n5 + 1;
    }

    private static int ymdToNum(int n, int n2, int n3) {
        int n4 = --n * 365 + TdsDateTime.leapcnt(n);
        int[] nArray = MONTHDAYS;
        if (TdsDateTime.leapyear(n)) {
            nArray = LMONTHDAYS;
        }
        for (int i = 0; i < n2; ++i) {
            n4 += nArray[i];
        }
        n4 += n3;
        return n4 -= 693595;
    }

    private static boolean leapyear(int n) {
        boolean bl = ++n % 4 == 0 && n % 100 != 0 || n % 400 == 0;
        return bl;
    }

    private static int leapcnt(int n) {
        int n2 = n / 100;
        int n3 = n / 4 - n2 + n2 / 4;
        return n3;
    }

    private DateObject convertToDateObject(Calendar calendar) throws SQLException {
        DateObject dateObject = null;
        dateObject = new DateObject(calendar);
        Calendar calendar2 = dateObject.getCalendar();
        calendar2.set(1, this._timestamp[0]);
        calendar2.set(2, this._timestamp[1]);
        calendar2.set(5, this._timestamp[2]);
        calendar2.set(11, this._timestamp[3]);
        calendar2.set(12, this._timestamp[4]);
        calendar2.set(13, this._timestamp[5]);
        calendar2.set(14, (int)this._nano / 1000000);
        dateObject.setNanos((int)this._nano);
        return dateObject;
    }
}

