/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.security.asn1;

import com.sybase.jdbc4.security.asn1.ASN1OutputStream;
import com.sybase.jdbc4.security.asn1.DEREncodable;
import com.sybase.jdbc4.security.asn1.DERObject;
import com.sybase.jdbc4.security.asn1.DEROutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class ASN1Encodable
implements DEREncodable {
    public static final String DER = "DER";
    public static final String BER = "BER";

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(this);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getEncoded(String string) throws IOException {
        if (string.equals(DER)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream.writeObject(this);
            return byteArrayOutputStream.toByteArray();
        }
        return this.getEncoded();
    }

    public byte[] getDEREncoded() {
        try {
            return this.getEncoded(DER);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int hashCode() {
        return this.toASN1Object().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DEREncodable)) {
            return false;
        }
        DEREncodable dEREncodable = (DEREncodable)object;
        return this.toASN1Object().equals(dEREncodable.getDERObject());
    }

    @Override
    public DERObject getDERObject() {
        return this.toASN1Object();
    }

    public abstract DERObject toASN1Object();
}

