/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.Cursor;
import com.sybase.jdbc4.jdbc.DateObject;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.JdbcDataObject;
import com.sybase.jdbc4.jdbc.LimiterInputStream;
import com.sybase.jdbc4.jdbc.Param;
import com.sybase.jdbc4.jdbc.ParamManager;
import com.sybase.jdbc4.jdbc.ProtocolResultSet;
import com.sybase.jdbc4.jdbc.SybResultSet;
import com.sybase.jdbc4.jdbc.SybStatement;
import com.sybase.jdbc4.tds.SybBigDecimal;
import com.sybase.jdbc4.utils.Debug;
import com.sybase.jdbc4.utils.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class SybCursorResultSet
extends SybResultSet
implements com.sybase.jdbcx.SybCursorResultSet {
    private static final Logger LOG = Logger.getLogger(SybCursorResultSet.class.getName());
    private AtomicLong _apiCount = new AtomicLong(0L);
    protected Cursor _cursor;
    protected ParamManager _paramMgr;
    protected ParamManager _insertParamMgr;
    protected boolean _rowDeleted = false;
    protected boolean _rowUpdated = false;
    protected boolean _rowInserted = false;
    private int _savedCurrentRow = -4;
    private int _logIdCounter = 0;

    protected SybCursorResultSet(String string, SybStatement sybStatement, ProtocolResultSet protocolResultSet) throws SQLException {
        super(string, sybStatement, protocolResultSet);
        this._cursor = this._statement._cursor;
        this._concurType = this._cursor.getConcurrency();
        if (this._concurType != 1007) {
            int n = protocolResultSet.getMetaData().getColumnCount();
            this._paramMgr = new ParamManager(n, sybStatement);
            this._insertParamMgr = new ParamManager(n, sybStatement);
        }
        this._logId = string + "_Cr" + this._logIdCounter++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCursorName() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            String string = this._cursor.getName();
            return string;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "getCursorName", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConcurrency() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (this._cursor == null) {
                ErrorMessage.raiseError("JZ00D");
            }
            int n = this._cursor.getConcurrency();
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "getConcurrency", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkResultSet();
            this.clearWarnings();
            this.moveToCurrentRow();
            if (this.checkRowIndexBeforeProtocolNext()) {
                boolean bl2 = false;
                return bl2;
            }
            if (this._paramMgr != null) {
                try {
                    this._paramMgr.clearParamArray(true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this._rowDeleted = false;
            this._rowUpdated = false;
            this._rowInserted = false;
            boolean bl3 = this._prs.next();
            if (!bl3) {
                this.prepareForNextFetch();
                this._prs = this._cursor.fetch();
                bl3 = this._prs == null ? false : this._prs.next();
            }
            if (!bl3) {
                if (this._statement != null && this._prs != null) {
                    this._statement.setRowCount(this._prs.getCount());
                }
                this.adjustRowIndexesAfterProtocolNext();
            }
            boolean bl4 = bl3;
            return bl4;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "next", null, null, l);
            }
        }
    }

    protected void prepareForNextFetch() throws SQLException {
        SQLWarning sQLWarning = this._prs.getWarnings();
        this._prs.clearWarnings();
        if (this._savedWarnings != null) {
            this._savedWarnings.setNextWarning(sQLWarning);
        } else {
            this._savedWarnings = sQLWarning;
        }
        this._prs.close(false);
        if (this._cm != null) {
            this._cm.doneReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToCurrentRow() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (this._rowIndex == -3) {
                this._rowIndex = this._savedCurrentRow;
                this._rowInserted = false;
            }
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "moveToCurrentRow", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToInsertRow() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (this._concurType == 1008) {
                if (this._rowIndex != -3) {
                    this._savedCurrentRow = this._rowIndex;
                    this._rowIndex = -3;
                    try {
                        this._insertParamMgr.clearParamArray(true);
                    }
                    catch (IOException iOException) {
                        ErrorMessage.raiseError("JZ006", iOException.getMessage());
                    }
                }
            } else {
                ErrorMessage.raiseError("JZ0BT", "moveToInsertRow()", this._concurTypeString);
            }
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "moveToInsertRow", null, null, l);
            }
        }
    }

    @Override
    protected void close(boolean bl) throws SQLException {
        this._cursor.close(true);
        super.close(bl);
    }

    @Override
    public boolean isLanguageCursor() {
        return this._cursor.isLanguageCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setFetchSize(int n) throws SQLException {
        long l;
        boolean bl;
        block5: {
            bl = LogUtil.isLoggingEnabled(LOG);
            l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                if (n != 0) break block5;
                if (!bl) return;
            }
            catch (Throwable throwable) {
                if (!bl) throw throwable;
                LogUtil.logEnd(LOG, null, null, this._logId, "setFetchSize", "int", new Object[]{n}, l);
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "setFetchSize", "int", new Object[]{n}, l);
            return;
        }
        int n2 = this._statement.getMaxRows();
        if (n < 0 || n2 > 0 && n > n2) {
            ErrorMessage.raiseError("JZ0BI");
        }
        this._cursor.setFetchSize(n);
        if (!bl) return;
        LogUtil.logEnd(LOG, null, null, this._logId, "setFetchSize", "int", new Object[]{n}, l);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this._cursor.getFetchSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRow() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            int n;
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("insertRow()");
            if (this._rowIndex != -3) {
                ErrorMessage.raiseError("JZ0BR", "insertRow()");
            }
            String string = "INSERT INTO " + this._cursor.getTable() + " ";
            ResultSetMetaData resultSetMetaData = this._prs.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            Param[] paramArray = this._insertParamMgr.getParams();
            boolean bl2 = true;
            for (n = 0; n < n2; ++n) {
                if (paramArray[n]._sqlType == -999) continue;
                string = !bl2 ? string + ", " : string + "( ";
                string = string + resultSetMetaData.getColumnName(n + 1);
                bl2 = false;
            }
            if (!bl2) {
                string = string + " ) ";
                bl2 = true;
            }
            string = string + "VALUES (";
            n = string.length();
            for (int i = 0; i < n2; ++i) {
                if (paramArray[i]._sqlType == -999) {
                    paramArray[i]._sqlType = -998;
                    continue;
                }
                if (!bl2) {
                    string = string + ", ";
                    n += 2;
                }
                string = string + "?";
                bl2 = false;
                paramArray[i]._paramMarkerOffset = n++;
            }
            if (1 == this._cursor.insert(this._prs, this._insertParamMgr, string = string + ")")) {
                this._rowInserted = true;
            }
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "insertRow", null, null, l);
            }
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this._rowUpdated;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this._rowDeleted;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this._rowInserted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateNull(int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateNull(int)");
            Object object = null;
            int n2 = this.getMetaData().getColumnType(n);
            if (n2 == 2005) {
                object = this._pc._conn._nullClob;
            } else if (n2 == 2004) {
                object = this._pc._conn._nullBlob;
            }
            this.setParam(n2, n, object);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateNull", "int", new Object[]{n}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateNull", "int", new Object[]{n}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        boolean bl2 = LogUtil.isLoggingEnabled(LOG);
        long l = bl2 ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl2) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateBoolean(int, boolean)");
            Boolean bl3 = new Boolean(bl);
            this.setParam(-7, n, bl3);
            if (!bl2) return;
        }
        catch (Throwable throwable) {
            if (!bl2) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateBoolean", "int, boolean", new Object[]{n, bl}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateBoolean", "int, boolean", new Object[]{n, bl}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateByte(int n, byte by) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateByte(int, byte)");
            Integer n2 = new Integer(by);
            if (n2 < 0) {
                this.setParam(5, n, n2);
            } else {
                this.setParam(-6, n, n2);
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateByte", "int, byte", new Object[]{n, by}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateByte", "int, byte", new Object[]{n, by}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateShort(int n, short s) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateShort(int, short)");
            Integer n2 = new Integer(s);
            this.setParam(5, n, n2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateShort", "int, short", new Object[]{n, s}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateShort", "int, short", new Object[]{n, s}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateInt(int n, int n2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateInt(int, int)");
            Integer n3 = new Integer(n2);
            this.setParam(4, n, n3);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateInt", "int, int", new Object[]{n, n2}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateInt", "int, int", new Object[]{n, n2}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateLong(int n, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            this.checkUpdatability("updateLong(int, long)");
            Long l3 = new Long(l);
            this.setParam(-5, n, l3);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateLong", "int, long", new Object[]{n, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateLong", "int, long", new Object[]{n, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateFloat(int n, float f) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateFloat(int, float)");
            Float f2 = new Float(f);
            this.setParam(7, n, f2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateFloat", "int, float", new Object[]{n, Float.valueOf(f)}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateFloat", "int, float", new Object[]{n, Float.valueOf(f)}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateDouble(int n, double d) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateDouble(int, double)");
            Double d2 = new Double(d);
            this.setParam(8, n, d2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateDouble", "int, double", new Object[]{n, d}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateDouble", "int, double", new Object[]{n, d}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateBigDecimal(int, BigDecimal)");
            if (bigDecimal == null) {
                this.setParam(2, n, bigDecimal);
            } else {
                this.setParam(2, n, bigDecimal, bigDecimal.scale());
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateBigDecimal", "int, BigDecimal", new Object[]{n, bigDecimal}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateBigDecimal", "int, BigDecimal", new Object[]{n, bigDecimal}, l);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal, int n2, int n3) throws SQLException {
        this.checkUpdatability("updateBigDecimal(int, BigDecimal, int, int)");
        if (bigDecimal == null) {
            bigDecimal = new BigDecimal("0");
        }
        SybBigDecimal sybBigDecimal = new SybBigDecimal(bigDecimal, n2, n3);
        this.setParam(2, n, sybBigDecimal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateString(int n, String string) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateString(int, String)");
            this.setParam(12, n, string);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateString", "int, String", new Object[]{n, string}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateString", "int, String", new Object[]{n, string}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateBytes(int, byte[])");
            int n2 = 0;
            if (byArray != null) {
                n2 = byArray.length;
            }
            if (n2 > 255) {
                this.setParam(-4, n, byArray);
            } else {
                this.setParam(-3, n, byArray);
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateBytes", "int, byte[]", new Object[]{n, byArray}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateBytes", "int, byte[]", new Object[]{n, byArray}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateDate(int n, Date date) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateDate(int, java.sql.Date)");
            this.setParam(91, n, new DateObject((Object)date, 91));
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateDate", "int, java.sql.Date", new Object[]{n, date}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateDate", "int, java.sql.Date", new Object[]{n, date}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateTime(int n, Time time) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateTime(int, java.sql.Time)");
            this.setParam(92, n, new DateObject((Object)time, 92));
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateTime", "int, java.sql.Date", new Object[]{n, time}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateTime", "int, java.sql.Date", new Object[]{n, time}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateTimestamp(int, java.sql.Timestamp)");
            this.setParam(93, n, new DateObject((Object)timestamp, 93));
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateTimestamp", "int, java.sql.Timestamp", new Object[]{n, timestamp}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateTimestamp", "int, java.sql.Timestamp", new Object[]{n, timestamp}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateAsciiStream(int, java.io.InputStream, int)");
            try {
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new LimiterInputStream(inputStream, n2), "ISO8859_1");
                String string = this._paramMgr.drainReader(inputStreamReader, n2);
                if (string != null) {
                    this.setParam(12, n, string, 0);
                } else {
                    this.setParam(-1, n, inputStreamReader, n2);
                }
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateAsciiStream", "int, java.io.InputStream, int", new Object[]{n, inputStream, n2}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateAsciiStream", "int, java.io.InputStream, int", new Object[]{n, inputStream, n2}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateBinaryStream(int, java.io.InputStream, int)");
            byte[] byArray = this._paramMgr.drainStreams(inputStream, n2);
            if (byArray != null) {
                this.updateBytes(n, byArray);
            } else {
                this.setParam(-4, n, inputStream, n2);
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateBinaryStream", "int, java.io.InputStream, int", new Object[]{n, inputStream, n2}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateBinaryStream", "int, java.io.InputStream, int", new Object[]{n, inputStream, n2}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateCharacterStream(int, java.io.Reader, int)");
            String string = this._paramMgr.drainReader(reader, n2);
            if (string != null) {
                this.setParam(12, n, string, 0);
            } else {
                this.setParam(-1, n, reader, n2);
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateCharacterStream", "int, java.io.Reader, int", new Object[]{n, reader, n2}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateCharacterStream", "int, java.io.Reader, int", new Object[]{n, reader, n2}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateObject(int, Object, int)");
            if (object == null) {
                this.updateNull(n);
            } else if (object instanceof String) {
                this.updateString(n, (String)object);
            } else if (object instanceof BigDecimal) {
                this.setParam(2, n, object, n2);
            } else if (object instanceof Boolean) {
                this.setParam(-7, n, object, n2);
            } else if (object instanceof Integer) {
                this.setParam(4, n, object, n2);
            } else if (object instanceof Long) {
                this.setParam(-5, n, object, n2);
            } else if (object instanceof Float) {
                this.setParam(7, n, object, n2);
            } else if (object instanceof Double) {
                this.setParam(8, n, object, n2);
            } else if (object instanceof byte[]) {
                this.updateBytes(n, (byte[])object);
            } else if (object instanceof Date) {
                this.updateDate(n, (Date)object);
            } else if (object instanceof Time) {
                this.updateTime(n, (Time)object);
            } else if (object instanceof Timestamp) {
                this.updateTimestamp(n, (Timestamp)object);
            } else if (object instanceof Clob) {
                this.updateClob(n, (Clob)object);
            } else if (object instanceof Blob) {
                this.updateBlob(n, (Blob)object);
            } else if (object instanceof Serializable) {
                this.setParam(2000, n, object, n2);
            } else {
                ErrorMessage.raiseError("JZ0SE");
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateObject", "int, Object, int", new Object[]{n, object, n2}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateObject", "int, Object, int", new Object[]{n, object, n2}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateObject(int n, Object object) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateObject(int, Object)");
            int n2 = 0;
            if (object != null && object instanceof BigDecimal) {
                n2 = ((BigDecimal)object).scale();
            }
            this.updateObject(n, object, n2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateObject", "int, Object", new Object[]{n, object}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateObject", "int, Object", new Object[]{n, object}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateNull(String string) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateNull(String)");
            this.updateNull(this.findColumn(string));
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateNull", "String", new Object[]{string}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateNull", "String", new Object[]{string}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        boolean bl2 = LogUtil.isLoggingEnabled(LOG);
        long l = bl2 ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl2) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateBoolean(String, boolean)");
            this.updateBoolean(this.findColumn(string), bl);
            if (!bl2) return;
        }
        catch (Throwable throwable) {
            if (!bl2) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateBoolean", "String, byte", new Object[]{string, bl}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateBoolean", "String, byte", new Object[]{string, bl}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateByte(String string, byte by) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateByte(String, byte)");
            this.updateByte(this.findColumn(string), by);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateByte", "String, byte", new Object[]{string, by}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateByte", "String, byte", new Object[]{string, by}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateShort(String string, short s) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateShort(String, short)");
            this.updateShort(this.findColumn(string), s);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateShort", "String, short", new Object[]{string, s}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateShort", "String, short", new Object[]{string, s}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateInt(String string, int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateInt(String, int)");
            this.updateInt(this.findColumn(string), n);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateInt", "String, int", new Object[]{string, n}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateInt", "String, int", new Object[]{string, n}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateLong(String string, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            this.checkUpdatability("updateLong(String, long)");
            this.updateLong(this.findColumn(string), l);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateLong", "String, long", new Object[]{string, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateLong", "String, long", new Object[]{string, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateFloat(String string, float f) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateFloat(String, float)");
            this.updateFloat(this.findColumn(string), f);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateFloat", "String, float", new Object[]{string, Float.valueOf(f)}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateFloat", "String, float", new Object[]{string, Float.valueOf(f)}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateDouble(String string, double d) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateDouble(String, double)");
            this.updateDouble(this.findColumn(string), d);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateDouble", "String, double", new Object[]{string, d}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateDouble", "String, double", new Object[]{string, d}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateBigDecimal(String, BigDecimal)");
            this.updateBigDecimal(this.findColumn(string), bigDecimal);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateBigDecimal", "String, BigDecimal", new Object[]{string, bigDecimal}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateBigDecimal", "String, BigDecimal", new Object[]{string, bigDecimal}, l);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal, int n, int n2) throws SQLException {
        this.checkUpdatability("updateBigDecimal(String, BigDecimal, int, int)");
        this.updateBigDecimal(this.findColumn(string), bigDecimal, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateString(String string, String string2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateString(String, String)");
            this.updateString(this.findColumn(string), string2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateString", "String, String", new Object[]{string, string2}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateString", "String, String", new Object[]{string, string2}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateBytes(String, byte[])");
            this.updateBytes(this.findColumn(string), byArray);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateBytes", "String, byte[]", new Object[]{string, byArray}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateBytes", "String, byte[]", new Object[]{string, byArray}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateDate(String string, Date date) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateDate(String, java.sql.Date)");
            this.updateDate(this.findColumn(string), date);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateDate", "String, java.sql.Date", new Object[]{string, date}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateDate", "String, java.sql.Date", new Object[]{string, date}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateTime(String string, Time time) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateTime(String, java.sql.Time)");
            this.updateTime(this.findColumn(string), time);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateTime", "String, java.sql.Time", new Object[]{string, time}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateTime", "String, java.sql.Time", new Object[]{string, time}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateTimestamp(String, java.sql.Timestamp)");
            this.updateTimestamp(this.findColumn(string), timestamp);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateTimestamp", "String, java.sql.Timestamp", new Object[]{string, timestamp}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateTimestamp", "String, java.sql.Timestamp", new Object[]{string, timestamp}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateAsciiStream(String, java.io.InputStream, int)");
            this.updateAsciiStream(this.findColumn(string), inputStream, n);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateAsciiStream", "String, java.io.InputStream, int", new Object[]{string, inputStream, n}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateAsciiStream", "String, java.io.InputStream, int", new Object[]{string, inputStream, n}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateBinaryStream(String, java.io.InputStream, int)");
            this.updateBinaryStream(this.findColumn(string), inputStream, n);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateBinaryStream", "String, java.io.InputStream, int", new Object[]{string, inputStream, n}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateBinaryStream", "String, java.io.InputStream, int", new Object[]{string, inputStream, n}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateCharacterStream(String, java.io.Reader, int)");
            this.updateCharacterStream(this.findColumn(string), reader, n);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateCharacterStream", "String, java.io.Reader, int", new Object[]{string, reader, n}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateCharacterStream", "String, java.io.Reader, int", new Object[]{string, reader, n}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateObject(String, Object, int)");
            int n2 = 0;
            if (object != null && object instanceof BigDecimal) {
                n2 = ((BigDecimal)object).scale();
            }
            this.updateObject(this.findColumn(string), object, n2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateObject", "String, Object, int", new Object[]{string, object, n}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateObject", "String, Object, int", new Object[]{string, object, n}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateObject(String string, Object object) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateObject(String, Object)");
            this.updateObject(this.findColumn(string), object);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateObject", "String, Object", new Object[]{string, object}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateObject", "String, Object", new Object[]{string, object}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateNString(int n, String string) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateNString(int, String)");
            this.setParam(-9, n, string);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateNString", "int, String", new Object[]{n, string}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateNString", "int, String", new Object[]{n, string}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateNString(String string, String string2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateNString(String, String)");
            this.updateNString(this.findColumn(string), string2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateNString", "String, String", new Object[]{string, string2}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateNString", "String, String", new Object[]{string, string2}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateNCharacterStream(int, java.io.Reader)");
            this.setParam(-16, n, reader, -1);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateNCharacterStream", "int, Reader", new Object[]{n, reader}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateNCharacterStream", "int, Reader", new Object[]{n, reader}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateNCharacterStream(String, java.io.Reader)");
            this.updateNCharacterStream(this.findColumn(string), reader);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateNCharacterStream", "String, Reader", new Object[]{string, reader}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateNCharacterStream", "String, Reader", new Object[]{string, reader}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            this.checkUpdatability("updateNCharacterStream(int, java.io.Reader, long)");
            int n2 = this.checkLongLength(l);
            this.setParam(-16, n, reader, n2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateNCharacterStream", "int, Reader, long", new Object[]{n, reader, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateNCharacterStream", "int, Reader, long", new Object[]{n, reader, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            this.checkUpdatability("updateNCharacterStream(String, java.io.Reader, long)");
            this.updateNCharacterStream(this.findColumn(string), reader, l);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateNCharacterStream", "String, Reader, long", new Object[]{string, reader, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateNCharacterStream", "String, Reader, long", new Object[]{string, reader, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateAsciiStream(int, java.io.InputStream)");
            this.updateAsciiStream(n, inputStream, -1);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateAsciiStream", "int, java.io.InputStream", new Object[]{n, inputStream}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateAsciiStream", "int, java.io.InputStream", new Object[]{n, inputStream}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateAsciiStream(String, java.io.InputStream)");
            this.updateAsciiStream(this.findColumn(string), inputStream);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateAsciiStream", "String, java.io.InputStream", new Object[]{string, inputStream}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateAsciiStream", "String, java.io.InputStream", new Object[]{string, inputStream}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            this.checkUpdatability("updateAsciiStream(int, java.io.InputStream, long)");
            int n2 = this.checkLongLength(l);
            this.updateAsciiStream(n, inputStream, n2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateAsciiStream", "int, java.io.InputStream, long", new Object[]{n, inputStream, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateAsciiStream", "int, java.io.InputStream, long", new Object[]{n, inputStream, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            this.checkUpdatability("updateAsciiStream(int, java.io.InputStream, long)");
            this.updateAsciiStream(this.findColumn(string), inputStream, l);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateAsciiStream", "String, java.io.InputStream, long", new Object[]{string, inputStream, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateAsciiStream", "String, java.io.InputStream, long", new Object[]{string, inputStream, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateBinaryStream(int, java.io.InputStream)");
            this.updateBinaryStream(n, inputStream, -1);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateBinaryStream", "int, java.io.InputStream", new Object[]{n, inputStream}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateBinaryStream", "int, java.io.InputStream", new Object[]{n, inputStream}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateBinaryStream(String, java.io.InputStream)");
            this.updateBinaryStream(this.findColumn(string), inputStream, -1);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateBinaryStream", "String, InputStream", new Object[]{string, inputStream}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateBinaryStream", "String, InputStream", new Object[]{string, inputStream}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            this.checkUpdatability("updateBinaryStream(int, java.io.InputStream, long)");
            int n2 = this.checkLongLength(l);
            this.updateBinaryStream(n, inputStream, n2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateBinaryStream", "int, InputStream, long", new Object[]{n, inputStream, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateBinaryStream", "int, InputStream, long", new Object[]{n, inputStream, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            this.checkUpdatability("updateBinaryStream(int, java.io.InputStream, long)");
            this.updateBinaryStream(this.findColumn(string), inputStream, l);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setBytes", "String, InputStream, long", new Object[]{string, inputStream, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setBytes", "String, InputStream, long", new Object[]{string, inputStream, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateCharacterStream(int, java.io.Reader)");
            this.updateCharacterStream(n, reader, -1);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateCharacterStream", "int, Reader", new Object[]{n, reader}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateCharacterStream", "int, Reader", new Object[]{n, reader}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateCharacterStream(int, java.io.Reader)");
            this.updateCharacterStream(this.findColumn(string), reader);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateCharacterStream", "String, Reader", new Object[]{string, reader}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateCharacterStream", "String, Reader", new Object[]{string, reader}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            this.checkUpdatability("updateCharacterStream(int, java.io.Reader, long)");
            int n2 = this.checkLongLength(l);
            this.updateCharacterStream(n, reader, n2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateCharacterStream", "int, Reader, long", new Object[]{n, reader, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateCharacterStream", "int, Reader, long", new Object[]{n, reader, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            this.checkUpdatability("updateCharacterStream(int, java.io.Reader, long)");
            this.updateCharacterStream(this.findColumn(string), reader, l);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateCharacterStream", "String, Reader, long", new Object[]{string, reader, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateCharacterStream", "String, Reader, long", new Object[]{string, reader, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateClob(int, Clob)");
            if (clob == null) {
                clob = this._pc._conn._nullClob;
            }
            this.setParam(2005, n, clob);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateClob", "int, Clob", new Object[]{n, clob}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateClob", "int, Clob", new Object[]{n, clob}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateClob(String, Clob)");
            this.updateClob(this.findColumn(string), clob);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateClob", "String, Clob", new Object[]{string, clob}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateClob", "String, Clob", new Object[]{string, clob}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateClob(int, Reader)");
            this.setParam(-1, n, reader, -1);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateClob", "int, Reader", new Object[]{n, reader}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateClob", "int, Reader", new Object[]{n, reader}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateClob(String, Reader)");
            this.updateClob(this.findColumn(string), reader);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateClob", "String, Reader", new Object[]{string, reader}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateClob", "String, Reader", new Object[]{string, reader}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            this.checkUpdatability("updateClob(int, Reader, long)");
            int n2 = this.checkLongLength(l);
            this.setParam(-1, n, reader, n2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateClob", "int, Reader, long", new Object[]{n, reader, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateClob", "int, Reader, long", new Object[]{n, reader, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            this.checkUpdatability("updateClob(String, Reader, long)");
            this.updateClob(this.findColumn(string), reader, l);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateClob", "String, Reader, long", new Object[]{string, reader, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateClob", "String, Reader, long", new Object[]{string, reader, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateBlob(int, Blob)");
            if (blob == null) {
                blob = this._pc._conn._nullBlob;
            }
            this.setParam(2004, n, blob);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateBlob", "int, Blob", new Object[]{n, blob}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateBlob", "int, Blob", new Object[]{n, blob}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateBlob(String, Blob)");
            this.updateBlob(this.findColumn(string), blob);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateBlob", "String, Blob", new Object[]{string, blob}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateBlob", "String, Blob", new Object[]{string, blob}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateBlob(int, InputStream)");
            this.setParam(-4, n, inputStream, -1);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateBlob", "int, InputStream", new Object[]{n, inputStream}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateBlob", "int, InputStream", new Object[]{n, inputStream}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateBlob(String, InputStream)");
            this.updateBlob(this.findColumn(string), inputStream);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateBlob", "String, InputStream", new Object[]{string, inputStream}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateBlob", "String, InputStream", new Object[]{string, inputStream}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            this.checkUpdatability("updateBlob(int, InputStream, long)");
            int n2 = this.checkLongLength(l);
            this.setParam(-4, n, inputStream, n2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateBlob", "int, InputStream, long", new Object[]{n, inputStream, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateBlob", "int, InputStream, long", new Object[]{n, inputStream, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            this.checkUpdatability("updateBlob(String, InputStream, long)");
            int n = this.checkLongLength(l);
            this.updateBlob(this.findColumn(string), inputStream, (long)n);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "updateBlob", "String, InputStream, long", new Object[]{string, inputStream, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "updateBlob", "String, InputStream, long", new Object[]{string, inputStream, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelRowUpdates() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("cancelRowUpdates()");
            if (this._rowDeleted || this._rowUpdated || this._rowInserted) {
                ErrorMessage.raiseError("JZ0RM", "cancelRowUpdates");
            }
            this._paramMgr.clearParamArray(true);
            this._insertParamMgr.clearParamArray(true);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "cancelRowUpdates", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRow() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("deleteRow()");
            int n = this._cursor.delete(this._prs);
            if (n > 0) {
                this._rowDeleted = true;
            }
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "deleteRow", null, null, l);
            }
        }
    }

    @Override
    public void deleteRow(String string) throws SQLException {
        this.checkUpdatability("deleteRow(String)");
        this._cursor.setTable(string);
        int n = this._cursor.delete(this._prs);
        if (n > 0) {
            this._rowDeleted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRow() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            int n;
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkUpdatability("updateRow()");
            StringBuffer stringBuffer = new StringBuffer("UPDATE " + this._cursor.getTable() + " SET ");
            int n2 = stringBuffer.length();
            ResultSetMetaData resultSetMetaData = this._prs.getMetaData();
            int n3 = resultSetMetaData.getColumnCount();
            Param[] paramArray = this._paramMgr.getParams();
            boolean bl2 = true;
            for (n = 0; n < n3; ++n) {
                if (paramArray[n]._sqlType == -999) {
                    paramArray[n]._sqlType = -998;
                    continue;
                }
                if (paramArray[n]._sqlType == -998) continue;
                if (!bl2) {
                    stringBuffer.append(", ");
                    n2 += 2;
                }
                String string = resultSetMetaData.getColumnName(n + 1);
                n2 += string.length() + 3;
                stringBuffer.append(string + " = ?");
                paramArray[n]._paramMarkerOffset = n2++;
                bl2 = false;
            }
            if (bl2) {
                ErrorMessage.raiseError("JZ00G");
            }
            if (1 == this._cursor.update(this._prs, this._paramMgr, stringBuffer.toString())) {
                this._rowUpdated = true;
            }
            for (n = 0; n < n3; ++n) {
                if (paramArray[n]._sqlType != -998) continue;
                paramArray[n]._sqlType = -999;
            }
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "updateRow", null, null, l);
            }
        }
    }

    @Override
    public void updateRow(String string) throws SQLException {
        this.checkUpdatability("updateRow(String)");
        this._cursor.setTable(string);
        this.updateRow();
    }

    private void setParam(int n, int n2, Object object) throws SQLException {
        this.setParam(n, n2, object, 0);
    }

    private void setParam(int n, int n2, Object object, int n3) throws SQLException {
        this.checkResultSet();
        if (this._paramMgr != null) {
            if (this._rowIndex != -3) {
                this._paramMgr.setParam(n2, n, object, n3);
            } else {
                this._insertParamMgr.setParam(n2, n, object, n3);
                this._rowInserted = false;
            }
        } else {
            ErrorMessage.raiseError("JZ00H");
        }
    }

    @Override
    protected JdbcDataObject getColumn(int n) throws SQLException {
        this.checkResultSet();
        if (this._rowIndex == -3) {
            Param[] paramArray = this._insertParamMgr.getParams();
            if (n < 1 || n > paramArray.length) {
                ErrorMessage.raiseError("JZ008", "" + n);
            }
            this._currentColumn = paramArray[n - 1]._sqlType == -999 || paramArray[n - 1]._sqlType == -998 ? null : (JdbcDataObject)((Object)paramArray[n - 1]);
        } else if (this._paramMgr != null) {
            Param[] paramArray = this._paramMgr.getParams();
            if (n < 1 || n > paramArray.length) {
                ErrorMessage.raiseError("JZ008", "" + n);
            }
            this.checkIfReadableRow();
            this._currentColumn = paramArray[n - 1]._sqlType == -999 || paramArray[n - 1]._sqlType == -998 ? this._prs.getColumn(n) : (JdbcDataObject)((Object)paramArray[n - 1]);
        } else {
            this.checkIfReadableRow();
            this._currentColumn = this._prs.getColumn(n);
        }
        return this._currentColumn;
    }

    @Override
    protected void checkIfReadableRow() throws SQLException {
        if (this._rowDeleted) {
            ErrorMessage.raiseError("JZ0RD");
        }
        if (this._rowIndex == -1) {
            ErrorMessage.raiseError("JZ0R1");
        } else if (this._rowIndex == -2) {
            ErrorMessage.raiseError("JZ0R5");
        }
    }

    @Override
    protected void checkForScrollability(String string) throws SQLException {
        switch (this._scrollType) {
            case 1003: {
                ErrorMessage.raiseError("JZ0BT", string, "TYPE_FORWARD_ONLY");
                break;
            }
            case 1004: {
                if (!this._cursor.isLanguageCursor()) break;
                ErrorMessage.raiseError("JZ0LC", string);
                break;
            }
            case 1005: {
                Debug.notImplemented(this, string + " for TYPE_SCROLL_SENSITIVE");
                break;
            }
        }
    }

    protected void checkUpdatability(String string) throws SQLException {
        if (this._concurType == 1007) {
            ErrorMessage.raiseError("JZ0BT", string, this._concurTypeString);
        }
    }

    private int checkLongLength(long l) {
        int n;
        if (l > Integer.MAX_VALUE) {
            n = Integer.MAX_VALUE;
            this._statement._context._conn.chainWarnings(ErrorMessage.createWarning("01S11"));
        } else {
            n = (int)l;
        }
        return n;
    }
}

