/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.streams.parameters;

import com.simba.athena.dsi.dataengine.utilities.DataWrapper;
import com.simba.athena.dsi.dataengine.utilities.ParameterInputValue;
import com.simba.athena.dsi.dataengine.utilities.ParameterMetadata;
import com.simba.athena.dsi.exceptions.InputOutputException;
import com.simba.athena.exceptions.JDBCMessageKey;
import com.simba.athena.streams.TruncatedReader;
import com.simba.athena.streams.parameters.AbstractParameterStream;
import com.simba.athena.utilities.ReferenceEqualityWrapper;
import java.io.IOException;
import java.io.Reader;

public class CharacterParameterStream
extends AbstractParameterStream {
    private Reader m_reader = null;

    public CharacterParameterStream(Reader reader, long l) {
        super(null, l);
        this.m_reader = reader;
        this.m_streamWrapper = new ReferenceEqualityWrapper(this.m_reader);
    }

    @Deprecated
    public CharacterParameterStream(Reader reader, long l, ParameterMetadata parameterMetadata, int n) {
        super(null, l, parameterMetadata, n);
        this.m_reader = reader;
        this.m_streamWrapper = new ReferenceEqualityWrapper(this.m_reader);
    }

    @Override
    public void close() {
        super.close();
        if (!this.isClosed()) {
            try {
                this.m_reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_reader = null;
        }
    }

    @Override
    public ParameterInputValue getNextValue() throws IOException {
        if (this.isClosed()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CLOSED.name());
        }
        if (!this.hasMoreData()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_EMPTY.name());
        }
        if (null == this.m_parameterMetadata) {
            throw new InputOutputException(1, JDBCMessageKey.NULL_PARAM_METADATA.name());
        }
        if (!this.m_valuesPushed) {
            this.m_valuesPushed = true;
        }
        int n = this.getNumToFetch();
        char[] cArray = new char[n];
        int n2 = this.m_reader.read(cArray);
        this.m_numRead += (long)n2;
        DataWrapper dataWrapper = new DataWrapper();
        if (-1L != this.m_streamLength) {
            if (-1 == n2) {
                throw new InputOutputException(1, JDBCMessageKey.STREAM_UNEXPECTED_END.name());
            }
        } else {
            this.m_lastChunkReadSize = n2;
            if (n2 < cArray.length && -1 != n2) {
                char[] cArray2 = new char[n2];
                System.arraycopy(cArray, 0, cArray2, 0, n2);
                cArray = cArray2;
                this.m_lastChunkReadSize = -1L;
            } else if (-1 == n2) {
                cArray = new char[]{};
            }
        }
        try {
            if (12 == this.m_parameterMetadata.getTypeMetadata().getType()) {
                dataWrapper.setVarChar(new String(cArray));
            } else {
                dataWrapper.setLongVarChar(new String(cArray));
            }
        }
        catch (Exception exception) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CORRUPT_UTF.name());
        }
        return new ParameterInputValue(this.m_parameterMetadata, dataWrapper);
    }

    @Override
    protected boolean isClosed() {
        return null == this.m_reader;
    }

    @Override
    public Reader getAsReader() {
        if (this.isClosed()) {
            throw new RuntimeException("Already closed!");
        }
        Reader reader = this.m_streamLength >= 0L ? new TruncatedReader(this.m_reader, this.m_streamLength) : this.m_reader;
        this.m_reader = null;
        this.close();
        return reader;
    }

    @Override
    public boolean canGetAsReader() {
        return true;
    }
}

