/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.iamsupport.plugin;

import com.amazonaws.auth.AWSCredentials;
import com.simba.athena.amazonaws.AmazonWebServiceResult;
import com.simba.athena.amazonaws.ClientConfiguration;
import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.auth.AWSStaticCredentialsProvider;
import com.simba.athena.amazonaws.auth.AnonymousAWSCredentials;
import com.simba.athena.amazonaws.auth.BasicSessionCredentials;
import com.simba.athena.amazonaws.client.builder.AwsClientBuilder;
import com.simba.athena.amazonaws.services.lakeformation.AWSLakeFormation;
import com.simba.athena.amazonaws.services.lakeformation.AWSLakeFormationClientBuilder;
import com.simba.athena.amazonaws.services.lakeformation.model.AssumeDecoratedRoleWithSAMLRequest;
import com.simba.athena.amazonaws.services.lakeformation.model.AssumeDecoratedRoleWithSAMLResult;
import com.simba.athena.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.simba.athena.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.simba.athena.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest;
import com.simba.athena.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLResult;
import com.simba.athena.amazonaws.services.securitytoken.model.Credentials;
import com.simba.athena.amazonaws.util.StringUtils;
import com.simba.athena.iamsupport.IPlugin;
import com.simba.athena.iamsupport.logger.IamCustomLogFactory;
import com.simba.athena.iamsupport.model.CredentialsHolder;
import com.simba.athena.iamsupport.plugin.utils.LogUtils;
import com.simba.athena.iamsupport.ssl.NonValidatingFactory;
import com.simba.athena.support.LogUtilities;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class SamlCredentialsProvider
implements IPlugin {
    protected static final String KEY_IDP_HOST = "idp_host";
    private static final String KEY_IDP_PORT = "idp_port";
    private static final String KEY_DURATION = "duration";
    private static final String KEY_PREFERRED_ROLE = "preferred_role";
    private static final String KEY_SSL_INSECURE = "ssl_insecure";
    private static final int DEFAULT_IDP_PORT = 443;
    protected static final String MICROSOFT_IDP_HOST = "login.microsoftonline.com";
    protected static final Pattern IAM_URL_PATTERN = Pattern.compile("^(https)://[-a-zA-Z0-9+&@#/%?=~_!:,.']*[-a-zA-Z0-9+&@#/%=~_']");
    protected String m_userName;
    protected String m_password;
    protected String m_idpHost;
    protected int m_idpPort = 443;
    protected int m_duration;
    protected String m_preferredRole;
    protected boolean m_sslInsecure;
    protected String m_dbUser;
    protected String m_dbGroups;
    protected Boolean m_autoCreate;
    protected String m_proxyHost;
    protected int m_proxyPort;
    protected String m_proxyUid;
    protected String m_proxyPwd;
    protected String m_proxyDomain;
    protected String m_proxyWorkstation;
    protected String m_region;
    protected String m_stsEndpointOverride;
    protected String m_lfEndpointOverride;
    protected Boolean m_useProxyForIdpAuth = false;
    protected String m_nonProxyHosts;
    public boolean m_isLakeformationEnabled = false;
    protected String m_userAgent;
    protected String m_loginToRp;
    private static Map<String, CredentialsHolder> m_cache = new HashMap<String, CredentialsHolder>();
    private static final Class<?> CUSTOM_LOG_FACTORY_CLASS = IamCustomLogFactory.class;
    private static final String LOG_PROPERTIES_FILE_NAME = "log-factory.properties";
    private static final String LOG_PROPERTIES_FILE_PATH = "META-INF/services/org.apache.commons.logging.LogFactory";
    private static final ClassLoader CONTEXT_CLASS_LOADER = new ClassLoader(SamlCredentialsProvider.class.getClassLoader()){

        @Override
        public Class<?> loadClass(String string) throws ClassNotFoundException {
            Class<?> clazz = this.getParent().loadClass(string);
            if (LogFactory.class.isAssignableFrom(clazz)) {
                return CUSTOM_LOG_FACTORY_CLASS;
            }
            return clazz;
        }

        @Override
        public Enumeration<URL> getResources(String string) throws IOException {
            if ("commons-logging.properties".equals(string)) {
                return Collections.enumeration(Collections.emptyList());
            }
            return super.getResources(string);
        }

        @Override
        public URL getResource(String string) {
            if (SamlCredentialsProvider.LOG_PROPERTIES_FILE_PATH.equals(string)) {
                return SamlCredentialsProvider.class.getResource(SamlCredentialsProvider.LOG_PROPERTIES_FILE_NAME);
            }
            return super.getResource(string);
        }
    };

    @Override
    public void addParameter(String string, String string2) {
        if ("UID".equalsIgnoreCase(string) || "user".equalsIgnoreCase(string)) {
            this.m_userName = string2;
        } else if ("PWD".equalsIgnoreCase(string) || "password".equalsIgnoreCase(string)) {
            this.m_password = string2;
        } else if (KEY_IDP_HOST.equalsIgnoreCase(string)) {
            this.m_idpHost = string2;
        } else if (KEY_IDP_PORT.equalsIgnoreCase(string)) {
            this.m_idpPort = Integer.parseInt(string2);
        } else if (KEY_DURATION.equalsIgnoreCase(string)) {
            this.m_duration = Integer.parseInt(string2);
        } else if (KEY_PREFERRED_ROLE.equalsIgnoreCase(string)) {
            this.m_preferredRole = string2;
        } else if (KEY_SSL_INSECURE.equalsIgnoreCase(string)) {
            this.m_sslInsecure = Boolean.parseBoolean(string2);
        } else if ("DbUser".equalsIgnoreCase(string)) {
            this.m_dbUser = string2;
        } else if ("DbGroups".equalsIgnoreCase(string)) {
            this.m_dbGroups = string2;
        } else if ("AutoCreate".equalsIgnoreCase(string)) {
            this.m_autoCreate = Boolean.valueOf(string2);
        } else if ("Region".equalsIgnoreCase(string) || "AWSRegion".equalsIgnoreCase(string)) {
            this.m_region = string2;
        } else if ("ProxyHost".equalsIgnoreCase(string)) {
            this.m_proxyHost = string2;
        } else if ("ProxyPort".equalsIgnoreCase(string)) {
            this.m_proxyPort = Integer.parseInt(string2);
        } else if ("ProxyUID".equalsIgnoreCase(string)) {
            this.m_proxyUid = string2;
        } else if ("ProxyPWD".equalsIgnoreCase(string)) {
            this.m_proxyPwd = string2;
        } else if ("ProxyDomain".equalsIgnoreCase(string)) {
            this.m_proxyDomain = string2;
        } else if ("ProxyWorkstation".equalsIgnoreCase(string)) {
            this.m_proxyWorkstation = string2;
        } else if ("UseProxyForIdp".equalsIgnoreCase(string)) {
            this.m_useProxyForIdpAuth = Boolean.parseBoolean(string2);
        } else if ("NonProxyHosts".equalsIgnoreCase(string)) {
            this.m_nonProxyHosts = string2;
        } else if ("LakeformationEnabled".equalsIgnoreCase(string)) {
            this.m_isLakeformationEnabled = Boolean.parseBoolean(string2);
        } else if ("StsEndpointOverride".equalsIgnoreCase(string)) {
            this.m_stsEndpointOverride = string2;
        } else if ("LfEndpointOverride".equalsIgnoreCase(string)) {
            this.m_lfEndpointOverride = string2;
        } else if ("UserAgent".equalsIgnoreCase(string)) {
            this.m_userAgent = string2;
        } else if ("loginToRp".equalsIgnoreCase(string)) {
            this.m_loginToRp = string2;
        }
    }

    @Override
    public CredentialsHolder getCredentials() {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        String string = this.getCacheKey();
        CredentialsHolder credentialsHolder = m_cache.get(string);
        if (credentialsHolder == null || credentialsHolder.isExpired()) {
            this.refresh();
        }
        if ((credentialsHolder = m_cache.get(string)) == null) {
            throw new SdkClientException("Unable to load AWS credentials from ADFS");
        }
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return credentialsHolder;
    }

    @Override
    public void refresh() {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CONTEXT_CLASS_LOADER);
        try {
            String string;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Pattern pattern = Pattern.compile("arn:aws(\\-cn)?:iam::\\d*:saml-provider/\\S+");
            Pattern pattern2 = Pattern.compile("arn:aws(\\-cn)?:iam::\\d*:role/\\S+");
            String string2 = this.getSamlAssertion();
            Document document = SamlCredentialsProvider.parse(Base64.decodeBase64(string2));
            XPath xPath = XPathFactory.newInstance().newXPath();
            String string3 = "//*[local-name()='Attribute'][@Name='https://aws.amazon.com/SAML/Attributes/Role']/*[local-name()='AttributeValue']/text()";
            NodeList nodeList = (NodeList)xPath.compile(string3).evaluate(document, XPathConstants.NODESET);
            HashMap<Credentials, AmazonWebServiceResult> hashMap = new HashMap<Credentials, AmazonWebServiceResult>();
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    object5 = nodeList.item(i);
                    object4 = object5.getNodeValue();
                    object3 = ((String)object4).split(",");
                    if (((String[])object3).length < 2) continue;
                    object2 = null;
                    object = null;
                    for (String string4 : object3) {
                        Matcher matcher = pattern.matcher(string4);
                        if (matcher.find()) {
                            object2 = matcher.group(0);
                            continue;
                        }
                        Matcher matcher2 = pattern2.matcher(string4);
                        if (!matcher2.find()) continue;
                        object = matcher2.group(0);
                    }
                    if (StringUtils.isNullOrEmpty((String)object) || StringUtils.isNullOrEmpty((String)object2)) continue;
                    hashMap.put((Credentials)object, (AmazonWebServiceResult)object2);
                }
            }
            if (hashMap.isEmpty()) {
                throw new SdkClientException("No role found in SamlAssertion.");
            }
            if (this.m_preferredRole != null) {
                string = this.m_preferredRole;
                object5 = (String)hashMap.get(this.m_preferredRole);
                if (object5 == null) {
                    throw new SdkClientException("Preferred role not found in SamlAssertion.");
                }
            } else {
                object4 = hashMap.entrySet().iterator().next();
                string = (String)object4.getKey();
                object5 = (String)object4.getValue();
            }
            if (this.m_isLakeformationEnabled) {
                if (hashMap.size() > 1) {
                    throw new SdkClientException("More than one role found in SamlAssertion.");
                }
                object2 = this.assumeDecoratedRoleWithSAMLRequest((String)object5, string, string2);
                object3 = ((AssumeDecoratedRoleWithSAMLResult)object2).getExpiration();
                object4 = new BasicSessionCredentials(((AssumeDecoratedRoleWithSAMLResult)object2).getAccessKeyId(), ((AssumeDecoratedRoleWithSAMLResult)object2).getSecretAccessKey(), ((AssumeDecoratedRoleWithSAMLResult)object2).getSessionToken());
            } else {
                object2 = this.assumeRoleWithSAMLRequest((String)object5, string, string2);
                object = ((AssumeRoleWithSAMLResult)object2).getCredentials();
                object3 = ((Credentials)object).getExpiration();
                object4 = new BasicSessionCredentials(((Credentials)object).getAccessKeyId(), ((Credentials)object).getSecretAccessKey(), ((Credentials)object).getSessionToken());
            }
            object2 = CredentialsHolder.newInstance((AWSCredentials)object4, (Date)object3);
            ((CredentialsHolder)object2).setMetadata(this.readMetadata(document));
            object = this.performPostSAMLAction(this.m_userName, string2, (CredentialsHolder)object2);
            if (null != object) {
                object2 = object;
            }
            m_cache.put(this.getCacheKey(), (CredentialsHolder)object2);
        }
        catch (IOException iOException) {
            throw new SdkClientException("SAML error: " + iOException.getMessage(), iOException);
        }
        catch (SAXException sAXException) {
            throw new SdkClientException("SAML error: " + sAXException.getMessage(), sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SdkClientException("SAML error: " + parserConfigurationException.getMessage(), parserConfigurationException);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new SdkClientException("SAML error: " + xPathExpressionException.getMessage(), xPathExpressionException);
        }
        finally {
            LogUtilities.logDebug("Exiting", LogUtils.getLogger());
            thread.setContextClassLoader(classLoader);
        }
    }

    protected AssumeDecoratedRoleWithSAMLResult assumeDecoratedRoleWithSAMLRequest(String string, String string2, String string3) {
        Object object;
        LogUtilities.logDebug(String.format("Entered with parameter value {%s}", string), LogUtils.getLogger());
        AssumeDecoratedRoleWithSAMLRequest assumeDecoratedRoleWithSAMLRequest = new AssumeDecoratedRoleWithSAMLRequest();
        assumeDecoratedRoleWithSAMLRequest.setSAMLAssertion(string3);
        assumeDecoratedRoleWithSAMLRequest.setRoleArn(string2);
        assumeDecoratedRoleWithSAMLRequest.setPrincipalArn(string);
        if (this.m_duration > 0) {
            assumeDecoratedRoleWithSAMLRequest.setDurationSeconds(this.m_duration);
        }
        AWSStaticCredentialsProvider aWSStaticCredentialsProvider = new AWSStaticCredentialsProvider(new AnonymousAWSCredentials());
        AWSLakeFormationClientBuilder aWSLakeFormationClientBuilder = AWSLakeFormationClientBuilder.standard();
        if (null != this.m_lfEndpointOverride && !this.m_lfEndpointOverride.isEmpty()) {
            aWSLakeFormationClientBuilder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.m_lfEndpointOverride, this.m_region));
        } else {
            aWSLakeFormationClientBuilder.setRegion(this.m_region);
        }
        if (null != this.m_proxyHost && !this.m_proxyHost.isEmpty()) {
            object = new ClientConfiguration();
            ((ClientConfiguration)object).setProxyHost(this.m_proxyHost);
            ((ClientConfiguration)object).setProxyPort(this.m_proxyPort);
            ((ClientConfiguration)object).setProxyUsername(this.m_proxyUid);
            ((ClientConfiguration)object).setProxyPassword(this.m_proxyPwd);
            ((ClientConfiguration)object).setProxyDomain(this.m_proxyDomain);
            ((ClientConfiguration)object).setProxyWorkstation(this.m_proxyWorkstation);
            ((ClientConfiguration)object).setUserAgent(this.m_userAgent);
            aWSLakeFormationClientBuilder.setClientConfiguration((ClientConfiguration)object);
        }
        object = (AWSLakeFormation)((AWSLakeFormationClientBuilder)aWSLakeFormationClientBuilder.withCredentials(aWSStaticCredentialsProvider)).build();
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return object.assumeDecoratedRoleWithSAML(assumeDecoratedRoleWithSAMLRequest);
    }

    protected AssumeRoleWithSAMLResult assumeRoleWithSAMLRequest(String string, String string2, String string3) {
        Object object;
        LogUtilities.logDebug(String.format("Entered with parameter value {%s}", string2), LogUtils.getLogger());
        AssumeRoleWithSAMLRequest assumeRoleWithSAMLRequest = new AssumeRoleWithSAMLRequest();
        assumeRoleWithSAMLRequest.setSAMLAssertion(string3);
        assumeRoleWithSAMLRequest.setRoleArn(string2);
        assumeRoleWithSAMLRequest.setPrincipalArn(string);
        if (this.m_duration > 0) {
            assumeRoleWithSAMLRequest.setDurationSeconds(this.m_duration);
        }
        AWSStaticCredentialsProvider aWSStaticCredentialsProvider = new AWSStaticCredentialsProvider(new AnonymousAWSCredentials());
        AWSSecurityTokenServiceClientBuilder aWSSecurityTokenServiceClientBuilder = AWSSecurityTokenServiceClientBuilder.standard();
        if (null != this.m_stsEndpointOverride && !this.m_stsEndpointOverride.isEmpty()) {
            aWSSecurityTokenServiceClientBuilder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.m_stsEndpointOverride, this.m_region));
        } else {
            aWSSecurityTokenServiceClientBuilder.setRegion(this.m_region);
        }
        if (null != this.m_proxyHost && !this.m_proxyHost.isEmpty()) {
            object = new ClientConfiguration();
            ((ClientConfiguration)object).setProxyHost(this.m_proxyHost);
            ((ClientConfiguration)object).setProxyPort(this.m_proxyPort);
            ((ClientConfiguration)object).setProxyUsername(this.m_proxyUid);
            ((ClientConfiguration)object).setProxyPassword(this.m_proxyPwd);
            ((ClientConfiguration)object).setProxyDomain(this.m_proxyDomain);
            ((ClientConfiguration)object).setProxyWorkstation(this.m_proxyWorkstation);
            ((ClientConfiguration)object).setUserAgent(this.m_userAgent);
            aWSSecurityTokenServiceClientBuilder.setClientConfiguration((ClientConfiguration)object);
        }
        object = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)aWSSecurityTokenServiceClientBuilder.withCredentials(aWSStaticCredentialsProvider)).build();
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return object.assumeRoleWithSAML(assumeRoleWithSAMLRequest);
    }

    protected void checkRequiredParameters() throws IOException {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        if (StringUtils.isNullOrEmpty(this.m_userName)) {
            throw new IOException("Missing required property: user");
        }
        if (StringUtils.isNullOrEmpty(this.m_password)) {
            throw new IOException("Missing required property: password");
        }
        if (StringUtils.isNullOrEmpty(this.m_idpHost)) {
            throw new IOException("Missing required property: idp_host");
        }
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
    }

    protected String escapeHtmlEntity(String string) {
        LogUtilities.logDebug(String.format("Entered with parameter value {%s}", string), LogUtils.getLogger());
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c != '&') {
                stringBuilder.append(c);
                ++n;
                continue;
            }
            if (string.startsWith("&amp;", n)) {
                stringBuilder.append('&');
                n += 5;
                continue;
            }
            if (string.startsWith("&apos;", n)) {
                stringBuilder.append('\'');
                n += 6;
                continue;
            }
            if (string.startsWith("&quot;", n)) {
                stringBuilder.append('\"');
                n += 6;
                continue;
            }
            if (string.startsWith("&lt;", n)) {
                stringBuilder.append('<');
                n += 4;
                continue;
            }
            if (string.startsWith("&gt;", n)) {
                stringBuilder.append('>');
                n += 4;
                continue;
            }
            stringBuilder.append(c);
            ++n;
        }
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return stringBuilder.toString();
    }

    protected CredentialsHolder performPostSAMLAction(String string, String string2, CredentialsHolder credentialsHolder) throws SdkClientException {
        LogUtilities.logDebug(String.format("Entered with parameter value {%s}", string), LogUtils.getLogger());
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return null;
    }

    protected String getFormAction(String string) {
        LogUtilities.logDebug(String.format("Entered with parameter value {%s}", string), LogUtils.getLogger());
        Pattern pattern = Pattern.compile("<form.*?action=\"([^\"]+)\"");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            LogUtilities.logDebug("Exiting", LogUtils.getLogger());
            return this.escapeHtmlEntity(matcher.group(1));
        }
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return null;
    }

    protected CloseableHttpClient getHttpClient() throws GeneralSecurityException {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setExpectContinueEnabled(false).setCookieSpec("standard").build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(requestConfig).setRedirectStrategy(new LaxRedirectStrategy());
        if (this.m_sslInsecure) {
            SSLContext sSLContext = SSLContext.getInstance("TLSv1.2");
            TrustManager[] trustManagerArray = new TrustManager[]{new NonValidatingFactory()};
            sSLContext.init(null, trustManagerArray, null);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            SSLConnectionSocketFactory sSLConnectionSocketFactory = new SSLConnectionSocketFactory(sSLSocketFactory, (HostnameVerifier)new NoopHostnameVerifier());
            httpClientBuilder.setSSLSocketFactory(sSLConnectionSocketFactory);
        }
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return httpClientBuilder.build();
    }

    protected List<String> getInputTagsfromHTML(String string) {
        LogUtilities.logDebug(String.format("Entered with parameter value {%s}", string), LogUtils.getLogger());
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("<input(.+?)/>", 32);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(0);
            String string3 = this.getValueByKey(string2, "name").toLowerCase();
            if (string3.isEmpty() || !hashSet.add(string3)) continue;
            arrayList.add(string2);
        }
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return arrayList;
    }

    protected abstract String getSamlAssertion() throws IOException;

    protected String getValueByKey(String string, String string2) {
        LogUtilities.logDebug(String.format("Entered with parameter value {%s}", string), LogUtils.getLogger());
        Pattern pattern = Pattern.compile("(" + Pattern.quote(string2) + ")\\s*=\\s*\"(.*?)\"");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            LogUtilities.logDebug("Exiting", LogUtils.getLogger());
            return this.escapeHtmlEntity(matcher.group(2));
        }
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return "";
    }

    protected void validateURL(String string) throws IOException {
        Matcher matcher = IAM_URL_PATTERN.matcher(string);
        if (!matcher.find()) {
            throw new IOException("Invalid URL: " + string);
        }
    }

    private String getCacheKey() {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return this.m_userName + this.m_password + this.m_idpHost + this.m_idpPort + this.m_duration + this.m_preferredRole;
    }

    private static List<String> GetSAMLAttributeValues(XPath xPath, Document document, String string) throws XPathExpressionException {
        LogUtilities.logDebug(String.format("Entered with parameter value {%s}", string), LogUtils.getLogger());
        String string2 = String.format("//Attribute[@Name='%s']/AttributeValue/text()", string);
        NodeList nodeList = (NodeList)xPath.compile(string2).evaluate(document, XPathConstants.NODESET);
        if (null == nodeList || nodeList.getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            arrayList.add(node.getNodeValue());
        }
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return arrayList;
    }

    private static Document parse(byte[] byArray) throws IOException, SAXException, ParserConfigurationException {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return documentBuilder.parse(new ByteArrayInputStream(byArray));
    }

    private CredentialsHolder.IamMetadata readMetadata(Document document) throws XPathExpressionException {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        CredentialsHolder.IamMetadata iamMetadata = new CredentialsHolder.IamMetadata();
        XPath xPath = XPathFactory.newInstance().newXPath();
        List<String> list = SamlCredentialsProvider.GetSAMLAttributeValues(xPath, document, "https://redshift.amazon.com/SAML/Attributes/DbUser");
        if (!list.isEmpty()) {
            iamMetadata.setDbUser(list.get(0));
        } else {
            list = SamlCredentialsProvider.GetSAMLAttributeValues(xPath, document, "https://aws.amazon.com/SAML/Attributes/RoleSessionName");
            if (!list.isEmpty()) {
                iamMetadata.setDbUser(list.get(0));
            }
        }
        list = SamlCredentialsProvider.GetSAMLAttributeValues(xPath, document, "https://redshift.amazon.com/SAML/Attributes/AutoCreate");
        if (!list.isEmpty()) {
            iamMetadata.setAutoCreate(Boolean.valueOf(list.get(0)));
        }
        if (!(list = SamlCredentialsProvider.GetSAMLAttributeValues(xPath, document, "https://redshift.amazon.com/SAML/Attributes/DbGroups")).isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(string);
            }
            iamMetadata.setDbGroups(stringBuilder.toString());
        }
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return iamMetadata;
    }

    protected boolean CheckNonProxyHost(String string, String string2) {
        if (string != null && !string.isEmpty() && string2 != null && !string2.isEmpty()) {
            String[] stringArray = string.toLowerCase().split("\\.");
            String[] stringArray2 = string2.toLowerCase().split("\\|");
            for (int i = 0; i < stringArray2.length; ++i) {
                String[] stringArray3 = stringArray2[i].split("\\.");
                for (int j = 0; j < stringArray3.length; ++j) {
                    if (stringArray3[j].charAt(0) != '*' || j >= stringArray.length) continue;
                    stringArray3[j] = stringArray[j];
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(Arrays.asList(stringArray3));
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.addAll(Arrays.asList(stringArray));
                if (!arrayList.equals(arrayList2)) continue;
                return true;
            }
        }
        return false;
    }
}

