/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.iamsupport.plugin;

import com.simba.athena.amazonaws.ClientConfiguration;
import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.auth.AWSStaticCredentialsProvider;
import com.simba.athena.amazonaws.auth.AnonymousAWSCredentials;
import com.simba.athena.amazonaws.auth.BasicSessionCredentials;
import com.simba.athena.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.simba.athena.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.simba.athena.amazonaws.services.securitytoken.model.AWSSecurityTokenServiceException;
import com.simba.athena.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest;
import com.simba.athena.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityResult;
import com.simba.athena.amazonaws.services.securitytoken.model.Credentials;
import com.simba.athena.iamsupport.IPlugin;
import com.simba.athena.iamsupport.logger.IamCustomLogFactory;
import com.simba.athena.iamsupport.model.CredentialsHolder;
import com.simba.athena.iamsupport.plugin.utils.LogUtils;
import com.simba.athena.support.LogUtilities;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class JwtCredentialsProvider
implements IPlugin {
    private static final String ROLE_ARN_KEY = "role_arn";
    private static final String ROLE_SESSION_NAME_KEY = "role_session_name";
    private static final String WEB_IDENTITY_TOKEN = "web_identity_token";
    private static final String DURATION = "duration";
    private static final Class<?> CUSTOM_LOG_FACTORY_CLASS = IamCustomLogFactory.class;
    private static final String LOG_PROPERTIES_FILE_NAME = "log-factory.properties";
    private static final String LOG_PROPERTIES_FILE_PATH = "META-INF/services/org.apache.commons.logging.LogFactory";
    private static final ClassLoader CONTEXT_CLASS_LOADER = new ClassLoader(JwtCredentialsProvider.class.getClassLoader()){

        @Override
        public Class<?> loadClass(String string) throws ClassNotFoundException {
            Class<?> clazz = this.getParent().loadClass(string);
            if (LogFactory.class.isAssignableFrom(clazz)) {
                return CUSTOM_LOG_FACTORY_CLASS;
            }
            return clazz;
        }

        @Override
        public Enumeration<URL> getResources(String string) throws IOException {
            if ("commons-logging.properties".equals(string)) {
                return Collections.enumeration(Collections.emptyList());
            }
            return super.getResources(string);
        }

        @Override
        public URL getResource(String string) {
            if (JwtCredentialsProvider.LOG_PROPERTIES_FILE_PATH.equals(string)) {
                return JwtCredentialsProvider.class.getResource(JwtCredentialsProvider.LOG_PROPERTIES_FILE_NAME);
            }
            return super.getResource(string);
        }
    };
    private String m_roleArn;
    private String m_webIdentityToken;
    private Integer m_duration;
    protected String m_preferredRole;
    protected String m_proxyHost;
    protected int m_proxyPort;
    protected String m_proxyUid;
    protected String m_proxyPwd;
    protected String m_proxyDomain;
    protected String m_proxyWorkstation;
    protected String m_region;
    protected String m_nonProxyHosts;
    protected String m_userAgent;
    private static Map<String, CredentialsHolder> m_cache = new HashMap<String, CredentialsHolder>();

    @Override
    public CredentialsHolder getCredentials() {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        String string = this.getCacheKey();
        CredentialsHolder credentialsHolder = m_cache.get(string);
        if (credentialsHolder == null || credentialsHolder.isExpired()) {
            this.refresh();
        }
        if ((credentialsHolder = m_cache.get(string)) == null) {
            throw new SdkClientException("Unable to load AWS credentials.");
        }
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return credentialsHolder;
    }

    @Override
    public void refresh() {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CONTEXT_CLASS_LOADER);
        String string = this.getCacheKey();
        try {
            m_cache.put(string, this.fetchCredentials());
        }
        catch (AWSSecurityTokenServiceException aWSSecurityTokenServiceException) {
            throw new SdkClientException("failed to fetch AWS Credentials. Details:" + aWSSecurityTokenServiceException.getErrorMessage());
        }
        thread.setContextClassLoader(classLoader);
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
    }

    @Override
    public void addParameter(String string, String string2) {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        if (ROLE_ARN_KEY.equalsIgnoreCase(string)) {
            this.m_roleArn = string2;
        }
        if (ROLE_SESSION_NAME_KEY.equalsIgnoreCase(string)) {
            this.m_preferredRole = string2;
        }
        if (WEB_IDENTITY_TOKEN.equalsIgnoreCase(string)) {
            this.m_webIdentityToken = string2;
        }
        if (DURATION.equalsIgnoreCase(string)) {
            this.m_duration = Integer.valueOf(string2);
        }
        if ("ProxyHost".equalsIgnoreCase(string)) {
            this.m_proxyHost = string2;
        }
        if ("ProxyPort".equalsIgnoreCase(string)) {
            this.m_proxyPort = Integer.parseInt(string2);
        }
        if ("ProxyUID".equalsIgnoreCase(string)) {
            this.m_proxyUid = string2;
        }
        if ("ProxyPWD".equalsIgnoreCase(string)) {
            this.m_proxyPwd = string2;
        }
        if ("ProxyDomain".equalsIgnoreCase(string)) {
            this.m_proxyDomain = string2;
        } else if ("ProxyWorkstation".equalsIgnoreCase(string)) {
            this.m_proxyWorkstation = string2;
        } else if ("Region".equalsIgnoreCase(string) || "AWSRegion".equalsIgnoreCase(string)) {
            this.m_region = string2;
        }
        if ("UserAgent".equalsIgnoreCase(string)) {
            this.m_userAgent = string2;
        }
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
    }

    public CredentialsHolder fetchCredentials() throws AWSSecurityTokenServiceException {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        AWSStaticCredentialsProvider aWSStaticCredentialsProvider = new AWSStaticCredentialsProvider(new AnonymousAWSCredentials());
        AWSSecurityTokenServiceClientBuilder aWSSecurityTokenServiceClientBuilder = AWSSecurityTokenServiceClientBuilder.standard();
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setProxyHost(this.m_proxyHost);
        clientConfiguration.setProxyPort(this.m_proxyPort);
        clientConfiguration.setProxyUsername(this.m_proxyUid);
        clientConfiguration.setProxyPassword(this.m_proxyPwd);
        clientConfiguration.setProxyDomain(this.m_proxyDomain);
        clientConfiguration.setProxyWorkstation(this.m_proxyWorkstation);
        clientConfiguration.setUserAgent(this.m_userAgent);
        aWSSecurityTokenServiceClientBuilder.setClientConfiguration(clientConfiguration);
        aWSSecurityTokenServiceClientBuilder.setRegion(this.m_region);
        AWSSecurityTokenService aWSSecurityTokenService = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)aWSSecurityTokenServiceClientBuilder.withCredentials(aWSStaticCredentialsProvider)).build();
        AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest = new AssumeRoleWithWebIdentityRequest();
        if (null == this.m_webIdentityToken || this.m_webIdentityToken.isEmpty()) {
            throw new SdkClientException("failed to fetch AWS Credentials. Details: Missing web_identity_token parameter.");
        }
        if (null == this.m_roleArn || this.m_roleArn.isEmpty()) {
            throw new SdkClientException("failed to fetch AWS Credentials. Details: Missing role_arn parameter.");
        }
        if (null == this.m_preferredRole || this.m_preferredRole.isEmpty()) {
            throw new SdkClientException("failed to fetch AWS Credentials. Details: Missing  parameter role_session_name.");
        }
        assumeRoleWithWebIdentityRequest.setWebIdentityToken(this.m_webIdentityToken);
        assumeRoleWithWebIdentityRequest.setRoleArn(this.m_roleArn);
        assumeRoleWithWebIdentityRequest.setRoleSessionName(this.m_preferredRole);
        if (null != this.m_duration && 3600 <= this.m_duration) {
            assumeRoleWithWebIdentityRequest.setDurationSeconds(this.m_duration);
        }
        AssumeRoleWithWebIdentityResult assumeRoleWithWebIdentityResult = aWSSecurityTokenService.assumeRoleWithWebIdentity(assumeRoleWithWebIdentityRequest);
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return this.buildAWSCredentialHolder(assumeRoleWithWebIdentityResult.getCredentials());
    }

    private String getCacheKey() {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return this.m_webIdentityToken;
    }

    private CredentialsHolder buildAWSCredentialHolder(Credentials credentials) {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        BasicSessionCredentials basicSessionCredentials = new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken());
        CredentialsHolder credentialsHolder = CredentialsHolder.newInstance(basicSessionCredentials, new Date());
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return credentialsHolder;
    }
}

