/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.dsi.core.utilities.impl.future;

import com.simba.athena.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.simba.athena.dsi.core.utilities.impl.future.ConversionConfig;
import com.simba.athena.dsi.core.utilities.impl.future.ConvertingJDBCDataSource;
import com.simba.athena.dsi.dataengine.interfaces.future.IJDBCExecution;
import com.simba.athena.dsi.exceptions.ConversionFailed;
import com.simba.athena.dsi.exceptions.IncorrectTypeException;
import com.simba.athena.dsi.exceptions.future.UnsupportedException;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.exceptions.ErrorException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;

public abstract class LocalDateJDBCDataSource
extends ConvertingJDBCDataSource {
    public LocalDateJDBCDataSource(IWarningListener iWarningListener, ConversionConfig conversionConfig) {
        super(iWarningListener, conversionConfig);
    }

    protected abstract LocalDate getLocalDate() throws ErrorException;

    @Override
    public Date get() throws ErrorException {
        LocalDate localDate = this.getLocalDate();
        return localDate == null ? null : NonTrivialJDBCConversions.localDateToSqlDate(localDate);
    }

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        LocalDate localDate = this.getLocalDate();
        return localDate == null ? null : NonTrivialJDBCConversions.localDateToString(localDate);
    }

    @Override
    public Date getDate(Calendar calendar) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.get();
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        LocalDate localDate = this.getLocalDate();
        return localDate == null ? null : NonTrivialJDBCConversions.localDateTimeToTimestamp(LocalDateTime.of(localDate, LocalTime.MIN));
    }

    @Override
    protected boolean supportsConversionToRegisteredType(IJDBCExecution.OutputParameterRegistration outputParameterRegistration) {
        int n = this.getSqlTypeFromRegistration(outputParameterRegistration);
        switch (n) {
            case 91: 
            case 93: 
            case 2000: {
                return true;
            }
        }
        return this.isCharType(n);
    }

    @Override
    public <T> T getObject(Class<T> clazz) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException, UnsupportedException {
        if (LocalDate.class.equals(clazz)) {
            return clazz.cast(this.getLocalDate());
        }
        return super.getObject(clazz);
    }
}

