/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.dsi.core.utilities.impl.future;

import com.simba.athena.dsi.core.utilities.impl.future.ConversionConfig;
import com.simba.athena.dsi.core.utilities.impl.future.ConvertingJDBCDataSource;
import com.simba.athena.dsi.dataengine.interfaces.IArray;
import com.simba.athena.dsi.dataengine.interfaces.future.IJDBCExecution;
import com.simba.athena.dsi.exceptions.ConversionFailed;
import com.simba.athena.dsi.exceptions.IncorrectTypeException;
import com.simba.athena.dsi.exceptions.future.UnsupportedException;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.exceptions.ErrorException;
import java.sql.SQLException;

public abstract class ArrayJDBCDataSource
extends ConvertingJDBCDataSource {
    public ArrayJDBCDataSource(IWarningListener iWarningListener, ConversionConfig conversionConfig) {
        super(iWarningListener, conversionConfig);
    }

    @Override
    public abstract IArray get() throws ErrorException;

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        IArray iArray = this.get();
        if (iArray == null) {
            return null;
        }
        return iArray.getStringRepresentation();
    }

    @Override
    public IArray getArray() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException, UnsupportedException {
        return this.get();
    }

    @Override
    protected boolean supportsConversionToRegisteredType(IJDBCExecution.OutputParameterRegistration outputParameterRegistration) {
        int n = this.getSqlTypeFromRegistration(outputParameterRegistration);
        switch (n) {
            case 2000: 
            case 2003: {
                return true;
            }
        }
        return this.isCharType(n);
    }
}

