/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.services.glue.model.Union;
import java.util.List;

@SdkInternalApi
public class UnionMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<List> INPUTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Inputs").build();
    private static final MarshallingInfo<String> UNIONTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UnionType").build();
    private static final UnionMarshaller instance = new UnionMarshaller();

    public static UnionMarshaller getInstance() {
        return instance;
    }

    public void marshall(Union union, ProtocolMarshaller protocolMarshaller) {
        if (union == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(union.getName(), NAME_BINDING);
            protocolMarshaller.marshall(union.getInputs(), INPUTS_BINDING);
            protocolMarshaller.marshall(union.getUnionType(), UNIONTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

