/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.services.glue.model.SchemaVersionNumber;

@SdkInternalApi
public class SchemaVersionNumberMarshaller {
    private static final MarshallingInfo<Boolean> LATESTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestVersion").build();
    private static final MarshallingInfo<Long> VERSIONNUMBER_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionNumber").build();
    private static final SchemaVersionNumberMarshaller instance = new SchemaVersionNumberMarshaller();

    public static SchemaVersionNumberMarshaller getInstance() {
        return instance;
    }

    public void marshall(SchemaVersionNumber schemaVersionNumber, ProtocolMarshaller protocolMarshaller) {
        if (schemaVersionNumber == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(schemaVersionNumber.getLatestVersion(), LATESTVERSION_BINDING);
            protocolMarshaller.marshall(schemaVersionNumber.getVersionNumber(), VERSIONNUMBER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

