/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.services.glue.model.S3SourceAdditionalOptions;

@SdkInternalApi
public class S3SourceAdditionalOptionsMarshaller {
    private static final MarshallingInfo<Long> BOUNDEDSIZE_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BoundedSize").build();
    private static final MarshallingInfo<Long> BOUNDEDFILES_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BoundedFiles").build();
    private static final S3SourceAdditionalOptionsMarshaller instance = new S3SourceAdditionalOptionsMarshaller();

    public static S3SourceAdditionalOptionsMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3SourceAdditionalOptions s3SourceAdditionalOptions, ProtocolMarshaller protocolMarshaller) {
        if (s3SourceAdditionalOptions == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(s3SourceAdditionalOptions.getBoundedSize(), BOUNDEDSIZE_BINDING);
            protocolMarshaller.marshall(s3SourceAdditionalOptions.getBoundedFiles(), BOUNDEDFILES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

