/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.services.glue.model.BlueprintRun;
import java.util.Date;

@SdkInternalApi
public class BlueprintRunMarshaller {
    private static final MarshallingInfo<String> BLUEPRINTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BlueprintName").build();
    private static final MarshallingInfo<String> RUNID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RunId").build();
    private static final MarshallingInfo<String> WORKFLOWNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkflowName").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<Date> STARTEDON_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedOn").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> COMPLETEDON_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletedOn").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").build();
    private static final MarshallingInfo<String> ROLLBACKERRORMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RollbackErrorMessage").build();
    private static final MarshallingInfo<String> PARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").build();
    private static final BlueprintRunMarshaller instance = new BlueprintRunMarshaller();

    public static BlueprintRunMarshaller getInstance() {
        return instance;
    }

    public void marshall(BlueprintRun blueprintRun, ProtocolMarshaller protocolMarshaller) {
        if (blueprintRun == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(blueprintRun.getBlueprintName(), BLUEPRINTNAME_BINDING);
            protocolMarshaller.marshall(blueprintRun.getRunId(), RUNID_BINDING);
            protocolMarshaller.marshall(blueprintRun.getWorkflowName(), WORKFLOWNAME_BINDING);
            protocolMarshaller.marshall(blueprintRun.getState(), STATE_BINDING);
            protocolMarshaller.marshall(blueprintRun.getStartedOn(), STARTEDON_BINDING);
            protocolMarshaller.marshall(blueprintRun.getCompletedOn(), COMPLETEDON_BINDING);
            protocolMarshaller.marshall(blueprintRun.getErrorMessage(), ERRORMESSAGE_BINDING);
            protocolMarshaller.marshall(blueprintRun.getRollbackErrorMessage(), ROLLBACKERRORMESSAGE_BINDING);
            protocolMarshaller.marshall(blueprintRun.getParameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(blueprintRun.getRoleArn(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

