/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model;

import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.protocol.StructuredPojo;
import com.simba.athena.amazonaws.services.glue.model.PiiType;
import com.simba.athena.amazonaws.services.glue.model.transform.PIIDetectionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PIIDetection
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<String> inputs;
    private String piiType;
    private List<String> entityTypesToDetect;
    private String outputColumnName;
    private Double sampleFraction;
    private Double thresholdFraction;
    private String maskValue;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public PIIDetection withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(Collection<String> inputs) {
        if (inputs == null) {
            this.inputs = null;
            return;
        }
        this.inputs = new ArrayList<String>(inputs);
    }

    public PIIDetection withInputs(String ... inputs) {
        if (this.inputs == null) {
            this.setInputs(new ArrayList<String>(inputs.length));
        }
        for (String ele : inputs) {
            this.inputs.add(ele);
        }
        return this;
    }

    public PIIDetection withInputs(Collection<String> inputs) {
        this.setInputs(inputs);
        return this;
    }

    public void setPiiType(String piiType) {
        this.piiType = piiType;
    }

    public String getPiiType() {
        return this.piiType;
    }

    public PIIDetection withPiiType(String piiType) {
        this.setPiiType(piiType);
        return this;
    }

    public PIIDetection withPiiType(PiiType piiType) {
        this.piiType = piiType.toString();
        return this;
    }

    public List<String> getEntityTypesToDetect() {
        return this.entityTypesToDetect;
    }

    public void setEntityTypesToDetect(Collection<String> entityTypesToDetect) {
        if (entityTypesToDetect == null) {
            this.entityTypesToDetect = null;
            return;
        }
        this.entityTypesToDetect = new ArrayList<String>(entityTypesToDetect);
    }

    public PIIDetection withEntityTypesToDetect(String ... entityTypesToDetect) {
        if (this.entityTypesToDetect == null) {
            this.setEntityTypesToDetect(new ArrayList<String>(entityTypesToDetect.length));
        }
        for (String ele : entityTypesToDetect) {
            this.entityTypesToDetect.add(ele);
        }
        return this;
    }

    public PIIDetection withEntityTypesToDetect(Collection<String> entityTypesToDetect) {
        this.setEntityTypesToDetect(entityTypesToDetect);
        return this;
    }

    public void setOutputColumnName(String outputColumnName) {
        this.outputColumnName = outputColumnName;
    }

    public String getOutputColumnName() {
        return this.outputColumnName;
    }

    public PIIDetection withOutputColumnName(String outputColumnName) {
        this.setOutputColumnName(outputColumnName);
        return this;
    }

    public void setSampleFraction(Double sampleFraction) {
        this.sampleFraction = sampleFraction;
    }

    public Double getSampleFraction() {
        return this.sampleFraction;
    }

    public PIIDetection withSampleFraction(Double sampleFraction) {
        this.setSampleFraction(sampleFraction);
        return this;
    }

    public void setThresholdFraction(Double thresholdFraction) {
        this.thresholdFraction = thresholdFraction;
    }

    public Double getThresholdFraction() {
        return this.thresholdFraction;
    }

    public PIIDetection withThresholdFraction(Double thresholdFraction) {
        this.setThresholdFraction(thresholdFraction);
        return this;
    }

    public void setMaskValue(String maskValue) {
        this.maskValue = maskValue;
    }

    public String getMaskValue() {
        return this.maskValue;
    }

    public PIIDetection withMaskValue(String maskValue) {
        this.setMaskValue(maskValue);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getInputs() != null) {
            sb.append("Inputs: ").append(this.getInputs()).append(",");
        }
        if (this.getPiiType() != null) {
            sb.append("PiiType: ").append(this.getPiiType()).append(",");
        }
        if (this.getEntityTypesToDetect() != null) {
            sb.append("EntityTypesToDetect: ").append(this.getEntityTypesToDetect()).append(",");
        }
        if (this.getOutputColumnName() != null) {
            sb.append("OutputColumnName: ").append(this.getOutputColumnName()).append(",");
        }
        if (this.getSampleFraction() != null) {
            sb.append("SampleFraction: ").append(this.getSampleFraction()).append(",");
        }
        if (this.getThresholdFraction() != null) {
            sb.append("ThresholdFraction: ").append(this.getThresholdFraction()).append(",");
        }
        if (this.getMaskValue() != null) {
            sb.append("MaskValue: ").append(this.getMaskValue());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PIIDetection)) {
            return false;
        }
        PIIDetection other = (PIIDetection)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getInputs() == null ^ this.getInputs() == null) {
            return false;
        }
        if (other.getInputs() != null && !other.getInputs().equals(this.getInputs())) {
            return false;
        }
        if (other.getPiiType() == null ^ this.getPiiType() == null) {
            return false;
        }
        if (other.getPiiType() != null && !other.getPiiType().equals(this.getPiiType())) {
            return false;
        }
        if (other.getEntityTypesToDetect() == null ^ this.getEntityTypesToDetect() == null) {
            return false;
        }
        if (other.getEntityTypesToDetect() != null && !other.getEntityTypesToDetect().equals(this.getEntityTypesToDetect())) {
            return false;
        }
        if (other.getOutputColumnName() == null ^ this.getOutputColumnName() == null) {
            return false;
        }
        if (other.getOutputColumnName() != null && !other.getOutputColumnName().equals(this.getOutputColumnName())) {
            return false;
        }
        if (other.getSampleFraction() == null ^ this.getSampleFraction() == null) {
            return false;
        }
        if (other.getSampleFraction() != null && !other.getSampleFraction().equals(this.getSampleFraction())) {
            return false;
        }
        if (other.getThresholdFraction() == null ^ this.getThresholdFraction() == null) {
            return false;
        }
        if (other.getThresholdFraction() != null && !other.getThresholdFraction().equals(this.getThresholdFraction())) {
            return false;
        }
        if (other.getMaskValue() == null ^ this.getMaskValue() == null) {
            return false;
        }
        return other.getMaskValue() == null || other.getMaskValue().equals(this.getMaskValue());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getInputs() == null ? 0 : this.getInputs().hashCode());
        hashCode = 31 * hashCode + (this.getPiiType() == null ? 0 : this.getPiiType().hashCode());
        hashCode = 31 * hashCode + (this.getEntityTypesToDetect() == null ? 0 : this.getEntityTypesToDetect().hashCode());
        hashCode = 31 * hashCode + (this.getOutputColumnName() == null ? 0 : this.getOutputColumnName().hashCode());
        hashCode = 31 * hashCode + (this.getSampleFraction() == null ? 0 : this.getSampleFraction().hashCode());
        hashCode = 31 * hashCode + (this.getThresholdFraction() == null ? 0 : this.getThresholdFraction().hashCode());
        hashCode = 31 * hashCode + (this.getMaskValue() == null ? 0 : this.getMaskValue().hashCode());
        return hashCode;
    }

    public PIIDetection clone() {
        try {
            return (PIIDetection)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PIIDetectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

