/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.athena.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.services.athena.model.TableMetadata;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class TableMetadataMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<Date> CREATETIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTACCESSTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastAccessTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> TABLETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableType").build();
    private static final MarshallingInfo<List> COLUMNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Columns").build();
    private static final MarshallingInfo<List> PARTITIONKEYS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionKeys").build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").build();
    private static final TableMetadataMarshaller instance = new TableMetadataMarshaller();

    public static TableMetadataMarshaller getInstance() {
        return instance;
    }

    public void marshall(TableMetadata tableMetadata, ProtocolMarshaller protocolMarshaller) {
        if (tableMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(tableMetadata.getName(), NAME_BINDING);
            protocolMarshaller.marshall(tableMetadata.getCreateTime(), CREATETIME_BINDING);
            protocolMarshaller.marshall(tableMetadata.getLastAccessTime(), LASTACCESSTIME_BINDING);
            protocolMarshaller.marshall(tableMetadata.getTableType(), TABLETYPE_BINDING);
            protocolMarshaller.marshall(tableMetadata.getColumns(), COLUMNS_BINDING);
            protocolMarshaller.marshall(tableMetadata.getPartitionKeys(), PARTITIONKEYS_BINDING);
            protocolMarshaller.marshall(tableMetadata.getParameters(), PARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

