/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryValueTypeCastExpression
extends SQLQueryValueExpression {
    @NotNull
    private final SQLQueryValueExpression value;
    @NotNull
    private final String typeRefString;

    public SQLQueryValueTypeCastExpression(@NotNull STMTreeNode syntaxNode, @NotNull SQLQueryValueExpression value, @NotNull String typeRefString) {
        super(syntaxNode, new SQLQueryNodeModel[0]);
        this.value = value;
        this.typeRefString = typeRefString;
    }

    @NotNull
    public String getTypeRefString() {
        return this.typeRefString;
    }

    @NotNull
    public SQLQueryValueExpression getValueExpr() {
        return this.value;
    }

    @Override
    protected void propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        this.value.propagateContext(context, statistics);
        this.type = SQLQueryExprType.forExplicitTypeRef(this.typeRefString);
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitValueTypeCastExpr(this, arg);
    }

    public String toString() {
        return "TypeCast[" + this.value.toString() + ", " + this.typeRefString + "]";
    }
}

