/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModelContent;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryTableUpdateSetClauseModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryTableUpdateModel
extends SQLQueryModelContent {
    @Nullable
    private final SQLQueryRowsSourceModel targetRows;
    @Nullable
    private final List<SQLQueryTableUpdateSetClauseModel> setClauseList;
    @Nullable
    private final SQLQueryRowsSourceModel sourceRows;
    @Nullable
    private final SQLQueryValueExpression whereClause;
    @Nullable
    private final SQLQueryValueExpression orderByClause;
    @Nullable
    private SQLQueryDataContext givenContext = null;
    @Nullable
    private SQLQueryDataContext resultContext = null;

    public SQLQueryTableUpdateModel(@NotNull STMTreeNode syntaxNode, @Nullable SQLQueryRowsSourceModel targetRows, @Nullable List<SQLQueryTableUpdateSetClauseModel> setClauseList, @Nullable SQLQueryRowsSourceModel sourceRows, @Nullable SQLQueryValueExpression whereClause, @Nullable SQLQueryValueExpression orderByClause) {
        super(syntaxNode.getRealInterval(), syntaxNode, new SQLQueryNodeModel[0]);
        this.targetRows = targetRows;
        this.setClauseList = setClauseList;
        this.sourceRows = sourceRows;
        this.whereClause = whereClause;
        this.orderByClause = orderByClause;
    }

    @Nullable
    public SQLQueryRowsSourceModel getTargetRows() {
        return this.targetRows;
    }

    @Nullable
    public List<SQLQueryTableUpdateSetClauseModel> getSetClauseList() {
        return this.setClauseList;
    }

    @Nullable
    public SQLQueryRowsSourceModel getSourceRows() {
        return this.sourceRows;
    }

    @Nullable
    public SQLQueryValueExpression getWhereClause() {
        return this.whereClause;
    }

    @Nullable
    public SQLQueryValueExpression getOrderByClause() {
        return this.orderByClause;
    }

    @Override
    void applyContext(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryDataContext sourceContext;
        SQLQueryDataContext targetContext;
        this.givenContext = context;
        if (this.targetRows != null) {
            targetContext = this.targetRows.propagateContext(context, statistics);
            if (this.setClauseList != null) {
                for (SQLQueryTableUpdateSetClauseModel updateSetClauseModel : this.setClauseList) {
                    for (SQLQueryValueExpression valueExpression : updateSetClauseModel.targets) {
                        valueExpression.propagateContext(targetContext, statistics);
                    }
                }
            }
        } else {
            targetContext = context;
        }
        SQLQueryDataContext sQLQueryDataContext = sourceContext = this.sourceRows != null ? this.sourceRows.propagateContext(context, statistics) : context;
        if (targetContext != context || sourceContext != context) {
            context = targetContext.combine(sourceContext);
        }
        if (this.setClauseList != null) {
            for (SQLQueryTableUpdateSetClauseModel setClauseModel : this.setClauseList) {
                for (SQLQueryValueExpression valueExpression : setClauseModel.sources) {
                    valueExpression.propagateContext(targetContext, statistics);
                }
            }
        }
        if (this.whereClause != null) {
            this.whereClause.propagateContext(context, statistics);
        }
        if (this.orderByClause != null) {
            this.orderByClause.propagateContext(context, statistics);
        }
        this.resultContext = context;
    }

    @Override
    public SQLQueryDataContext getGivenDataContext() {
        return this.givenContext;
    }

    @Override
    public SQLQueryDataContext getResultDataContext() {
        return this.resultContext;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitTableStatementUpdate(this, arg);
    }
}

