/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryTableStatementModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryValueColumnReferenceExpression;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryTableInsertModel
extends SQLQueryTableStatementModel {
    @Nullable
    private final List<SQLQuerySymbolEntry> columnNames;
    @Nullable
    private final SQLQueryRowsSourceModel valuesRows;

    public SQLQueryTableInsertModel(@NotNull STMTreeNode syntaxNode, @Nullable SQLQueryRowsTableDataModel tableModel, @Nullable List<SQLQuerySymbolEntry> columnNames, @Nullable SQLQueryRowsSourceModel valuesRows) {
        super(syntaxNode, tableModel);
        this.columnNames = columnNames;
        this.valuesRows = valuesRows;
    }

    @Nullable
    public List<SQLQuerySymbolEntry> getColumnNames() {
        return this.columnNames;
    }

    @Nullable
    public SQLQueryRowsSourceModel getValuesRows() {
        return this.valuesRows;
    }

    @Override
    public void propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        if (this.columnNames != null) {
            for (SQLQuerySymbolEntry columnName : this.columnNames) {
                if (!columnName.isNotClassified()) continue;
                SQLQueryResultColumn column = context.resolveColumn(statistics.getMonitor(), columnName.getName());
                SQLQueryValueColumnReferenceExpression.propagateColumnDefinition(columnName, column, statistics);
            }
        }
        if (this.valuesRows != null) {
            this.valuesRows.propagateContext(context, statistics);
        }
    }

    @Override
    @Nullable
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitTableStatementInsert(this, arg);
    }
}

