/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model;

import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsProjectionModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQuerySelectionResultModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQuerySelectionResultSublistSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryValueTupleReferenceExpression;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQuerySelectionResultTupleSpec
extends SQLQuerySelectionResultSublistSpec {
    @NotNull
    private final SQLQueryValueTupleReferenceExpression tupleReference;

    public SQLQuerySelectionResultTupleSpec(@NotNull SQLQuerySelectionResultModel resultModel, @NotNull STMTreeNode syntaxNode, @NotNull SQLQueryValueTupleReferenceExpression tupleReference) {
        super(resultModel, syntaxNode);
        this.tupleReference = tupleReference;
        this.registerSubnode(tupleReference);
    }

    @NotNull
    public SQLQueryQualifiedName getTableName() {
        return this.tupleReference.getTableName();
    }

    @Nullable
    public SQLQueryRowsSourceModel getTupleSource() {
        return this.tupleReference.getTupleSource();
    }

    @Override
    @NotNull
    protected Stream<SQLQueryResultColumn> expand(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRowsProjectionModel rowsSourceModel, @NotNull SQLQueryRecognitionContext statistics) {
        this.tupleReference.propagateContext(context, statistics);
        SQLQueryRowsSourceModel tupleSource = this.tupleReference.getTupleSource();
        if (tupleSource != null) {
            return tupleSource.getResultDataContext().getColumnsList().stream();
        }
        return Stream.empty();
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T node) {
        return visitor.visitSelectTupleSpec(this, node);
    }
}

