/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsProjectionModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQuerySelectionResultColumnSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQuerySelectionResultCompleteTupleSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQuerySelectionResultSublistSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQuerySelectionResultTupleSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryValueTupleReferenceExpression;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQuerySelectionResultModel
extends SQLQueryNodeModel {
    @NotNull
    private final List<SQLQuerySelectionResultSublistSpec> sublists;
    @Nullable
    private SQLQueryDataContext dataContext = null;

    public SQLQuerySelectionResultModel(@NotNull STMTreeNode syntaxNode, int capacity) {
        super(syntaxNode.getRealInterval(), syntaxNode, new SQLQueryNodeModel[0]);
        this.sublists = new ArrayList<SQLQuerySelectionResultSublistSpec>(capacity);
    }

    @NotNull
    public List<SQLQuerySelectionResultSublistSpec> getSublists() {
        return this.sublists;
    }

    @Override
    @Nullable
    public SQLQueryDataContext getGivenDataContext() {
        return this.dataContext;
    }

    @Override
    @Nullable
    public SQLQueryDataContext getResultDataContext() {
        return this.dataContext;
    }

    private void registerSublist(SQLQuerySelectionResultSublistSpec sublist) {
        this.sublists.add(sublist);
        super.registerSubnode(sublist);
    }

    public void addColumnSpec(@NotNull STMTreeNode syntaxNode, @NotNull SQLQueryValueExpression valueExpression) {
        this.registerSublist(new SQLQuerySelectionResultColumnSpec(this, syntaxNode, valueExpression));
    }

    public void addColumnSpec(@NotNull STMTreeNode syntaxNode, @NotNull SQLQueryValueExpression valueExpression, @Nullable SQLQuerySymbolEntry alias) {
        this.registerSublist(new SQLQuerySelectionResultColumnSpec(this, syntaxNode, valueExpression, alias));
    }

    public void addTupleSpec(@NotNull STMTreeNode syntaxNode, @NotNull SQLQueryValueTupleReferenceExpression tupleRef) {
        this.registerSublist(new SQLQuerySelectionResultTupleSpec(this, syntaxNode, tupleRef));
    }

    public void addCompleteTupleSpec(@NotNull STMTreeNode syntaxNode) {
        this.registerSublist(new SQLQuerySelectionResultCompleteTupleSpec(this, syntaxNode));
    }

    @NotNull
    public List<SQLQueryResultColumn> expandColumns(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRowsProjectionModel rowsSourceModel, @NotNull SQLQueryRecognitionContext statistics) {
        this.dataContext = context;
        return this.sublists.stream().flatMap(s -> s.expand(context, rowsSourceModel, statistics)).collect(Collectors.toList());
    }

    @Override
    @Nullable
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T node) {
        return visitor.visitSelectionResult(this, node);
    }
}

