/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model;

import java.util.EnumSet;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScope;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQuerySelectionResultModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryRowsProjectionModel
extends SQLQueryRowsSourceModel {
    @NotNull
    private final SQLQueryLexicalScope selectListScope;
    @NotNull
    private final SQLQueryRowsSourceModel fromSource;
    @NotNull
    private final SQLQuerySelectionResultModel result;
    @Nullable
    private final SQLQueryValueExpression whereClause;
    @Nullable
    private final SQLQueryValueExpression havingClause;
    @Nullable
    private final SQLQueryValueExpression groupByClause;
    @Nullable
    private final SQLQueryValueExpression orderByClause;

    public SQLQueryRowsProjectionModel(@NotNull STMTreeNode syntaxNode, @NotNull SQLQueryLexicalScope selectListScope, @NotNull SQLQueryRowsSourceModel fromSource, @NotNull SQLQuerySelectionResultModel result) {
        this(syntaxNode, selectListScope, fromSource, result, null, null, null, null);
    }

    public SQLQueryRowsProjectionModel(@NotNull STMTreeNode syntaxNode, @NotNull SQLQueryLexicalScope selectListScope, @NotNull SQLQueryRowsSourceModel fromSource, @NotNull SQLQuerySelectionResultModel result, @Nullable SQLQueryValueExpression whereClause, @Nullable SQLQueryValueExpression havingClause, @Nullable SQLQueryValueExpression groupByClause, @Nullable SQLQueryValueExpression orderByClause) {
        super(syntaxNode, fromSource, result, whereClause, havingClause, groupByClause, orderByClause);
        this.result = result;
        this.selectListScope = selectListScope;
        this.fromSource = fromSource;
        this.whereClause = whereClause;
        this.havingClause = havingClause;
        this.groupByClause = groupByClause;
        this.orderByClause = orderByClause;
        this.registerLexicalScope(selectListScope);
    }

    @NotNull
    public SQLQueryRowsSourceModel getFromSource() {
        return this.fromSource;
    }

    @NotNull
    public SQLQuerySelectionResultModel getResult() {
        return this.result;
    }

    @Nullable
    public SQLQueryValueExpression getWhereClause() {
        return this.whereClause;
    }

    @Nullable
    public SQLQueryValueExpression getHavingClause() {
        return this.havingClause;
    }

    @Nullable
    public SQLQueryValueExpression getGroupByClause() {
        return this.groupByClause;
    }

    @Nullable
    public SQLQueryValueExpression getOrderByClause() {
        return this.orderByClause;
    }

    @Override
    @NotNull
    protected SQLQueryDataContext propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryDataContext unresolvedResult = this.fromSource.propagateContext(context, statistics);
        this.selectListScope.setContext(unresolvedResult);
        EnumSet aliasScope = context.getDialect().getProjectionAliasVisibilityScope();
        List<SQLQueryResultColumn> resultColumns = this.result.expandColumns(unresolvedResult, this, statistics);
        SQLQueryDataContext resolvedResult = unresolvedResult.overrideResultTuple(resultColumns);
        SQLQueryDataContext filtersContext = resolvedResult.combine(unresolvedResult);
        if (this.whereClause != null) {
            this.whereClause.propagateContext(aliasScope.contains(SQLDialect.ProjectionAliasVisibilityScope.WHERE) ? filtersContext : unresolvedResult, statistics);
        }
        if (this.havingClause != null) {
            this.havingClause.propagateContext(aliasScope.contains(SQLDialect.ProjectionAliasVisibilityScope.HAVING) ? filtersContext : unresolvedResult, statistics);
        }
        if (this.groupByClause != null) {
            this.groupByClause.propagateContext(aliasScope.contains(SQLDialect.ProjectionAliasVisibilityScope.GROUP_BY) ? filtersContext : unresolvedResult, statistics);
        }
        if (this.orderByClause != null) {
            this.orderByClause.propagateContext(aliasScope.contains(SQLDialect.ProjectionAliasVisibilityScope.ORDER_BY) ? filtersContext : unresolvedResult, statistics);
        }
        return resolvedResult.hideSources();
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitRowsProjection(this, arg);
    }
}

