/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsCorrelatedSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsCteSubqueryModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryRowsCteModel
extends SQLQueryRowsSourceModel {
    private final boolean isRecursive;
    @NotNull
    private final List<SQLQueryRowsCteSubqueryModel> subqueries = new ArrayList<SQLQueryRowsCteSubqueryModel>();
    @NotNull
    private final SQLQueryRowsSourceModel resultQuery;

    public SQLQueryRowsCteModel(@NotNull STMTreeNode syntaxNode, boolean isRecursive, @NotNull SQLQueryRowsSourceModel resultQuery) {
        super(syntaxNode, resultQuery);
        this.isRecursive = isRecursive;
        this.resultQuery = resultQuery;
    }

    public void addSubquery(@NotNull STMTreeNode syntaxNode, @NotNull SQLQuerySymbolEntry subqueryName, @NotNull List<SQLQuerySymbolEntry> columnNames, @NotNull SQLQueryRowsSourceModel source) {
        SQLQueryRowsCteSubqueryModel subquery = new SQLQueryRowsCteSubqueryModel(syntaxNode, subqueryName, columnNames, source);
        this.subqueries.add(subquery);
        super.registerSubnode(subquery);
    }

    @NotNull
    public List<SQLQueryRowsSourceModel> getAllQueries() {
        ArrayList<SQLQueryRowsSourceModel> queries = new ArrayList<SQLQueryRowsSourceModel>(this.subqueries.size() + 1);
        queries.addAll(this.subqueries);
        queries.add(this.resultQuery);
        return queries;
    }

    @Override
    @NotNull
    protected SQLQueryDataContext propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryDataContext aggregatedContext = context;
        if (this.isRecursive) {
            for (SQLQueryRowsCteSubqueryModel subquery : this.subqueries) {
                subquery.propagateContext(context, statistics);
                aggregatedContext = aggregatedContext.combine(aggregatedContext.hideSources().extendWithTableAlias(subquery.subqueryName.getSymbol(), subquery));
            }
            for (SQLQueryRowsCteSubqueryModel subquery : this.subqueries) {
                if (!subquery.subqueryName.isNotClassified()) continue;
                context = subquery.source.propagateContext(aggregatedContext, statistics).hideSources();
                subquery.propagateContext(context, statistics);
                subquery.prepareAliasDefinition();
            }
        } else {
            for (SQLQueryRowsCteSubqueryModel subquery : this.subqueries) {
                if (!subquery.subqueryName.isNotClassified()) continue;
                SQLQueryDataContext currCtx = subquery.source.propagateContext(aggregatedContext, statistics).hideSources().extendWithTableAlias(subquery.subqueryName.getSymbol(), subquery);
                subquery.prepareAliasDefinition();
                currCtx = SQLQueryRowsCorrelatedSourceModel.prepareColumnsCorrelation(currCtx, subquery.columNames, subquery);
                subquery.propagateContext(currCtx, statistics);
                aggregatedContext = aggregatedContext.combine(currCtx);
            }
        }
        return this.resultQuery.propagateContext(aggregatedContext, statistics).hideSources();
    }

    @Override
    @Nullable
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitRowsCte(this, arg);
    }
}

