/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.context;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolByDbObjectDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDummyDataSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypeDescriptor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx2;

public abstract class SQLQueryExprType {
    public static final SQLQueryExprType UNKNOWN = new SQLQueryExprPredefinedType("UNKNOWN", DBPDataKind.UNKNOWN);
    public static final SQLQueryExprType STRING = new SQLQueryExprPredefinedType("STRING", DBPDataKind.STRING);
    public static final SQLQueryExprType BOOLEAN = new SQLQueryExprPredefinedType("BOOLEAN", DBPDataKind.BOOLEAN);
    public static final SQLQueryExprType NUMERIC = new SQLQueryExprPredefinedType("NUMERIC", DBPDataKind.NUMERIC);
    public static final SQLQueryExprType DATETIME = new SQLQueryExprPredefinedType("DATETIME", DBPDataKind.DATETIME);
    public static final SQLQueryExprType DUMMY = new SQLQueryExprDummyType(null);
    private static final SQLQueryExprType DUMMY_FIELD = new SQLQueryExprDummyType(() -> SQLQuerySymbolClass.COMPOSITE_FIELD);
    protected final SQLQuerySymbolDefinition declaratorDefinition;
    protected final DBPDataKind dataKind;
    protected final DBSTypedObject typedObject;

    public SQLQueryExprType(@Nullable SQLQuerySymbolDefinition declaratorDefinition, @NotNull DBPDataKind dataKind) {
        this.declaratorDefinition = declaratorDefinition;
        this.dataKind = dataKind;
        this.typedObject = null;
    }

    public SQLQueryExprType(@Nullable SQLQuerySymbolDefinition declaratorDefinition, @NotNull DBSTypedObject typedObject) {
        this.declaratorDefinition = declaratorDefinition;
        this.dataKind = typedObject.getDataKind();
        this.typedObject = typedObject;
    }

    @Nullable
    public abstract String getDisplayName();

    @Nullable
    public final SQLQuerySymbolDefinition getDeclaratorDefinition() {
        return this.declaratorDefinition;
    }

    @NotNull
    public final DBPDataKind getDataKind() {
        return this.dataKind;
    }

    @Nullable
    public final DBSTypedObject getTypedDbObject() {
        return this.typedObject;
    }

    @Nullable
    public SQLQueryExprType findNamedMemberType(@NotNull DBRProgressMonitor monitor, @NotNull String memberName) throws DBException {
        return null;
    }

    @Nullable
    public SQLQueryExprType findIndexedItemType(@NotNull DBRProgressMonitor monitor, int depth, @Nullable boolean[] slicingSpec) throws DBException {
        return null;
    }

    @NotNull
    public static SQLQueryExprType forScalarSubquery(@NotNull SQLQueryRowsSourceModel source) {
        List<SQLQueryResultColumn> columns = source.getResultDataContext().getColumnsList();
        return columns.isEmpty() ? UNKNOWN : columns.get((int)0).type;
    }

    @NotNull
    public static SQLQueryExprType forExplicitTypeRef(@NotNull String typeRefString) {
        return new SQLQueryExprPredefinedType(typeRefString, DBPDataKind.UNKNOWN);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static SQLQueryExprType forTypedObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSTypedObject typedObj, @NotNull SQLQuerySymbolClass defSymbolClass) throws DBException {
        SQLQuerySymbolByDbObjectDefinition sQLQuerySymbolByDbObjectDefinition;
        DBSTypedObject dBSTypedObject = typedObj;
        if (dBSTypedObject instanceof DBSObject) {
            void dbObj;
            DBSObject dBSObject = (DBSObject)dBSTypedObject;
            DBSObject cfr_ignored_0 = (DBSObject)dBSTypedObject;
            sQLQuerySymbolByDbObjectDefinition = new SQLQuerySymbolByDbObjectDefinition((DBSObject)dbObj, defSymbolClass);
        } else {
            sQLQuerySymbolByDbObjectDefinition = null;
        }
        return SQLQueryExprType.forTypedObjectImpl(monitor, typedObj, sQLQuerySymbolByDbObjectDefinition);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static SQLQueryExprType forTypedObjectImpl(@NotNull DBRProgressMonitor monitor, @NotNull DBSTypedObject typedObj, @Nullable SQLQuerySymbolDefinition declaratorDefinition) throws DBException {
        DBSTypedObject dBSTypedObject;
        DBSDataType type;
        DBSTypedObject dBSTypedObject2;
        Object type2;
        if (SQLQueryDummyDataSourceContext.isDummyObject(typedObj)) {
            return DUMMY;
        }
        DBSTypedObject dBSTypedObject3 = typedObj;
        if (dBSTypedObject3 instanceof DBSTypedObjectEx2) {
            void typedEx2;
            DBSTypedObjectEx2 dBSTypedObjectEx2 = (DBSTypedObjectEx2)dBSTypedObject3;
            DBSTypedObjectEx2 cfr_ignored_0 = (DBSTypedObjectEx2)dBSTypedObject3;
            type2 = SQLQueryExprType.forDescribedIfPresented(monitor, typedObj, typedEx2.getTypeDescriptor(), declaratorDefinition);
            if (type2 != null) {
                return type2;
            }
        }
        if ((dBSTypedObject2 = typedObj) instanceof DBSTypedObjectEx) {
            void typedEx;
            type2 = (DBSTypedObjectEx)dBSTypedObject2;
            DBSTypedObjectEx cfr_ignored_1 = (DBSTypedObjectEx)dBSTypedObject2;
            type = typedEx.getDataType();
            if (type != null) {
                return SQLQueryExprType.forTypedObjectImpl(monitor, (DBSTypedObject)type, declaratorDefinition);
            }
        }
        if ((dBSTypedObject = typedObj) instanceof DBSDataType) {
            type = (DBSDataType)dBSTypedObject;
            DBSDataType cfr_ignored_2 = (DBSDataType)dBSTypedObject;
            DBSDataType itemType = type.getComponentType(monitor);
            if (itemType != null) {
                return new SQLQueryExprIndexableType(declaratorDefinition, typedObj, itemType);
            }
            DBSTypedObject dBSTypedObject4 = typedObj;
            if (dBSTypedObject4 instanceof DBSEntity) {
                void complexType;
                DBSEntity dBSEntity = (DBSEntity)dBSTypedObject4;
                DBSEntity cfr_ignored_3 = (DBSEntity)dBSTypedObject4;
                DBPDataSource dataSource = complexType.getDataSource();
                BasicSQLDialect dialect = dataSource == null ? BasicSQLDialect.INSTANCE : dataSource.getSQLDialect();
                List attrs = complexType.getAttributes(monitor);
                if (attrs != null) {
                    Map<String, DBSAttributeBase> attrsByName = attrs.stream().collect(Collectors.toMap(arg_0 -> SQLQueryExprType.lambda$1((SQLDialect)dialect, arg_0), a -> a, (a, b) -> a));
                    return new SQLQueryExprComplexType<DBSEntity>(declaratorDefinition, (DBSEntity)((DBSTypedObject)complexType), attrsByName);
                }
            }
        }
        return new SQLQueryExprSimpleType(declaratorDefinition, typedObj);
    }

    @Nullable
    private static SQLQueryExprType forDescribedIfPresented(@NotNull DBRProgressMonitor monitor, @NotNull DBSTypedObject typedObj, @Nullable DBSTypeDescriptor typeDesc, @Nullable SQLQuerySymbolDefinition declaratorDefinition) throws DBException {
        if (typeDesc == null) {
            return null;
        }
        if (typeDesc.isIndexable()) {
            return new SQLQueryExprDescribedIndexableType(declaratorDefinition, typedObj, typeDesc);
        }
        if (typeDesc.getUnderlyingType() != null) {
            return SQLQueryExprType.forTypedObjectImpl(monitor, (DBSTypedObject)typeDesc.getUnderlyingType(), declaratorDefinition);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static SQLQueryExprType tryCombineIfMatches(@NotNull SQLQueryExprType a, @NotNull SQLQueryExprType b) {
        block6: {
            void y;
            void x;
            SQLQueryExprType sQLQueryExprType;
            block8: {
                void y2;
                void x2;
                SQLQueryExprType sQLQueryExprType2;
                block7: {
                    void y3;
                    void x3;
                    if (a.getDataKind().equals((Object)DBPDataKind.ANY)) {
                        return a;
                    }
                    if (b.getDataKind().equals((Object)DBPDataKind.ANY)) {
                        return b;
                    }
                    if (!a.getDataKind().isComplex() && !b.getDataKind().isComplex() && a.getDataKind().equals((Object)b.getDataKind())) break block6;
                    SQLQueryExprType sQLQueryExprType3 = a;
                    if (!(sQLQueryExprType3 instanceof SQLQueryExprComplexType)) break block7;
                    SQLQueryExprComplexType sQLQueryExprComplexType = (SQLQueryExprComplexType)sQLQueryExprType3;
                    SQLQueryExprComplexType cfr_ignored_0 = (SQLQueryExprComplexType)sQLQueryExprType3;
                    SQLQueryExprType sQLQueryExprType4 = b;
                    if (!(sQLQueryExprType4 instanceof SQLQueryExprComplexType)) break block7;
                    SQLQueryExprComplexType sQLQueryExprComplexType2 = (SQLQueryExprComplexType)sQLQueryExprType4;
                    SQLQueryExprComplexType cfr_ignored_1 = (SQLQueryExprComplexType)sQLQueryExprType4;
                    if (x3.complexType.equals(y3.complexType)) break block6;
                }
                if (!((sQLQueryExprType2 = a) instanceof SQLQueryExprIndexableType)) break block8;
                SQLQueryExprIndexableType sQLQueryExprIndexableType = (SQLQueryExprIndexableType)sQLQueryExprType2;
                SQLQueryExprIndexableType cfr_ignored_2 = (SQLQueryExprIndexableType)sQLQueryExprType2;
                SQLQueryExprType sQLQueryExprType5 = b;
                if (!(sQLQueryExprType5 instanceof SQLQueryExprIndexableType)) break block8;
                SQLQueryExprIndexableType sQLQueryExprIndexableType2 = (SQLQueryExprIndexableType)sQLQueryExprType5;
                SQLQueryExprIndexableType cfr_ignored_3 = (SQLQueryExprIndexableType)sQLQueryExprType5;
                if (SQLQueryExprType.isDataTypeMatches(x2.elementType, y2.elementType)) break block6;
            }
            if (!((sQLQueryExprType = a) instanceof SQLQueryExprDescribedIndexableType)) return null;
            SQLQueryExprDescribedIndexableType sQLQueryExprDescribedIndexableType = (SQLQueryExprDescribedIndexableType)sQLQueryExprType;
            SQLQueryExprDescribedIndexableType cfr_ignored_4 = (SQLQueryExprDescribedIndexableType)sQLQueryExprType;
            SQLQueryExprType sQLQueryExprType6 = b;
            if (!(sQLQueryExprType6 instanceof SQLQueryExprDescribedIndexableType)) return null;
            SQLQueryExprDescribedIndexableType sQLQueryExprDescribedIndexableType2 = (SQLQueryExprDescribedIndexableType)sQLQueryExprType6;
            SQLQueryExprDescribedIndexableType cfr_ignored_5 = (SQLQueryExprDescribedIndexableType)sQLQueryExprType6;
            if (!x.typeDesc.equals(y.typeDesc)) {
                return null;
            }
        }
        boolean bl = true;
        boolean matches = bl;
        if (!matches) return null;
        SQLQueryExprType sQLQueryExprType = a;
        return sQLQueryExprType;
    }

    private static boolean isDataTypeMatches(@NotNull DBSDataType a, @NotNull DBSDataType b) {
        return !a.getDataKind().isComplex() && !b.getDataKind().isComplex() && a.getDataKind().equals((Object)b.getDataKind()) || a.getDataKind().isComplex() && b.getDataKind().isComplex() && a.equals(b);
    }

    private static /* synthetic */ String lambda$1(SQLDialect sQLDialect, DBSEntityAttribute a) {
        return SQLUtils.identifierToCanonicalForm((SQLDialect)sQLDialect, (String)a.getName(), (boolean)false, (boolean)true);
    }

    private static class SQLQueryExprComplexType<T extends DBSEntity & DBSTypedObject>
    extends SQLQueryExprType {
        private final T complexType;
        private final Map<String, DBSAttributeBase> attrs;

        public SQLQueryExprComplexType(@Nullable SQLQuerySymbolDefinition declaratorDefinition, @NotNull T complexType, @NotNull Map<String, DBSAttributeBase> attrs) {
            super(declaratorDefinition, (DBSTypedObject)complexType);
            this.complexType = complexType;
            this.attrs = attrs;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return ((DBSTypedObject)this.complexType).getFullTypeName();
        }

        @Override
        public SQLQueryExprType findNamedMemberType(@NotNull DBRProgressMonitor monitor, @NotNull String memberName) throws DBException {
            DBSAttributeBase attr = this.attrs.get(memberName);
            return attr == null ? null : SQLQueryExprComplexType.forTypedObject(monitor, (DBSTypedObject)attr, SQLQuerySymbolClass.COMPOSITE_FIELD);
        }

        public String toString() {
            return "ComplexType[" + ((DBSTypedObject)this.complexType).getFullTypeName() + "]";
        }
    }

    private static class SQLQueryExprDescribedIndexableType
    extends SQLQueryExprType {
        private final DBSTypeDescriptor typeDesc;

        public SQLQueryExprDescribedIndexableType(@Nullable SQLQuerySymbolDefinition declaratorDefinition, @NotNull DBSTypedObject typedObject, @NotNull DBSTypeDescriptor typeDesc) {
            super(declaratorDefinition, typedObject);
            this.typeDesc = typeDesc;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return this.typeDesc.getTypeName();
        }

        @Override
        @Nullable
        public SQLQueryExprType findIndexedItemType(@NotNull DBRProgressMonitor monitor, int depth, @Nullable boolean[] slicingSpec) throws DBException {
            return SQLQueryExprType.forDescribedIfPresented(monitor, this.typedObject, this.typeDesc.getIndexableItemType(depth, slicingSpec), this.getDeclaratorDefinition());
        }
    }

    private static class SQLQueryExprDummyType
    extends SQLQueryExprType {
        public SQLQueryExprDummyType(@Nullable SQLQuerySymbolDefinition declaratorDefinition) {
            super(declaratorDefinition, DBPDataKind.ANY);
        }

        @Override
        @Nullable
        public String getDisplayName() {
            return null;
        }

        @Override
        @NotNull
        public SQLQueryExprType findNamedMemberType(@NotNull DBRProgressMonitor monitor, @NotNull String memberName) {
            return DUMMY_FIELD;
        }

        @Override
        @NotNull
        public SQLQueryExprType findIndexedItemType(@NotNull DBRProgressMonitor monitor, int depth, @Nullable boolean[] slicingSpec) {
            return DUMMY_FIELD;
        }

        @NotNull
        public String toString() {
            return "DummyType[]";
        }
    }

    private static class SQLQueryExprIndexableType
    extends SQLQueryExprType {
        private final DBSDataType elementType;

        public SQLQueryExprIndexableType(@Nullable SQLQuerySymbolDefinition declaratorDefinition, @NotNull DBSTypedObject typedObject, @NotNull DBSDataType elementType) {
            super(declaratorDefinition, typedObject);
            this.elementType = elementType;
        }

        @Override
        public String getDisplayName() {
            return this.typedObject.getFullTypeName();
        }

        private SQLQueryExprType prepareElementType(DBRProgressMonitor monitor) throws DBException {
            return SQLQueryExprType.forTypedObjectImpl(monitor, (DBSTypedObject)this.elementType, this.getDeclaratorDefinition());
        }

        @Override
        public SQLQueryExprType findIndexedItemType(@NotNull DBRProgressMonitor monitor, int depth, @Nullable boolean[] slicingSpec) throws DBException {
            if (slicingSpec == null) {
                SQLQueryExprType type = this.prepareElementType(monitor);
                return depth == 1 ? type : type.findIndexedItemType(monitor, depth - 1, slicingSpec);
            }
            return slicingSpec[slicingSpec.length - depth] ? this : this.prepareElementType(monitor);
        }

        @NotNull
        public String toString() {
            return "IndexableType[" + this.elementType.getFullTypeName() + "]";
        }
    }

    private static class SQLQueryExprPredefinedType
    extends SQLQueryExprType {
        private final String name;

        public SQLQueryExprPredefinedType(@NotNull String name, @NotNull DBPDataKind kind) {
            super(null, kind);
            this.name = name;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return this.name;
        }

        @NotNull
        public String toString() {
            return "PredefinedType[" + this.name + "]";
        }
    }

    private static class SQLQueryExprSimpleType
    extends SQLQueryExprType {
        public SQLQueryExprSimpleType(@Nullable SQLQuerySymbolDefinition declaratorDefinition, @NotNull DBSTypedObject typedObject) {
            super(declaratorDefinition, typedObject);
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return this.typedObject.getFullTypeName();
        }

        @NotNull
        public String toString() {
            return "SimpleType[" + this.typedObject.getFullTypeName() + "]";
        }
    }
}

