/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSearchUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsTableValueModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;

public class SQLQueryDataSourceContext
extends SQLQueryDataContext {
    @NotNull
    private final DBCExecutionContext executionContext;
    @NotNull
    private final SQLDialect dialect;
    @NotNull
    private final SQLIdentifierDetector identifierDetector;

    public SQLQueryDataSourceContext(@NotNull DBCExecutionContext executionContext, @NotNull SQLDialect dialect) {
        this.executionContext = executionContext;
        this.dialect = dialect;
        this.identifierDetector = new SQLIdentifierDetector(dialect);
    }

    @Override
    @NotNull
    public List<SQLQueryResultColumn> getColumnsList() {
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public DBSEntity findRealTable(@NotNull DBRProgressMonitor monitor, @NotNull List<String> tableName) {
        DBPDataSource dBPDataSource = this.executionContext.getDataSource();
        if (dBPDataSource instanceof DBSObjectContainer) {
            DBSEntity dBSEntity;
            void container;
            DBSObject obj;
            DBSObjectContainer dBSObjectContainer = (DBSObjectContainer)dBPDataSource;
            DBSObjectContainer cfr_ignored_0 = (DBSObjectContainer)dBPDataSource;
            ArrayList<String> tableName2 = new ArrayList<String>(tableName);
            DBSObject dBSObject = obj = SQLSearchUtils.findObjectByFQN(monitor, (DBSObjectContainer)container, this.executionContext, tableName2, false, this.identifierDetector);
            if (dBSObject instanceof DBSTable) {
                void table;
                DBSTable dBSTable = (DBSTable)dBSObject;
                DBSTable cfr_ignored_1 = (DBSTable)dBSObject;
                dBSEntity = table;
            } else {
                DBSObject dBSObject2 = obj;
                if (dBSObject2 instanceof DBSView) {
                    void view;
                    DBSView dBSView = (DBSView)dBSObject2;
                    DBSView cfr_ignored_2 = (DBSView)dBSObject2;
                    dBSEntity = view;
                } else {
                    dBSEntity = null;
                }
            }
            return dBSEntity;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public SQLQueryRowsSourceModel findRealSource(@NotNull DBSEntity table) {
        return null;
    }

    @Override
    @Nullable
    public SQLQueryResultColumn resolveColumn(@NotNull DBRProgressMonitor monitor, @NotNull String simpleName) {
        return null;
    }

    @Override
    @NotNull
    public SQLDialect getDialect() {
        return this.dialect;
    }

    @Override
    @NotNull
    public SQLQueryRowsSourceModel getDefaultTable(@NotNull STMTreeNode syntaxNode) {
        return new SQLQueryRowsTableValueModel(syntaxNode, Collections.emptyList());
    }

    @Override
    protected void collectKnownSourcesImpl(@NotNull SQLQueryDataContext.KnownSourcesInfo result) {
    }
}

