/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.context;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultTupleContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;

public class SQLQueryCombinedContext
extends SQLQueryResultTupleContext {
    private final SQLQueryDataContext otherParent;

    public SQLQueryCombinedContext(@NotNull SQLQueryDataContext left, @NotNull SQLQueryDataContext right) {
        super(left, STMUtils.combineLists(left.getColumnsList(), right.getColumnsList()));
        this.otherParent = right;
    }

    @Override
    @Nullable
    public SQLQueryRowsSourceModel findRealSource(@NotNull DBSEntity table) {
        return SQLQueryCombinedContext.anyOfTwo(this.parent.findRealSource(table), this.otherParent.findRealSource(table));
    }

    @Override
    @Nullable
    public DBSEntity findRealTable(@NotNull DBRProgressMonitor monitor, @NotNull List<String> tableName) {
        return SQLQueryCombinedContext.anyOfTwo(this.parent.findRealTable(monitor, tableName), this.otherParent.findRealTable(monitor, tableName));
    }

    @Override
    @Nullable
    public SourceResolutionResult resolveSource(@NotNull DBRProgressMonitor monitor, @NotNull List<String> tableName) {
        return SQLQueryCombinedContext.anyOfTwo(this.parent.resolveSource(monitor, tableName), this.otherParent.resolveSource(monitor, tableName));
    }

    @Nullable
    private static <T> T anyOfTwo(@Nullable T a, @Nullable T b) {
        return a != null ? a : b;
    }

    @Override
    protected void collectKnownSourcesImpl(@NotNull SQLQueryDataContext.KnownSourcesInfo result) {
        this.parent.collectKnownSourcesImpl(result);
        this.otherParent.collectKnownSourcesImpl(result);
    }
}

