/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.completion;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItemKind;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.struct.DBSEntity;

public abstract class SQLQueryCompletionItem {
    private SQLQueryCompletionItem() {
    }

    @NotNull
    public abstract SQLQueryCompletionItemKind getKind();

    @NotNull
    public abstract String getText();

    @Nullable
    public String getExtraText() {
        return null;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Nullable
    public DBPNamedObject getObject() {
        return null;
    }

    @NotNull
    public static SQLQueryCompletionItem forReservedWord(@NotNull String text) {
        return new SQLReservedWordCompletionItem(text);
    }

    @NotNull
    public static SQLQueryCompletionItem forSubqueryAlias(@NotNull SQLQuerySymbol aliasSymbol) {
        return new SQLSubqueryAliasCompletionItem(aliasSymbol);
    }

    @NotNull
    public static SQLQueryCompletionItem forRealTable(@NotNull DBSEntity table, boolean isUsed) {
        return new SQLTableNameCompletionItem(table, isUsed);
    }

    @NotNull
    public static SQLQueryCompletionItem forSubsetColumn(@NotNull SQLQueryResultColumn columnInfo, @NotNull SourceResolutionResult sourceInfo, boolean absolute) {
        return new SQLColumnNameCompletionItem(columnInfo, sourceInfo, absolute);
    }

    @NotNull
    public static SQLQueryCompletionItem forDbObject(@NotNull DBPNamedObject object) {
        return new SQLDbNamedObjectCompletionItem(object);
    }

    private static class SQLColumnNameCompletionItem
    extends SQLQueryCompletionItem {
        @NotNull
        private final SQLQueryResultColumn columnInfo;
        @NotNull
        private final SourceResolutionResult sourceInfo;
        private final boolean absolute;

        public SQLColumnNameCompletionItem(@NotNull SQLQueryResultColumn columnInfo, @NotNull SourceResolutionResult sourceInfo, boolean absolute) {
            this.columnInfo = columnInfo;
            this.sourceInfo = sourceInfo;
            this.absolute = absolute;
        }

        @Override
        @NotNull
        public String getText() {
            if (this.absolute) {
                String prefix = this.sourceInfo != null && this.sourceInfo.aliasOrNull != null ? this.sourceInfo.aliasOrNull.getName() + "." : "";
                return prefix + this.columnInfo.symbol.getName();
            }
            return this.columnInfo.symbol.getName();
        }

        @Override
        @Nullable
        public String getExtraText() {
            SQLQueryExprType type = this.columnInfo.type;
            String typeName = type == null || type == SQLQueryExprType.UNKNOWN ? null : type.getDisplayName();
            return typeName == null ? null : " : " + typeName;
        }

        @Override
        public String getDescription() {
            String originalColumnName;
            String string = originalColumnName = this.columnInfo.realAttr == null ? null : DBUtils.getObjectFullName((DBPNamedObject)this.columnInfo.realAttr, (DBPEvaluationContext)DBPEvaluationContext.DML);
            if (this.columnInfo.symbol.getSymbolClass() == SQLQuerySymbolClass.COLUMN_DERIVED) {
                return "Derived column name " + (String)(originalColumnName != null ? "for real column " + originalColumnName : "");
            }
            if (this.columnInfo.realAttr != null) {
                return this.columnInfo.realAttr.getDescription();
            }
            if (this.columnInfo.realSource != null) {
                return "Column of the " + DBUtils.getObjectFullName((DBPNamedObject)this.columnInfo.realSource, (DBPEvaluationContext)DBPEvaluationContext.DML);
            }
            return "Subquery column";
        }

        @Override
        @NotNull
        public SQLQueryCompletionItemKind getKind() {
            return this.columnInfo.symbol.getSymbolClass() == SQLQuerySymbolClass.COLUMN_DERIVED ? SQLQueryCompletionItemKind.DERIVED_COLUMN_NAME : SQLQueryCompletionItemKind.TABLE_COLUMN_NAME;
        }

        @Override
        @Nullable
        public DBPNamedObject getObject() {
            return this.columnInfo.realAttr;
        }
    }

    private static class SQLDbNamedObjectCompletionItem
    extends SQLQueryCompletionItem {
        private final DBPNamedObject object;

        public SQLDbNamedObjectCompletionItem(DBPNamedObject object) {
            this.object = object;
        }

        @Override
        @NotNull
        public String getText() {
            return this.object.getName();
        }

        @Override
        @NotNull
        public String getExtraText() {
            return DBUtils.getObjectFullName((DBPNamedObject)this.object, (DBPEvaluationContext)DBPEvaluationContext.DML);
        }

        @Override
        @NotNull
        public String getDescription() {
            return this.getExtraText();
        }

        @Override
        @NotNull
        public SQLQueryCompletionItemKind getKind() {
            return SQLQueryCompletionItemKind.UNKNOWN;
        }

        @Override
        public DBPNamedObject getObject() {
            return this.object;
        }
    }

    private static class SQLReservedWordCompletionItem
    extends SQLQueryCompletionItem {
        private final String text;

        public SQLReservedWordCompletionItem(String text) {
            this.text = text;
        }

        @Override
        @NotNull
        public SQLQueryCompletionItemKind getKind() {
            return SQLQueryCompletionItemKind.RESERVED;
        }

        @Override
        @NotNull
        public String getText() {
            return this.text;
        }

        @Override
        @NotNull
        public String getDescription() {
            return "Reserved word of the query language";
        }
    }

    private static class SQLSubqueryAliasCompletionItem
    extends SQLQueryCompletionItem {
        @NotNull
        private final SQLQuerySymbol symbol;

        public SQLSubqueryAliasCompletionItem(@NotNull SQLQuerySymbol symbol) {
            this.symbol = symbol;
        }

        @Override
        @NotNull
        public SQLQueryCompletionItemKind getKind() {
            return SQLQueryCompletionItemKind.SUBQUERY_ALIAS;
        }

        @Override
        @NotNull
        public String getText() {
            return this.symbol.getName();
        }

        @Override
        @NotNull
        public String getExtraText() {
            return "Subquery alias";
        }

        @Override
        @NotNull
        public String getDescription() {
            return "TODO";
        }
    }

    private static class SQLTableNameCompletionItem
    extends SQLQueryCompletionItem {
        private final boolean isUsed;
        @NotNull
        private final DBSEntity table;

        public SQLTableNameCompletionItem(@NotNull DBSEntity table, boolean isUsed) {
            this.isUsed = isUsed;
            this.table = table;
        }

        @Override
        @NotNull
        public String getText() {
            return this.table.getName();
        }

        @Override
        @NotNull
        public String getExtraText() {
            return (DBUtils.isView((DBSEntity)this.table) ? "View " : "Table ") + DBUtils.getObjectFullName((DBPNamedObject)this.table, (DBPEvaluationContext)DBPEvaluationContext.DML);
        }

        @Override
        public String getDescription() {
            return this.table.getDescription();
        }

        @Override
        @NotNull
        public SQLQueryCompletionItemKind getKind() {
            return this.isUsed ? SQLQueryCompletionItemKind.USED_TABLE_NAME : SQLQueryCompletionItemKind.NEW_TABLE_NAME;
        }

        @Override
        public DBPNamedObject getObject() {
            return this.table;
        }
    }
}

