/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLSearchUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScopeItem;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolByDbObjectDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLScriptItemAtOffset;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItem;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionSet;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.LSMInspections;
import org.jkiss.dbeaver.model.stm.STMTreeTermNode;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;

public abstract class SQLQueryCompletionContext {
    private static final Log log = Log.getLog(SQLQueryCompletionContext.class);
    public static final SQLQueryCompletionContext EMPTY = new SQLQueryCompletionContext(0){

        @Override
        @NotNull
        public SQLQueryCompletionSet prepareProposal(@NotNull DBRProgressMonitor monitor, int position) {
            return new SQLQueryCompletionSet(position, 0, Collections.emptyList());
        }
    };
    private final int scriptItemOffset;

    @NotNull
    public static SQLQueryCompletionContext prepareOffquery(int scriptItemOffset) {
        return new SQLQueryCompletionContext(scriptItemOffset){
            private static final Collection<SQLQueryCompletionItem> keywords = LSMInspections.prepareOffquerySyntaxInspection().predictedWords.stream().sorted().map(SQLQueryCompletionItem::forReservedWord).collect(Collectors.toList());

            @Override
            @NotNull
            public SQLQueryCompletionSet prepareProposal(@NotNull DBRProgressMonitor monitor, int position) {
                return new SQLQueryCompletionSet(position, 0, keywords);
            }
        };
    }

    private SQLQueryCompletionContext(int scriptItemOffset) {
        this.scriptItemOffset = scriptItemOffset;
    }

    public int getOffset() {
        return this.scriptItemOffset;
    }

    @NotNull
    public abstract SQLQueryCompletionSet prepareProposal(@NotNull DBRProgressMonitor var1, int var2);

    public static SQLQueryCompletionContext prepare(@NotNull SQLScriptItemAtOffset scriptItem, final @Nullable DBCExecutionContext dbcExecutionContext, final @NotNull LSMInspections.SyntaxInspectionResult syntaxInspectionResult, final @NotNull SQLQueryDataContext context, final @Nullable SQLQueryLexicalScopeItem lexicalItem, final @NotNull STMTreeTermNode[] nameNodes) {
        return new SQLQueryCompletionContext(scriptItem.offset){
            final Map<SQLQueryRowsSourceModel, SourceResolutionResult> referencedSources;
            {
                super($anonymous0);
                this.referencedSources = sQLQueryDataContext.collectKnownSources().getResolutionResults();
            }

            @Override
            @NotNull
            public SQLQueryCompletionSet prepareProposal(@NotNull DBRProgressMonitor monitor, int position) {
                List tableRefCompletions;
                String currentWord = this.obtainCurrentWord(position -= this.getOffset());
                List keywordCompletions = nameNodes.length > 1 ? Collections.emptyList() : this.prepareKeywordCompletions(syntaxInspectionResult.predictedWords, currentWord);
                List<Object> columnRefCompletions = syntaxInspectionResult.expectingColumnReference ? this.prepareColumnCompletions() : Collections.emptyList();
                List<Object> list = tableRefCompletions = syntaxInspectionResult.expectingTableReference ? this.prepareTableCompletions(monitor) : Collections.emptyList();
                List<SQLQueryCompletionItem> lexicalItemCompletions = lexicalItem != null ? this.prepareLexicalItemCompletions(monitor, lexicalItem, position) : (syntaxInspectionResult.expectingIdentifier || nameNodes.length > 0 ? this.prepareIdentifierCompletions(monitor, position) : Collections.emptyList());
                List<SQLQueryCompletionItem> completionItems = Stream.of(keywordCompletions, columnRefCompletions, tableRefCompletions, lexicalItemCompletions).flatMap(Collection::stream).sorted(Comparator.comparing(SQLQueryCompletionItem::getText)).collect(Collectors.toList());
                int replacementLength = currentWord == null ? 0 : currentWord.length();
                return new SQLQueryCompletionSet(position - replacementLength, replacementLength, completionItems);
            }

            @Nullable
            private String obtainCurrentWord(int position) {
                if (nameNodes.length == 0) {
                    return null;
                }
                STMTreeTermNode lastNode = nameNodes[nameNodes.length - 1];
                Interval wordRange = lastNode.getRealInterval();
                if (wordRange.b >= position - 1 && lastNode.symbol.getType() != 166) {
                    return lastNode.getTextContent().substring(0, position - lastNode.getRealInterval().a);
                }
                return null;
            }

            @NotNull
            private List<SQLQueryCompletionItem> prepareIdentifierCompletions(@NotNull DBRProgressMonitor monitor, int position) {
                List<String> parts = this.obtainIdentifierParts(position);
                return this.prepareIdentifierCompletions(monitor, parts, null);
            }

            private List<SQLQueryCompletionItem> prepareIdentifierCompletions(@NotNull DBRProgressMonitor monitor, @NotNull List<String> parts, Class<?> componentType) {
                List<SQLQueryCompletionItem> subqueries;
                List<String> prefix = parts.subList(0, parts.size() - 1);
                String tail = parts.get(parts.size() - 1);
                if (prefix.size() == 1) {
                    String mayBeAliasName = prefix.get(0).toLowerCase();
                    SourceResolutionResult srr = this.referencedSources.values().stream().filter(rr -> rr.aliasOrNull != null && rr.aliasOrNull.getName().toLowerCase().equals(mayBeAliasName)).findFirst().orElse(null);
                    if (srr != null) {
                        return srr.source.getResultDataContext().getColumnsList().stream().filter(c -> c.symbol.getName().toLowerCase().contains(tail)).map(c -> SQLQueryCompletionItem.forSubsetColumn(c, srr, false)).toList();
                    }
                } else if (prefix.size() == 0 && !(subqueries = this.referencedSources.values().stream().filter(rr -> rr.aliasOrNull != null && rr.aliasOrNull.getName().toLowerCase().contains(tail)).map(rr -> SQLQueryCompletionItem.forSubqueryAlias(rr.aliasOrNull)).toList()).isEmpty()) {
                    return subqueries;
                }
                if (dbcExecutionContext == null || dbcExecutionContext.getDataSource() == null) {
                    return Collections.emptyList();
                }
                DBPDataSource prefixContext = prefix.size() == 0 ? dbcExecutionContext.getDataSource() : SQLSearchUtils.findObjectByFQN(monitor, (DBSObjectContainer)dbcExecutionContext.getDataSource(), dbcExecutionContext, prefix, false, new SQLIdentifierDetector(dbcExecutionContext.getDataSource().getSQLDialect()));
                return prefixContext == null ? Collections.emptyList() : this.prepareObjectComponentCompletions(monitor, (DBSObject)prefixContext, tail, componentType);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            private List<SQLQueryCompletionItem> prepareObjectComponentCompletions(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object, @NotNull String componentNamePart, Class<?> componentType) {
                try {
                    Stream<DBPNamedObject> components;
                    DBSObject dBSObject = object;
                    if (dBSObject instanceof DBSEntity) {
                        void entity;
                        DBSEntity dBSEntity = (DBSEntity)dBSObject;
                        DBSEntity cfr_ignored_0 = (DBSEntity)dBSObject;
                        List attrs = entity.getAttributes(monitor);
                        components = attrs == null ? Stream.empty() : attrs.stream();
                    } else {
                        DBSObject dBSObject2 = object;
                        if (dBSObject2 instanceof DBSObjectContainer) {
                            void container;
                            DBSObjectContainer attrs = (DBSObjectContainer)dBSObject2;
                            DBSObjectContainer cfr_ignored_1 = (DBSObjectContainer)dBSObject2;
                            components = container.getChildren(monitor).stream().filter(c -> c instanceof DBPNamedObject).map(c -> c);
                        } else {
                            components = Stream.empty();
                        }
                    }
                    return components.filter(a -> (componentType == null || componentType.isInstance(a)) && a.getName().toLowerCase().contains(componentNamePart)).map(SQLQueryCompletionItem::forDbObject).toList();
                }
                catch (DBException dBException) {
                    return Collections.emptyList();
                }
            }

            private List<String> obtainIdentifierParts(int position) {
                ArrayList<String> parts = new ArrayList<String>(nameNodes.length);
                int i = 0;
                while (i < nameNodes.length) {
                    STMTreeTermNode term = nameNodes[i];
                    if (term.symbol.getType() != 166) {
                        if (term.getRealInterval().b + 1 >= position) break;
                        parts.add(term.getTextContent());
                    }
                    ++i;
                }
                STMTreeTermNode currentNode = i >= nameNodes.length ? null : nameNodes[i];
                String currentPart = currentNode == null ? "" : currentNode.getTextContent().substring(0, position - currentNode.getRealInterval().a);
                parts.add(currentPart);
                return parts;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            private SQLQuerySymbolDefinition unrollSymbolDefinition(SQLQuerySymbolDefinition def) {
                SQLQuerySymbolDefinition sQLQuerySymbolDefinition;
                while ((sQLQuerySymbolDefinition = def) instanceof SQLQuerySymbolEntry) {
                    void entry;
                    SQLQuerySymbolEntry cfr_ignored_0 = (SQLQuerySymbolEntry)sQLQuerySymbolDefinition;
                    SQLQuerySymbolEntry cfr_ignored_1 = (SQLQuerySymbolEntry)sQLQuerySymbolDefinition;
                    def = entry.getDefinition();
                }
                return def;
            }

            /*
             * WARNING - void declaration
             */
            private List<SQLQueryCompletionItem> prepareLexicalItemCompletions(@NotNull DBRProgressMonitor monitor, @NotNull SQLQueryLexicalScopeItem lexicalItem2, int position) {
                Interval pos = Interval.of((int)position, (int)position);
                SQLQueryLexicalScopeItem sQLQueryLexicalScopeItem = lexicalItem2;
                if (sQLQueryLexicalScopeItem instanceof SQLQueryQualifiedName) {
                    Interval catalogRange;
                    Interval schemaRange;
                    void qname;
                    SQLQueryQualifiedName sQLQueryQualifiedName = (SQLQueryQualifiedName)sQLQueryLexicalScopeItem;
                    SQLQueryQualifiedName cfr_ignored_0 = (SQLQueryQualifiedName)sQLQueryLexicalScopeItem;
                    Interval nameRange = qname.entityName.getSyntaxNode().getRealInterval();
                    if (nameRange.properlyContains(pos)) {
                        String part = qname.entityName.getRawName().substring(0, position - nameRange.a);
                        if (qname.schemaName != null) {
                            SQLQuerySymbolDefinition scopeDef = this.unrollSymbolDefinition(qname.schemaName.getDefinition());
                            SQLQuerySymbolDefinition sQLQuerySymbolDefinition = scopeDef;
                            if (sQLQuerySymbolDefinition instanceof SQLQuerySymbolByDbObjectDefinition) {
                                void byObjDef;
                                SQLQuerySymbolByDbObjectDefinition sQLQuerySymbolByDbObjectDefinition = (SQLQuerySymbolByDbObjectDefinition)sQLQuerySymbolDefinition;
                                SQLQuerySymbolByDbObjectDefinition cfr_ignored_1 = (SQLQuerySymbolByDbObjectDefinition)sQLQuerySymbolDefinition;
                                return this.prepareObjectComponentCompletions(monitor, byObjDef.getDbObject(), part, DBSEntity.class);
                            }
                            return Collections.emptyList();
                        }
                        return this.prepareIdentifierCompletions(monitor, List.of(part), DBSEntity.class);
                    }
                    if (qname.schemaName != null && (schemaRange = qname.schemaName.getSyntaxNode().getRealInterval()).properlyContains(pos)) {
                        String part = qname.schemaName.getRawName().substring(0, position - schemaRange.a);
                        if (qname.catalogName != null) {
                            SQLQuerySymbolDefinition scopeDef = this.unrollSymbolDefinition(qname.schemaName.getDefinition());
                            SQLQuerySymbolDefinition sQLQuerySymbolDefinition = scopeDef;
                            if (sQLQuerySymbolDefinition instanceof SQLQuerySymbolByDbObjectDefinition) {
                                SQLQuerySymbolByDbObjectDefinition byObjDef = (SQLQuerySymbolByDbObjectDefinition)sQLQuerySymbolDefinition;
                                SQLQuerySymbolByDbObjectDefinition cfr_ignored_2 = (SQLQuerySymbolByDbObjectDefinition)sQLQuerySymbolDefinition;
                                return this.prepareObjectComponentCompletions(monitor, byObjDef.getDbObject(), part, DBSSchema.class);
                            }
                            return Collections.emptyList();
                        }
                        return this.prepareObjectComponentCompletions(monitor, (DBSObject)dbcExecutionContext.getDataSource(), part, DBSSchema.class);
                    }
                    if (qname.catalogName != null && (catalogRange = qname.catalogName.getSyntaxNode().getRealInterval()).properlyContains(pos)) {
                        String part = qname.catalogName.getRawName().substring(0, position - catalogRange.a);
                        return this.prepareObjectComponentCompletions(monitor, (DBSObject)dbcExecutionContext.getDataSource(), part, DBSCatalog.class);
                    }
                    throw new UnsupportedOperationException("Illegal SQLQueryQualifiedName");
                }
                SQLQueryLexicalScopeItem sQLQueryLexicalScopeItem2 = lexicalItem2;
                if (sQLQueryLexicalScopeItem2 instanceof SQLQuerySymbolEntry) {
                    void entry;
                    SQLQuerySymbolEntry nameRange = (SQLQuerySymbolEntry)sQLQueryLexicalScopeItem2;
                    SQLQuerySymbolEntry cfr_ignored_3 = (SQLQuerySymbolEntry)sQLQueryLexicalScopeItem2;
                    Interval nameRange2 = entry.getSyntaxNode().getRealInterval();
                    String part = entry.getRawName().substring(0, position - nameRange2.a);
                    return this.prepareIdentifierCompletions(monitor, List.of(part), null);
                }
                throw new UnsupportedOperationException("Unexpected lexical item kind to complete " + lexicalItem2.getClass().getName());
            }

            private List<SQLQueryCompletionItem> prepareKeywordCompletions(Set<String> keywords, String filter) {
                Stream<Object> stream = keywords.stream();
                if (filter != null) {
                    stream = stream.filter(s -> s.toLowerCase().contains(filter));
                }
                return stream.map(SQLQueryCompletionItem::forReservedWord).toList();
            }

            @NotNull
            private List<SQLQueryCompletionItem> prepareColumnCompletions() {
                List<SQLQueryCompletionItem> subsetColumns = context.getColumnsList().stream().map(rc -> SQLQueryCompletionItem.forSubsetColumn(rc, this.referencedSources.get(rc.source), true)).toList();
                LinkedList<SQLQueryCompletionItem> tableRefs = new LinkedList<SQLQueryCompletionItem>();
                for (SourceResolutionResult rr : this.referencedSources.values()) {
                    if (rr.aliasOrNull != null && !rr.isCteSubquery) {
                        tableRefs.add(SQLQueryCompletionItem.forSubqueryAlias(rr.aliasOrNull));
                        continue;
                    }
                    if (rr.tableOrNull == null) continue;
                    tableRefs.add(SQLQueryCompletionItem.forRealTable(rr.tableOrNull, true));
                }
                return Stream.of(subsetColumns, tableRefs).flatMap(Collection::stream).toList();
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            private List<SQLQueryCompletionItem> prepareTableCompletions(@NotNull DBRProgressMonitor monitor) {
                HashSet<DBSEntity> alreadyReferencedTables = new HashSet<DBSEntity>();
                LinkedList<SQLQueryCompletionItem> tableRefs = new LinkedList<SQLQueryCompletionItem>();
                for (SourceResolutionResult rr : this.referencedSources.values()) {
                    if (rr.aliasOrNull != null && rr.isCteSubquery) {
                        tableRefs.add(SQLQueryCompletionItem.forSubqueryAlias(rr.aliasOrNull));
                    }
                    if (rr.tableOrNull == null) continue;
                    alreadyReferencedTables.add(rr.tableOrNull);
                }
                if (dbcExecutionContext != null && dbcExecutionContext.getDataSource() != null) {
                    try {
                        DBSInstance dBSInstance = dbcExecutionContext.getDataSource().getDefaultInstance();
                        if (dBSInstance instanceof DBSObjectContainer) {
                            void container;
                            SourceResolutionResult rr;
                            rr = (DBSObjectContainer)dBSInstance;
                            DBSObjectContainer cfr_ignored_0 = (DBSObjectContainer)dBSInstance;
                            this.collectTables(monitor, (DBSObjectContainer)container, alreadyReferencedTables, tableRefs);
                        } else {
                            DBPDataSource dBPDataSource = dbcExecutionContext.getDataSource();
                            if (dBPDataSource instanceof DBSObjectContainer) {
                                void container2;
                                DBSObjectContainer dBSObjectContainer = (DBSObjectContainer)dBPDataSource;
                                DBSObjectContainer cfr_ignored_1 = (DBSObjectContainer)dBPDataSource;
                                this.collectTables(monitor, (DBSObjectContainer)container2, alreadyReferencedTables, tableRefs);
                            }
                        }
                    }
                    catch (DBException e) {
                        log.error((Object)e);
                    }
                }
                return tableRefs;
            }

            /*
             * WARNING - void declaration
             */
            private void collectTables(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectContainer container, @NotNull Set<DBSEntity> alreadyReferencedTables, @NotNull LinkedList<SQLQueryCompletionItem> tableRefs) throws DBException {
                Collection children = container.getChildren(monitor);
                for (DBSObject child : children) {
                    void sc;
                    DBSObject dBSObject;
                    DBSObject dBSObject2;
                    if (DBUtils.isHiddenObject((Object)child)) continue;
                    DBSObject dBSObject3 = child;
                    if (dBSObject3 instanceof DBSTable) {
                        void tab;
                        DBSTable cfr_ignored_0 = (DBSTable)dBSObject3;
                        DBSTable cfr_ignored_1 = (DBSTable)dBSObject3;
                        if (!alreadyReferencedTables.contains(tab)) {
                            tableRefs.add(SQLQueryCompletionItem.forRealTable((DBSEntity)tab, false));
                            continue;
                        }
                    }
                    if ((dBSObject2 = child) instanceof DBSView) {
                        void view;
                        DBSView cfr_ignored_2 = (DBSView)dBSObject2;
                        DBSView cfr_ignored_3 = (DBSView)dBSObject2;
                        if (!alreadyReferencedTables.contains(view)) {
                            tableRefs.add(SQLQueryCompletionItem.forRealTable((DBSEntity)view, false));
                            continue;
                        }
                    }
                    if (!((dBSObject = child) instanceof DBSObjectContainer)) continue;
                    DBSObjectContainer cfr_ignored_4 = (DBSObjectContainer)dBSObject;
                    DBSObjectContainer cfr_ignored_5 = (DBSObjectContainer)dBSObject;
                    this.collectTables(monitor, (DBSObjectContainer)sc, alreadyReferencedTables, tableRefs);
                }
            }
        };
    }
}

