/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;

public class SQLQuerySymbol {
    private final String name;
    private final Set<SQLQuerySymbolEntry> entries = new HashSet<SQLQuerySymbolEntry>();
    private SQLQuerySymbolClass symbolClass = SQLQuerySymbolClass.UNKNOWN;
    private SQLQuerySymbolDefinition definition = null;

    public SQLQuerySymbol(@NotNull String name) {
        this.name = name;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public SQLQuerySymbolClass getSymbolClass() {
        return this.symbolClass;
    }

    public void setSymbolClass(@NotNull SQLQuerySymbolClass symbolClass) {
        if (this.symbolClass != SQLQuerySymbolClass.UNKNOWN) {
            throw new IllegalStateException("Symbol already classified");
        }
        this.symbolClass = symbolClass;
    }

    @NotNull
    public Collection<SQLQuerySymbolEntry> getEntries() {
        return this.entries;
    }

    @Nullable
    public SQLQuerySymbolDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(@Nullable SQLQuerySymbolDefinition definition) {
        if (this.definition != null) {
            throw new IllegalStateException("Symbol definition has already been set");
        }
        if (definition != null) {
            this.definition = definition;
            this.setSymbolClass(definition.getSymbolClass());
        }
    }

    public void registerEntry(@NotNull SQLQuerySymbolEntry entry) {
        if (!entry.getName().equals(this.name)) {
            throw new IllegalStateException("Cannot treat symbols '" + entry.getName() + "' as an instance of '" + this.name + "'");
        }
        this.entries.add(entry);
    }

    @NotNull
    public SQLQuerySymbol merge(@NotNull SQLQuerySymbol other) {
        if (!other.name.equals(this.name)) {
            throw new UnsupportedOperationException("Cannot treat different symbols as one ('" + this.name + "' and '" + other.name + "')");
        }
        SQLQuerySymbol result = new SQLQuerySymbol(this.name);
        result.entries.addAll(this.entries);
        result.entries.addAll(other.entries);
        result.entries.forEach(e -> SQLQuerySymbolEntry.updateSymbol(e, result));
        return this;
    }

    public String toString() {
        return super.toString() + "[" + this.name + "]";
    }
}

