/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.lsm.LSMAnalyzer;
import org.jkiss.dbeaver.model.lsm.sql.dialect.LSMDialectRegistry;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.semantics.DirectedGraph;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScope;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScopeItem;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDummyDataSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModelContent;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsCorrelatedSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsCrossJoinModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsCteModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsNaturalJoinModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsProjectionModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsSetCorrespondingOperationKind;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsSetCorrespondingOperationModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryRowsTableValueModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQuerySelectionResultModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryTableDeleteModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryTableInsertModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryTableUpdateModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryTableUpdateSetClauseModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryValueColumnReferenceExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryValueConstantExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryValueFlattenedExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryValueIndexingExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryValueMemberExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryValueSubqueryExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryValueTupleReferenceExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryValueTypeCastExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryValueVariableExpression;
import org.jkiss.dbeaver.model.stm.STMErrorListener;
import org.jkiss.dbeaver.model.stm.STMKnownRuleNames;
import org.jkiss.dbeaver.model.stm.STMSkippingErrorListener;
import org.jkiss.dbeaver.model.stm.STMSource;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.stm.STMTreeRuleNode;
import org.jkiss.dbeaver.model.stm.STMUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.Pair;

public class SQLQueryModelRecognizer {
    private final HashSet<SQLQuerySymbolEntry> symbolEntries = new HashSet();
    private final boolean isReadMetadataForSemanticAnalysis;
    private final DBCExecutionContext executionContext;
    private final Set<String> reservedWords;
    private final LinkedList<SQLQueryLexicalScope> currentLexicalScopes = new LinkedList();
    private SQLQueryDataContext queryDataContext;
    @NotNull
    private static final Set<String> columnNameListWrapperNames = Set.of(STMKnownRuleNames.correspondingSpec, STMKnownRuleNames.referencedTableAndColumns, STMKnownRuleNames.correlationSpecification, STMKnownRuleNames.nonjoinedTableReference, STMKnownRuleNames.namedColumnsJoin, STMKnownRuleNames.joinSpecification, STMKnownRuleNames.naturalJoinTerm, STMKnownRuleNames.unionTerm, STMKnownRuleNames.exceptTerm, STMKnownRuleNames.intersectTerm, STMKnownRuleNames.uniqueConstraintDefinition, STMKnownRuleNames.viewDefinition, STMKnownRuleNames.insertColumnsAndSource, STMKnownRuleNames.referenceColumnList, STMKnownRuleNames.referencingColumns, STMKnownRuleNames.derivedColumnList, STMKnownRuleNames.joinColumnList, STMKnownRuleNames.correspondingColumnList, STMKnownRuleNames.uniqueColumnList, STMKnownRuleNames.viewColumnList, STMKnownRuleNames.insertColumnList);
    private static final Set<String> identifierDirectWrapperNames = Set.of(STMKnownRuleNames.unqualifiedSchemaName, STMKnownRuleNames.catalogName, STMKnownRuleNames.correlationName, STMKnownRuleNames.authorizationIdentifier, STMKnownRuleNames.columnName, STMKnownRuleNames.queryName);
    private static final Set<String> tableNameContainers = Set.of(STMKnownRuleNames.referencedTableAndColumns, STMKnownRuleNames.qualifier, STMKnownRuleNames.nonjoinedTableReference, STMKnownRuleNames.explicitTable, STMKnownRuleNames.tableDefinition, STMKnownRuleNames.viewDefinition, STMKnownRuleNames.alterTableStatement, STMKnownRuleNames.dropTableStatement, STMKnownRuleNames.dropViewStatement, STMKnownRuleNames.deleteStatement, STMKnownRuleNames.insertStatement, STMKnownRuleNames.updateStatement, STMKnownRuleNames.correlationSpecification);
    private static final Set<String> actualTableNameContainers = Set.of(STMKnownRuleNames.tableName, STMKnownRuleNames.correlationName);
    private static final Set<String> qualifiedNameDirectWrapperNames = Set.of(STMKnownRuleNames.tableName, STMKnownRuleNames.constraintName);
    private static final Set<String> knownValueExpressionRootNames = Set.of(STMKnownRuleNames.valueExpression, STMKnownRuleNames.valueExpressionAtom, STMKnownRuleNames.searchCondition, STMKnownRuleNames.havingClause, STMKnownRuleNames.whereClause, STMKnownRuleNames.groupByClause, STMKnownRuleNames.orderByClause, STMKnownRuleNames.rowValueConstructor);
    private static final Set<String> knownRecognizableValueExpressionNames = Set.of(STMKnownRuleNames.subquery, STMKnownRuleNames.columnReference, STMKnownRuleNames.valueReference, STMKnownRuleNames.valueExpressionCast, STMKnownRuleNames.variableExpression, STMKnownRuleNames.truthValue, STMKnownRuleNames.unsignedNumericLiteral, STMKnownRuleNames.signedNumericLiteral, STMKnownRuleNames.characterStringLiteral, STMKnownRuleNames.datetimeLiteral);

    public SQLQueryModelRecognizer(@Nullable DBCExecutionContext executionContext, boolean isReadMetadataForSemanticAnalysis) {
        this.isReadMetadataForSemanticAnalysis = isReadMetadataForSemanticAnalysis;
        this.executionContext = executionContext;
        this.reservedWords = new HashSet<String>(this.obtainSqlDialect().getReservedWords());
    }

    @Nullable
    public SQLQueryModel recognizeQuery(@NotNull String text, @NotNull DBRProgressMonitor monitor) {
        STMSource querySource = STMSource.fromString((String)text);
        LSMAnalyzer analyzer = LSMDialectRegistry.getInstance().getAnalyzerForDialect(this.obtainSqlDialect());
        STMTreeRuleNode tree = analyzer.parseSqlQueryTree(querySource, (STMErrorListener)new STMSkippingErrorListener());
        if (tree != null) {
            this.queryDataContext = this.prepareDataContext((STMTreeNode)tree);
            STMTreeNode dataStmt = tree.findChildOfName(STMKnownRuleNames.directSqlDataStatement);
            if (dataStmt != null) {
                SQLQueryModelContent contents;
                STMTreeNode stmtBodyNode = dataStmt.getStmChild(dataStmt.getChildCount() - 1);
                switch (stmtBodyNode.getNodeKindId()) {
                    case 232: {
                        SQLQueryModelContent sQLQueryModelContent = this.collectDeleteStatement(stmtBodyNode);
                        break;
                    }
                    case 233: {
                        SQLQueryModelContent sQLQueryModelContent = this.collectInsertStatement(stmtBodyNode);
                        break;
                    }
                    case 236: {
                        SQLQueryModelContent sQLQueryModelContent = this.collectUpdateStatement(stmtBodyNode);
                        break;
                    }
                    case 3: {
                        SQLQueryModelContent sQLQueryModelContent = this.collectQueryExpression((STMTreeNode)tree);
                        break;
                    }
                    default: {
                        SQLQueryModelContent sQLQueryModelContent = contents = this.collectQueryExpression((STMTreeNode)tree);
                    }
                }
                if (contents != null) {
                    SQLQueryModel model = new SQLQueryModel((STMTreeNode)tree, contents, this.symbolEntries);
                    model.propagateContext(this.queryDataContext, new RecognitionContext(monitor));
                    return model;
                }
            }
            SQLDialect dialect = this.obtainSqlDialect();
            Predicate<SQLQuerySymbolEntry> tryFallbackForStringLiteral = s -> {
                boolean forced;
                String rawString = s.getRawName();
                SQLQuerySymbolClass forcedClass = dialect.isQuotedString(rawString) ? SQLQuerySymbolClass.STRING : SQLQueryModelRecognizer.tryFallbackSymbolForStringLiteral(dialect, s, false);
                boolean bl = forced = forcedClass != null;
                if (forced) {
                    s.getSymbol().setSymbolClass(forcedClass);
                }
                return forced;
            };
            this.traverseForIdentifiers((STMTreeNode)tree, (e, c) -> {
                if (c.isNotClassified() && (e != null || !tryFallbackForStringLiteral.test((SQLQuerySymbolEntry)c))) {
                    c.getSymbol().setSymbolClass(SQLQuerySymbolClass.COLUMN);
                }
            }, e -> {
                if (e.isNotClassified() && (e.catalogName != null || e.schemaName != null || !tryFallbackForStringLiteral.test(e.entityName))) {
                    e.entityName.getSymbol().setSymbolClass(SQLQuerySymbolClass.TABLE);
                    if (e.schemaName != null) {
                        e.schemaName.getSymbol().setSymbolClass(SQLQuerySymbolClass.SCHEMA);
                        if (e.catalogName != null) {
                            e.catalogName.getSymbol().setSymbolClass(SQLQuerySymbolClass.CATALOG);
                        }
                    }
                }
            }, false);
            return new SQLQueryModel((STMTreeNode)tree, null, this.symbolEntries);
        }
        return null;
    }

    private void traverseForIdentifiers(@NotNull STMTreeNode root, @NotNull BiConsumer<SQLQueryQualifiedName, SQLQuerySymbolEntry> columnAction, @NotNull Consumer<SQLQueryQualifiedName> entityAction, boolean forceUnquotted) {
        List refs = STMUtils.expandSubtree((STMTreeNode)root, null, Set.of(STMKnownRuleNames.columnReference, STMKnownRuleNames.columnName, STMKnownRuleNames.tableName));
        block4: for (STMTreeNode ref : refs) {
            switch (ref.getNodeKindId()) {
                case 34: 
                case 85: {
                    STMTreeNode columnName;
                    SQLQueryQualifiedName tableName;
                    if (ref.getChildCount() > 1) {
                        tableName = this.collectTableName(ref.getStmChild(0), forceUnquotted);
                        if (tableName != null) {
                            entityAction.accept(tableName);
                        }
                    } else {
                        tableName = null;
                    }
                    STMTreeNode sTMTreeNode = columnName = ref.getNodeKindId() == 34 ? ref : ref.findChildOfName(STMKnownRuleNames.columnName);
                    if (columnName == null) continue block4;
                    columnAction.accept(tableName, this.collectIdentifier(columnName, forceUnquotted));
                    break;
                }
                case 43: {
                    SQLQueryQualifiedName tableName = this.collectTableName(ref, forceUnquotted);
                    if (tableName == null) continue block4;
                    entityAction.accept(tableName);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + ref.getNodeName());
                }
            }
        }
    }

    @NotNull
    private SQLQueryDataContext prepareDataContext(@NotNull STMTreeNode root) {
        if (this.isReadMetadataForSemanticAnalysis && this.executionContext != null && this.executionContext.getDataSource() instanceof DBSObjectContainer && this.executionContext.getDataSource().getSQLDialect() instanceof BasicSQLDialect) {
            return new SQLQueryDataSourceContext(this.executionContext, this.executionContext.getDataSource().getSQLDialect());
        }
        HashSet<String> allColumnNames = new HashSet<String>();
        HashSet<List<String>> allTableNames = new HashSet<List<String>>();
        this.traverseForIdentifiers(root, (e, c) -> {
            boolean bl = allColumnNames.add(c.getName());
        }, e -> {
            boolean bl = allTableNames.add(e.toListOfStrings());
        }, true);
        this.symbolEntries.clear();
        return new SQLQueryDummyDataSourceContext(this.obtainSqlDialect(), allColumnNames, allTableNames);
    }

    @NotNull
    private SQLDialect obtainSqlDialect() {
        if (this.executionContext != null && this.executionContext.getDataSource() != null) {
            return this.executionContext.getDataSource().getSQLDialect();
        }
        return BasicSQLDialect.INSTANCE;
    }

    @NotNull
    private SQLQueryModelContent collectUpdateStatement(@NotNull STMTreeNode node) {
        STMTreeNode fromClauseNode;
        STMTreeNode targetTableNode = node.findChildOfName(STMKnownRuleNames.tableReference);
        SQLQueryRowsSourceModel targetSet = targetTableNode == null ? null : this.collectQueryExpression(targetTableNode);
        ArrayList<SQLQueryTableUpdateSetClauseModel> setClauseList = new ArrayList<SQLQueryTableUpdateSetClauseModel>();
        STMTreeNode setClauseListNode = node.findChildOfName(STMKnownRuleNames.setClauseList);
        if (setClauseListNode != null) {
            int i = 0;
            while (i < setClauseListNode.getChildCount()) {
                STMTreeNode setClauseNode = setClauseListNode.getStmChild(i);
                if (setClauseNode.getChildCount() > 0) {
                    STMTreeNode setTargetNode = setClauseNode.getStmChild(0);
                    List<SQLQueryValueExpression> targets = switch (setTargetNode.getNodeKindId()) {
                        case 239 -> List.of(this.collectKnownValueExpression(setTargetNode.getStmChild(0)));
                        case 240 -> STMUtils.expandSubtree((STMTreeNode)setTargetNode, Set.of(STMKnownRuleNames.setTargetList), Set.of(STMKnownRuleNames.valueReference)).stream().map(this::collectValueExpression).collect(Collectors.toList());
                        case 269 -> Collections.emptyList();
                        default -> throw new UnsupportedOperationException("Set target list expected while facing with " + setTargetNode.getNodeName());
                    };
                    List<SQLQueryValueExpression> sources = setClauseNode.getChildCount() < 3 ? Collections.emptyList() : STMUtils.expandSubtree((STMTreeNode)setClauseNode.getStmChild(2), Set.of(STMKnownRuleNames.updateSource), Set.of(STMKnownRuleNames.updateValue)).stream().map(v -> this.collectValueExpression(v.getStmChild(0))).collect(Collectors.toList());
                    setClauseList.add(new SQLQueryTableUpdateSetClauseModel(setClauseNode, targets, sources, setClauseNode.getTextContent()));
                }
                i += 2;
            }
        }
        SQLQueryRowsSourceModel sourceSet = (fromClauseNode = node.findChildOfName(STMKnownRuleNames.fromClause)) == null ? null : this.collectQueryExpression(fromClauseNode);
        STMTreeNode whereClauseNode = node.findChildOfName(STMKnownRuleNames.whereClause);
        SQLQueryValueExpression whereClauseExpr = whereClauseNode == null ? null : this.collectValueExpression(whereClauseNode);
        STMTreeNode orderByClauseNode = node.findChildOfName(STMKnownRuleNames.orderByClause);
        SQLQueryValueExpression orderByExpr = orderByClauseNode == null ? null : this.collectValueExpression(orderByClauseNode);
        return new SQLQueryTableUpdateModel(node, targetSet, setClauseList, sourceSet, whereClauseExpr, orderByExpr);
    }

    @NotNull
    private SQLQueryModelContent collectInsertStatement(@NotNull STMTreeNode node) {
        SQLQueryRowsSourceModel valuesRows;
        List<SQLQuerySymbolEntry> columnNames;
        STMTreeNode tableNameNode = node.findChildOfName(STMKnownRuleNames.tableName);
        SQLQueryRowsTableDataModel tableModel = tableNameNode == null ? null : this.collectTableReference(tableNameNode);
        STMTreeNode insertColumnsAndSource = node.findChildOfName(STMKnownRuleNames.insertColumnsAndSource);
        if (insertColumnsAndSource != null) {
            STMTreeNode insertColumnList = insertColumnsAndSource.findChildOfName(STMKnownRuleNames.insertColumnList);
            columnNames = insertColumnList == null ? null : this.collectColumnNameList(insertColumnList);
            STMTreeNode valuesNode = insertColumnsAndSource.findChildOfName(STMKnownRuleNames.queryExpression);
            valuesRows = valuesNode == null ? null : this.collectQueryExpression(valuesNode);
        } else {
            columnNames = Collections.emptyList();
            valuesRows = null;
        }
        return new SQLQueryTableInsertModel(node, tableModel, columnNames, valuesRows);
    }

    @NotNull
    private SQLQueryModelContent collectDeleteStatement(@NotNull STMTreeNode node) {
        STMTreeNode tableNameNode = node.findChildOfName(STMKnownRuleNames.tableName);
        SQLQueryRowsTableDataModel tableModel = tableNameNode == null ? null : this.collectTableReference(tableNameNode);
        STMTreeNode aliasNode = node.findChildOfName(STMKnownRuleNames.correlationName);
        SQLQuerySymbolEntry alias = aliasNode == null ? null : this.collectIdentifier(aliasNode);
        STMTreeNode whereClauseNode = node.findChildOfName(STMKnownRuleNames.whereClause);
        SQLQueryValueExpression whereClauseExpr = whereClauseNode == null ? null : this.collectValueExpression(whereClauseNode);
        return new SQLQueryTableDeleteModel(node, tableModel, alias, whereClauseExpr);
    }

    @NotNull
    private SQLQueryRowsSourceModel collectQueryExpression(@NotNull STMTreeNode tree) {
        QueryExpressionMapper queryMapper = new QueryExpressionMapper(this);
        return (SQLQueryRowsSourceModel)queryMapper.translate(tree);
    }

    @NotNull
    private List<SQLQuerySymbolEntry> collectColumnNameList(@NotNull STMTreeNode node) {
        if (!node.getNodeName().equals(STMKnownRuleNames.columnNameList)) {
            if (!columnNameListWrapperNames.contains(node.getNodeName())) {
                throw new UnsupportedOperationException("columnNameList (or its wrapper) expected while facing with " + node.getNodeName());
            }
            List actual = STMUtils.expandSubtree((STMTreeNode)node, columnNameListWrapperNames, Set.of(STMKnownRuleNames.columnNameList));
            switch (actual.size()) {
                case 0: {
                    return Collections.emptyList();
                }
                case 1: {
                    node = (STMTreeNode)actual.get(0);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Ambiguous columnNameList collection at " + node.getNodeName());
                }
            }
        }
        ArrayList<SQLQuerySymbolEntry> result = new ArrayList<SQLQuerySymbolEntry>(node.getChildCount());
        int i = 0;
        while (i < node.getChildCount()) {
            result.add(this.collectIdentifier(node.getStmChild(i)));
            i += 2;
        }
        return result;
    }

    @NotNull
    private SQLQuerySymbolEntry collectIdentifier(@NotNull STMTreeNode node) {
        return this.collectIdentifier(node, false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private SQLQuerySymbolEntry collectIdentifier(@NotNull STMTreeNode node, boolean forceUnquotted) {
        STMTreeNode actual;
        STMTreeNode sTMTreeNode = actual = identifierDirectWrapperNames.contains(node.getNodeName()) ? node.getStmChild(0) : node;
        if (!actual.getNodeName().equals(STMKnownRuleNames.identifier)) {
            throw new UnsupportedOperationException("identifier expected while facing with " + node.getNodeName());
        }
        STMTreeNode actualIdentifier = actual.findChildOfName(STMKnownRuleNames.actualIdentifier);
        if (actualIdentifier == null) {
            SQLQuerySymbolEntry entry = this.registerSymbolEntry(actual, actual.getTextContent(), actual.getTextContent());
            entry.getSymbol().setSymbolClass(SQLQuerySymbolClass.ERROR);
            return entry;
        }
        STMTreeNode actualBody = actualIdentifier.getStmChild(0);
        String rawIdentifierString = actualBody.getTextContent();
        Object object = actualBody.getPayload();
        if (object instanceof Token) {
            void t;
            Token token = (Token)object;
            Token cfr_ignored_0 = (Token)object;
            if (t.getType() == 198) {
                SQLQuerySymbolEntry entry = this.registerSymbolEntry(actualBody, rawIdentifierString, rawIdentifierString);
                return entry;
            }
        }
        if (this.reservedWords.contains(rawIdentifierString.toUpperCase())) {
            SQLQuerySymbolEntry entry = this.registerSymbolEntry(actualBody, rawIdentifierString, rawIdentifierString);
            entry.getSymbol().setSymbolClass(SQLQuerySymbolClass.RESERVED);
            return entry;
        }
        SQLDialect dialect = this.obtainSqlDialect();
        String actualIdentifierString = SQLUtils.identifierToCanonicalForm((SQLDialect)dialect, (String)rawIdentifierString, (boolean)forceUnquotted, (boolean)false);
        return this.registerSymbolEntry(actualBody, actualIdentifierString, rawIdentifierString);
    }

    @NotNull
    private SQLQuerySymbolEntry registerSymbolEntry(@NotNull STMTreeNode syntaxNode, @NotNull String name, @NotNull String rawName) {
        SQLQuerySymbolEntry entry = new SQLQuerySymbolEntry(syntaxNode, name, rawName);
        this.symbolEntries.add(entry);
        this.registerScopeItem(entry);
        return entry;
    }

    @NotNull
    private SQLQueryRowsTableDataModel collectTableReference(@NotNull STMTreeNode node) {
        return new SQLQueryRowsTableDataModel(node, this.collectTableName(node));
    }

    @Nullable
    private SQLQueryQualifiedName collectTableName(@NotNull STMTreeNode node) {
        return this.collectTableName(node, false);
    }

    @Nullable
    private SQLQueryQualifiedName collectTableName(@NotNull STMTreeNode node, boolean forceUnquotted) {
        List actual = STMUtils.expandSubtree((STMTreeNode)node, tableNameContainers, actualTableNameContainers);
        return switch (actual.size()) {
            case 0 -> null;
            case 1 -> {
                node = (STMTreeNode)actual.get(0);
                if (node.getNodeName().equals(STMKnownRuleNames.tableName)) {
                    yield this.collectQualifiedName(node, forceUnquotted);
                }
                yield this.registerScopeItem(new SQLQueryQualifiedName(node, this.collectIdentifier(node, forceUnquotted)));
            }
            default -> throw new UnsupportedOperationException("Ambiguous tableName collection at " + node.getNodeName());
        };
    }

    @NotNull
    private SQLQueryQualifiedName collectQualifiedName(@NotNull STMTreeNode node, boolean forceUnquotted) {
        STMTreeNode entityNameNode;
        STMTreeNode sTMTreeNode = entityNameNode = qualifiedNameDirectWrapperNames.contains(node.getNodeName()) ? node.getStmChild(0) : node;
        if (!entityNameNode.getNodeName().equals(STMKnownRuleNames.qualifiedName)) {
            throw new UnsupportedOperationException("identifier expected while facing with " + node.getNodeName());
        }
        SQLQuerySymbolEntry entityName = this.collectIdentifier(entityNameNode.getStmChild(entityNameNode.getChildCount() - 1), forceUnquotted);
        if (entityNameNode.getChildCount() == 1) {
            return this.registerScopeItem(new SQLQueryQualifiedName(entityNameNode, entityName));
        }
        STMTreeNode schemaNameNode = entityNameNode.getStmChild(0);
        SQLQuerySymbolEntry schemaName = this.collectIdentifier(schemaNameNode.getStmChild(schemaNameNode.getChildCount() - 1), forceUnquotted);
        if (schemaNameNode.getChildCount() == 1) {
            return this.registerScopeItem(new SQLQueryQualifiedName(entityNameNode, schemaName, entityName));
        }
        STMTreeNode catalogNameNode = schemaNameNode.getStmChild(0);
        SQLQuerySymbolEntry catalogName = this.collectIdentifier(catalogNameNode.getStmChild(catalogNameNode.getChildCount() - 1), forceUnquotted);
        return this.registerScopeItem(new SQLQueryQualifiedName(entityNameNode, catalogName, schemaName, entityName));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private SQLQueryValueExpression collectValueExpression(@NotNull STMTreeNode node) {
        if (!knownValueExpressionRootNames.contains(node.getNodeName())) {
            throw new UnsupportedOperationException("Search condition or value expression expected while facing with " + node.getNodeName());
        }
        if (knownRecognizableValueExpressionNames.contains(node.getNodeName())) {
            return this.collectKnownValueExpression(node);
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (LexicalScopeHolder sh = this.openScope();){
            Stack<STMTreeNode> stack = new Stack<STMTreeNode>();
            Stack childLists = new Stack();
            stack.add(node);
            childLists.push(new ArrayList(1));
            while (stack.size() > 0) {
                SQLQueryValueFlattenedExpression sQLQueryValueFlattenedExpression;
                Object e;
                STMTreeNode n = (STMTreeNode)stack.pop();
                if (n != null) {
                    STMTreeNode rn = n;
                    while (rn.getChildCount() == 1 && !knownRecognizableValueExpressionNames.contains(rn.getNodeName())) {
                        rn = rn.getStmChild(0);
                    }
                    if (knownRecognizableValueExpressionNames.contains(rn.getNodeName())) {
                        ((List)childLists.peek()).add(this.collectKnownValueExpression(rn));
                        continue;
                    }
                    stack.push(n);
                    stack.push(null);
                    childLists.push(new ArrayList(rn.getChildCount()));
                    int i = rn.getChildCount() - 1;
                    while (i >= 0) {
                        stack.push(rn.getStmChild(i));
                        --i;
                    }
                    continue;
                }
                STMTreeNode content = (STMTreeNode)stack.pop();
                List children = (List)childLists.pop();
                if (children.size() <= 0) continue;
                if (children.size() == 1 && (e = children.get(0)) instanceof SQLQueryValueFlattenedExpression) {
                    void c;
                    SQLQueryValueFlattenedExpression cfr_ignored_0 = (SQLQueryValueFlattenedExpression)e;
                    SQLQueryValueFlattenedExpression cfr_ignored_1 = (SQLQueryValueFlattenedExpression)e;
                    sQLQueryValueFlattenedExpression = c;
                } else {
                    sQLQueryValueFlattenedExpression = new SQLQueryValueFlattenedExpression(content, children);
                }
                SQLQueryValueFlattenedExpression e2 = sQLQueryValueFlattenedExpression;
                ((List)childLists.peek()).add(e2);
            }
            List roots = (List)childLists.pop();
            SQLQueryValueExpression result = roots.isEmpty() ? new SQLQueryValueFlattenedExpression(node, Collections.emptyList()) : (SQLQueryValueExpression)roots.get(0);
            result.registerLexicalScope(sh.lexicalScope);
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @NotNull
    private SQLQueryValueExpression collectKnownValueExpression(@NotNull STMTreeNode node) {
        return switch (node.getNodeKindId()) {
            case 99 -> new SQLQueryValueSubqueryExpression(node, this.collectQueryExpression(node));
            case 86 -> this.collectValueReferenceExpression(node);
            case 167 -> new SQLQueryValueTypeCastExpression(node, this.collectValueExpression(node.getStmChild(0)), node.getStmChild(2).getTextContent());
            case 169 -> {
                String rawName = node.getStmChild(0).getTextContent();
                switch (rawName.charAt(0)) {
                    case '@': {
                        yield new SQLQueryValueVariableExpression(node, this.registerSymbolEntry(node, rawName.substring(1), rawName), SQLQueryValueVariableExpression.VariableExpressionKind.BATCH_VARIABLE, rawName);
                    }
                    case '$': {
                        yield new SQLQueryValueVariableExpression(node, this.registerSymbolEntry(node, rawName.substring(2, rawName.length() - 1), rawName), SQLQueryValueVariableExpression.VariableExpressionKind.CLIENT_VARIABLE, rawName);
                    }
                    case ':': {
                        yield new SQLQueryValueVariableExpression(node, this.registerSymbolEntry(node, rawName.substring(1), rawName), SQLQueryValueVariableExpression.VariableExpressionKind.CLIENT_PARAMETER, rawName);
                    }
                }
                throw new UnsupportedOperationException("Unsupported variable expression: " + node.getTextContent());
            }
            case 67 -> this.makeValueConstantExpression(node, SQLQueryExprType.BOOLEAN);
            case 6 -> this.makeValueConstantExpression(node, SQLQueryExprType.NUMERIC);
            case 7 -> this.makeValueConstantExpression(node, SQLQueryExprType.NUMERIC);
            case 8 -> this.makeValueConstantExpression(node, SQLQueryExprType.STRING);
            case 10 -> this.makeValueConstantExpression(node, SQLQueryExprType.DATETIME);
            default -> throw new UnsupportedOperationException("Unknown expression kind " + node.getNodeName());
        };
    }

    @NotNull
    private SQLQueryValueExpression makeValueConstantExpression(@NotNull STMTreeNode node, @NotNull SQLQueryExprType type) {
        return new SQLQueryValueConstantExpression(node, node.getTextContent(), type);
    }

    @NotNull
    private SQLQueryValueExpression collectValueReferenceExpression(@NotNull STMTreeNode node) {
        STMTreeNode head = node.getStmChild(0);
        SQLQueryValueExpression expr = switch (head.getNodeKindId()) {
            case 85 -> {
                SQLQueryQualifiedName tableName = this.collectTableName(head.getStmChild(0));
                STMTreeNode nameNode = head.findChildOfName(STMKnownRuleNames.columnName);
                if (nameNode != null) {
                    SQLQuerySymbolEntry columnName = this.collectIdentifier(nameNode);
                    if (head.getChildCount() == 1) {
                        yield new SQLQueryValueColumnReferenceExpression(head, columnName);
                    }
                    yield new SQLQueryValueColumnReferenceExpression(head, tableName, columnName);
                }
                yield new SQLQueryValueTupleReferenceExpression(head, tableName);
            }
            case 87 -> this.collectValueReferenceExpression(head.getStmChild(1));
            default -> throw new UnsupportedOperationException("Value reference expression expected while facing with " + head.getNodeName());
        };
        int rangeStart = node.getRealInterval().a;
        boolean[] slicingFlags = new boolean[node.getChildCount()];
        int i = 1;
        while (i < node.getChildCount()) {
            STMTreeNode step = node.getStmChild(i);
            Interval range = new Interval(rangeStart, step.getRealInterval().b);
            expr = switch (step.getNodeKindId()) {
                case 88 -> {
                    int s = i;
                    while (i < node.getChildCount() && step.getNodeKindId() == 88) {
                        step = node.getStmChild(i);
                        slicingFlags[i] = step.getStmChild(1).getNodeKindId() == 90;
                        ++i;
                    }
                    boolean[] slicingSpec = Arrays.copyOfRange(slicingFlags, s, i);
                    yield new SQLQueryValueIndexingExpression(range, node, expr, slicingSpec);
                }
                case 91 -> {
                    ++i;
                    yield new SQLQueryValueMemberExpression(range, node, expr, this.collectIdentifier(step.getStmChild(1)));
                }
                default -> throw new UnsupportedOperationException("Value member expression expected while facing with " + node.getNodeName());
            };
        }
        return expr;
    }

    @Nullable
    public static SQLQuerySymbolClass tryFallbackSymbolForStringLiteral(@NotNull SQLDialect dialect, @NotNull SQLQuerySymbolEntry symbolEntry, boolean isColumnResolved) {
        SQLQuerySymbolClass forcedClass = null;
        boolean isQuotedIdentifier = dialect.isQuotedIdentifier(symbolEntry.getRawName());
        char quoteChar = symbolEntry.getRawName().charAt(0);
        if (!isQuotedIdentifier && (quoteChar == '\"' || quoteChar == '`' || quoteChar == '\'') || isQuotedIdentifier && !isColumnResolved) {
            forcedClass = switch (quoteChar) {
                case '\'' -> SQLQuerySymbolClass.STRING;
                case '\"', '`' -> SQLQuerySymbolClass.QUOTED;
                default -> null;
            };
        }
        return forcedClass;
    }

    private SQLQueryLexicalScope beginScope() {
        SQLQueryLexicalScope scope = new SQLQueryLexicalScope();
        this.currentLexicalScopes.addLast(scope);
        return scope;
    }

    private void endScope(SQLQueryLexicalScope scope) {
        if (this.currentLexicalScopes.peekLast() != scope) {
            throw new IllegalStateException();
        }
        this.currentLexicalScopes.removeLast();
    }

    private <T extends SQLQueryLexicalScopeItem> T registerScopeItem(T item) {
        SQLQueryLexicalScope scope = this.currentLexicalScopes.peekLast();
        if (scope != null) {
            scope.registerItem(item);
        }
        return item;
    }

    private LexicalScopeHolder openScope() {
        return new LexicalScopeHolder(this.beginScope());
    }

    static /* synthetic */ SQLQueryValueExpression access$0(SQLQueryModelRecognizer sQLQueryModelRecognizer, STMTreeNode sTMTreeNode) {
        return sQLQueryModelRecognizer.collectValueExpression(sTMTreeNode);
    }

    private static class DebugGraphBuilder {
        private final DirectedGraph graph = new DirectedGraph();
        private final LinkedList<Pair<Object, Object>> stack = new LinkedList();
        private final Set<Object> done = new HashSet<Object>();
        private final Map<Object, DirectedGraph.Node> objs = new HashMap<Object, DirectedGraph.Node>();

        private DebugGraphBuilder() {
        }

        /*
         * WARNING - void declaration
         */
        private void expandObject(Object prev, Object o) {
            Object node;
            Object src;
            String propName = prev == null ? null : (String)((Pair)prev).getFirst();
            Object object = src = prev == null ? null : ((Pair)prev).getSecond();
            if (o instanceof SQLQueryDataContext || o instanceof SQLQueryRowsSourceModel || o instanceof SQLQueryValueExpression) {
                node = this.objs.get(o);
                DirectedGraph.Node prevNode = this.objs.get(src);
                if (node == null) {
                    String color = o instanceof SQLQueryDataContext ? "#bbbbff" : (o instanceof SQLQueryRowsSourceModel ? "#bbffbb" : (o instanceof SQLQueryValueExpression ? "#ffbbbb" : "#bbbbbb"));
                    node = this.graph.createNode(o.toString().substring(o.getClass().getPackageName().length()), color);
                    this.objs.put(o, (DirectedGraph.Node)node);
                }
                if (prevNode != null) {
                    this.graph.createEdge(prevNode, (DirectedGraph.Node)node, propName, null);
                }
                src = o;
                propName = "";
            }
            if (this.done.contains(o)) {
                return;
            }
            this.done.add(o);
            if (o instanceof String || o.getClass().isPrimitive() || o.getClass().isEnum()) {
                return;
            }
            if (o instanceof SQLQuerySymbol || o instanceof DBSObject || o instanceof DBCExecutionContext) {
                return;
            }
            Object object2 = o;
            if (object2 instanceof Iterable) {
                node = (Iterable)object2;
                Iterable cfr_ignored_0 = (Iterable)object2;
                return;
            }
            Class<?> t = o.getClass();
            while (t != Object.class) {
                Field[] fieldArray = t.getDeclaredFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field f = fieldArray[n2];
                    try {
                        Object x;
                        if ((f.canAccess(o) || f.trySetAccessible()) && (x = f.get(o)) != null) {
                            if (x instanceof String || x.getClass().isEnum()) {
                                DirectedGraph.Node prevNode = this.objs.get(src);
                                if (prevNode != null) {
                                    String text = x.toString().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;").replace("\n", "&#10;");
                                    prevNode.label = String.valueOf(prevNode.label) + "&#10;" + propName + "." + f.getName() + " = " + text;
                                }
                            } else {
                                Object object3 = x;
                                if (object3 instanceof Iterable) {
                                    void it;
                                    Iterable cfr_ignored_1 = (Iterable)object3;
                                    Iterable cfr_ignored_2 = (Iterable)object3;
                                    int index = 0;
                                    for (Object y : it) {
                                        if (y == null || this.done.contains(y)) continue;
                                        this.stack.addLast((Pair<Object, Object>)new Pair((Object)new Pair((Object)(propName + "[" + index++ + "]"), src), y));
                                    }
                                } else {
                                    this.stack.addLast((Pair<Object, Object>)new Pair((Object)new Pair((Object)(propName + "." + f.getName()), src), x));
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {}
                    ++n2;
                }
                t = t.getSuperclass();
            }
        }

        public void traverseObjs(Object obj) {
            this.stack.addLast((Pair<Object, Object>)new Pair(null, obj));
            while (this.stack.size() > 0) {
                Pair<Object, Object> p = this.stack.removeLast();
                this.expandObject(p.getFirst(), p.getSecond());
            }
        }
    }

    private class LexicalScopeHolder
    implements AutoCloseable {
        public final SQLQueryLexicalScope lexicalScope;

        public LexicalScopeHolder(SQLQueryLexicalScope scope) {
            this.lexicalScope = scope;
        }

        @Override
        public void close() {
            SQLQueryModelRecognizer.this.endScope(this.lexicalScope);
        }
    }

    private static class QueryExpressionMapper
    extends TreeMapper<SQLQueryRowsSourceModel, SQLQueryModelRecognizer> {
        @NotNull
        private static final Set<String> queryExpressionSubtreeNodeNames = Set.of(STMKnownRuleNames.sqlQuery, STMKnownRuleNames.directSqlDataStatement, STMKnownRuleNames.selectStatement, STMKnownRuleNames.withClause, STMKnownRuleNames.cteList, STMKnownRuleNames.with_list_element, STMKnownRuleNames.subquery, STMKnownRuleNames.unionTerm, STMKnownRuleNames.exceptTerm, STMKnownRuleNames.nonJoinQueryExpression, STMKnownRuleNames.nonJoinQueryTerm, STMKnownRuleNames.intersectTerm, STMKnownRuleNames.nonJoinQueryPrimary, STMKnownRuleNames.simpleTable, STMKnownRuleNames.querySpecification, STMKnownRuleNames.tableExpression, STMKnownRuleNames.queryPrimary, STMKnownRuleNames.queryTerm, STMKnownRuleNames.queryExpression, STMKnownRuleNames.selectStatementSingleRow, STMKnownRuleNames.fromClause, STMKnownRuleNames.nonjoinedTableReference, STMKnownRuleNames.tableReference, STMKnownRuleNames.joinedTable, STMKnownRuleNames.derivedTable, STMKnownRuleNames.tableSubquery, STMKnownRuleNames.crossJoinTerm, STMKnownRuleNames.naturalJoinTerm, STMKnownRuleNames.explicitTable);
        @NotNull
        private static final Map<String, TreeMapperCallback<SQLQueryRowsSourceModel, SQLQueryModelRecognizer>> translations = Map.ofEntries(Map.entry(STMKnownRuleNames.directSqlDataStatement, (n, cc, r) -> {
            if (cc.isEmpty()) {
                return null;
            }
            if (cc.size() == 1) {
                return (SQLQueryRowsSourceModel)cc.get(0);
            }
            List subqueries = cc.subList(0, cc.size() - 1);
            SQLQueryRowsSourceModel resultQuery = (SQLQueryRowsSourceModel)cc.get(cc.size() - 1);
            STMTreeNode withNode = n.findChildOfName(STMKnownRuleNames.withClause);
            boolean isRecursive = withNode.getChildCount() > 2;
            SQLQueryRowsCteModel cte = new SQLQueryRowsCteModel(n, isRecursive, resultQuery);
            STMTreeNode cteListNode = withNode.getStmChild(withNode.getChildCount() - 1);
            int i = 0;
            int j = 0;
            while (i < cteListNode.getChildCount() && j < subqueries.size()) {
                STMTreeNode cteSubqueryNode = cteListNode.getStmChild(i);
                SQLQuerySymbolEntry subqueryName = r.collectIdentifier(cteSubqueryNode.getStmChild(0));
                STMTreeNode columnListNode = cteSubqueryNode.findChildOfName(STMKnownRuleNames.columnNameList);
                List<SQLQuerySymbolEntry> columnList = columnListNode != null ? r.collectColumnNameList(columnListNode) : List.of();
                SQLQueryRowsSourceModel subquerySource = (SQLQueryRowsSourceModel)subqueries.get(j);
                cte.addSubquery(cteSubqueryNode, subqueryName, columnList, subquerySource);
                i += 2;
                ++j;
            }
            return cte;
        }), Map.entry(STMKnownRuleNames.queryExpression, (n, cc, r) -> {
            if (cc.isEmpty()) {
                return r.queryDataContext.getDefaultTable(n);
            }
            SQLQueryRowsSourceModel source = (SQLQueryRowsSourceModel)cc.get(0);
            int i = 1;
            while (i < cc.size()) {
                STMTreeNode childNode = n.getStmChild(i);
                List<SQLQuerySymbolEntry> corresponding = r.collectColumnNameList(childNode);
                SQLQueryRowsSourceModel nextSource = (SQLQueryRowsSourceModel)cc.get(i);
                Interval range = Interval.of((int)n.getRealInterval().a, (int)childNode.getRealInterval().b);
                SQLQueryRowsSetCorrespondingOperationKind opKind = switch (childNode.getNodeKindId()) {
                    case 101 -> SQLQueryRowsSetCorrespondingOperationKind.EXCEPT;
                    case 100 -> SQLQueryRowsSetCorrespondingOperationKind.UNION;
                    default -> throw new UnsupportedOperationException("Unexpected child node kind at queryExpression");
                };
                source = new SQLQueryRowsSetCorrespondingOperationModel(range, childNode, source, nextSource, corresponding, opKind);
                ++i;
            }
            return source;
        }), Map.entry(STMKnownRuleNames.nonJoinQueryTerm, (n, cc, r) -> {
            if (cc.isEmpty()) {
                return r.queryDataContext.getDefaultTable(n);
            }
            SQLQueryRowsSourceModel source = (SQLQueryRowsSourceModel)cc.get(0);
            int i = 1;
            while (i < cc.size()) {
                STMTreeNode childNode = n.getStmChild(i);
                List<SQLQuerySymbolEntry> corresponding = r.collectColumnNameList(childNode);
                SQLQueryRowsSourceModel nextSource = (SQLQueryRowsSourceModel)cc.get(i);
                Interval range = Interval.of((int)n.getRealInterval().a, (int)childNode.getRealInterval().b);
                switch (childNode.getNodeKindId()) {
                    case 104: {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unexpected child node kind at nonJoinQueryTerm");
                    }
                }
                SQLQueryRowsSetCorrespondingOperationKind opKind = SQLQueryRowsSetCorrespondingOperationKind.INTERSECT;
                source = new SQLQueryRowsSetCorrespondingOperationModel(range, childNode, source, nextSource, corresponding, opKind);
                ++i;
            }
            return source;
        }), Map.entry(STMKnownRuleNames.joinedTable, (n, cc, r) -> {
            if (cc.isEmpty()) {
                return r.queryDataContext.getDefaultTable(n);
            }
            SQLQueryRowsSourceModel source = (SQLQueryRowsSourceModel)cc.get(0);
            int i = 1;
            while (i < cc.size()) {
                SQLQueryRowsSourceModel currSource = source;
                SQLQueryRowsSourceModel nextSource = (SQLQueryRowsSourceModel)cc.get(i);
                STMTreeNode childNode = n.getStmChild(i);
                Interval range = Interval.of((int)n.getRealInterval().a, (int)childNode.getRealInterval().b);
                source = switch (childNode.getNodeKindId()) {
                    case 127 -> Optional.ofNullable(childNode.findChildOfName(STMKnownRuleNames.joinSpecification)).map(cn -> cn.findChildOfName(STMKnownRuleNames.joinCondition)).map(cn -> cn.findChildOfName(STMKnownRuleNames.searchCondition)).map(arg_0 -> SQLQueryModelRecognizer.access$0(r, arg_0)).map(e -> new SQLQueryRowsNaturalJoinModel(range, childNode, currSource, nextSource, (SQLQueryValueExpression)e)).orElseGet(() -> new SQLQueryRowsNaturalJoinModel(range, childNode, currSource, nextSource, r.collectColumnNameList(childNode)));
                    case 126 -> new SQLQueryRowsCrossJoinModel(range, childNode, currSource, nextSource);
                    default -> throw new UnsupportedOperationException("Unexpected child node kind at queryExpression");
                };
                ++i;
            }
            return source;
        }), Map.entry(STMKnownRuleNames.fromClause, QueryExpressionMapper::lambda$4), Map.entry(STMKnownRuleNames.querySpecification, (n, cc, r) -> {
            SQLQueryRowsProjectionModel projectionModel;
            SQLQueryLexicalScope selectListScope;
            STMTreeNode selectListNode = n.findChildOfName(STMKnownRuleNames.selectList);
            SQLQuerySelectionResultModel resultModel = new SQLQuerySelectionResultModel(selectListNode, (selectListNode.getChildCount() + 1) / 2);
            Throwable throwable = null;
            Object var7_7 = null;
            try (LexicalScopeHolder selectListScopeHolder = r.openScope();){
                selectListScope = selectListScopeHolder.lexicalScope;
                selectListScope.registerSyntaxNode(n.getStmChild(0));
                int i = 0;
                while (i < selectListNode.getChildCount()) {
                    STMTreeNode sublistNode;
                    STMTreeNode selectSublist = selectListNode.getStmChild(i);
                    if (selectSublist.getChildCount() > 0 && (sublistNode = selectSublist.getStmChild(0)) != null) {
                        switch (sublistNode.getNodeKindId()) {
                            case 111: {
                                SQLQueryValueExpression expr;
                                SQLQueryValueExpression sQLQueryValueExpression = expr = r.collectValueExpression(sublistNode.getStmChild(0));
                                if (sQLQueryValueExpression instanceof SQLQueryValueTupleReferenceExpression) {
                                    void tupleRef;
                                    SQLQueryValueTupleReferenceExpression cfr_ignored_0 = (SQLQueryValueTupleReferenceExpression)sQLQueryValueExpression;
                                    SQLQueryValueTupleReferenceExpression cfr_ignored_1 = (SQLQueryValueTupleReferenceExpression)sQLQueryValueExpression;
                                    resultModel.addTupleSpec(sublistNode, (SQLQueryValueTupleReferenceExpression)tupleRef);
                                    break;
                                }
                                if (sublistNode.getChildCount() > 1) {
                                    STMTreeNode asClause = sublistNode.getStmChild(1);
                                    SQLQuerySymbolEntry asColumnName = r.collectIdentifier(asClause.getStmChild(asClause.getChildCount() - 1));
                                    resultModel.addColumnSpec(sublistNode, expr, asColumnName);
                                    break;
                                }
                                resultModel.addColumnSpec(sublistNode, expr);
                                break;
                            }
                            case 269: {
                                break;
                            }
                            default: {
                                resultModel.addCompleteTupleSpec(sublistNode);
                            }
                        }
                    }
                    i += 2;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            SQLQueryRowsSourceModel source = cc.isEmpty() ? r.queryDataContext.getDefaultTable(n) : (SQLQueryRowsSourceModel)cc.get(0);
            STMTreeNode tableExpr = n.findChildOfName(STMKnownRuleNames.tableExpression);
            if (tableExpr != null) {
                selectListScope.registerSyntaxNode(tableExpr.getStmChild(0));
                SQLQueryValueExpression whereExpr = Optional.ofNullable(tableExpr.findChildOfName(STMKnownRuleNames.whereClause)).map(arg_0 -> SQLQueryModelRecognizer.access$0(r, arg_0)).orElse(null);
                SQLQueryValueExpression havingClause = Optional.ofNullable(tableExpr.findChildOfName(STMKnownRuleNames.havingClause)).map(arg_0 -> SQLQueryModelRecognizer.access$0(r, arg_0)).orElse(null);
                SQLQueryValueExpression groupByClause = Optional.ofNullable(tableExpr.findChildOfName(STMKnownRuleNames.groupByClause)).map(arg_0 -> SQLQueryModelRecognizer.access$0(r, arg_0)).orElse(null);
                SQLQueryValueExpression orderByClause = Optional.ofNullable(tableExpr.findChildOfName(STMKnownRuleNames.orderByClause)).map(arg_0 -> SQLQueryModelRecognizer.access$0(r, arg_0)).orElse(null);
                projectionModel = new SQLQueryRowsProjectionModel(n, selectListScope, source, resultModel, whereExpr, havingClause, groupByClause, orderByClause);
            } else {
                projectionModel = new SQLQueryRowsProjectionModel(n, selectListScope, source, resultModel);
            }
            return projectionModel;
        }), Map.entry(STMKnownRuleNames.nonjoinedTableReference, (n, cc, r) -> {
            STMTreeNode lastSubnode;
            STMTreeNode tableNameNode;
            SQLQueryRowsSourceModel source = cc.isEmpty() ? ((tableNameNode = n.findChildOfName(STMKnownRuleNames.tableName)) != null ? r.collectTableReference(tableNameNode) : r.queryDataContext.getDefaultTable(n)) : (SQLQueryRowsSourceModel)cc.get(0);
            if (n.getChildCount() > 1 && (lastSubnode = n.getStmChild(n.getChildCount() - 1)).getNodeName().equals(STMKnownRuleNames.correlationSpecification)) {
                SQLQuerySymbolEntry correlationName = r.collectIdentifier(lastSubnode.getStmChild(lastSubnode.getChildCount() == 1 || lastSubnode.getChildCount() == 4 ? 0 : 1));
                source = new SQLQueryRowsCorrelatedSourceModel(n, source, correlationName, r.collectColumnNameList(lastSubnode));
            }
            return source;
        }), Map.entry(STMKnownRuleNames.explicitTable, (n, cc, r) -> r.collectTableReference(n)), Map.entry(STMKnownRuleNames.tableValueConstructor, (n, cc, r) -> {
            ArrayList<SQLQueryValueExpression> values = new ArrayList<SQLQueryValueExpression>(n.getChildCount() / 2 + 1);
            int i = 1;
            while (i < n.getChildCount()) {
                values.add(r.collectValueExpression(n.getStmChild(i)));
                i += 2;
            }
            return new SQLQueryRowsTableValueModel(n, values);
        }));

        public QueryExpressionMapper(@Nullable SQLQueryModelRecognizer recognizer) {
            super(SQLQueryRowsSourceModel.class, queryExpressionSubtreeNodeNames, translations, recognizer);
        }

        /*
         * Unable to fully structure code
         */
        private static /* synthetic */ SQLQueryRowsSourceModel lambda$4(STMTreeNode n, List cc, SQLQueryModelRecognizer r) {
            if (cc.isEmpty()) {
                return r.queryDataContext.getDefaultTable(n);
            }
            source = (SQLQueryRowsSourceModel)cc.get(0);
            i = 1;
            while (i < cc.size()) {
                childNode = n.getStmChild(1 + i * 2);
                nextSource = (SQLQueryRowsSourceModel)cc.get(i);
                range = Interval.of((int)n.getRealInterval().a, (int)childNode.getRealInterval().b);
                switch (childNode.getNodeKindId()) {
                    case 119: {
                        ** break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unexpected child node kind at fromClause");
                    }
lbl-1000:
                    // 1 sources

                    {
                        source = new SQLQueryRowsCrossJoinModel(range, childNode, source, nextSource);
                    }
                }
                ++i;
            }
            return source;
        }
    }

    private static class RecognitionContext
    implements SQLQueryRecognitionContext {
        private final DBRProgressMonitor monitor;

        public RecognitionContext(@NotNull DBRProgressMonitor monitor) {
            this.monitor = monitor;
        }

        @Override
        @NotNull
        public DBRProgressMonitor getMonitor() {
            return this.monitor;
        }

        @Override
        public void appendError(@NotNull SQLQuerySymbolEntry symbol, @NotNull String error, @NotNull DBException ex) {
        }

        @Override
        public void appendError(@NotNull SQLQuerySymbolEntry symbol, @NotNull String error) {
        }

        @Override
        public void appendError(@NotNull STMTreeNode treeNode, @NotNull String error) {
        }
    }

    private static class TreeMapper<T, C> {
        @NotNull
        private final Class<T> mappingResultType;
        @NotNull
        private final Set<String> transparentNodeNames;
        @NotNull
        private final Map<String, TreeMapperCallback<T, C>> translations;
        @NotNull
        private final Stack<MapperFrame> stack = new Stack();
        @NotNull
        private final C context;

        public TreeMapper(@NotNull Class<T> mappingResultType, @NotNull Set<String> transparentNodeNames, @NotNull Map<String, TreeMapperCallback<T, C>> translations, @NotNull C context) {
            this.mappingResultType = mappingResultType;
            this.transparentNodeNames = transparentNodeNames;
            this.translations = translations;
            this.context = context;
        }

        @NotNull
        public T translate(@NotNull STMTreeNode root) {
            MapperRootFrame rootFrame = new MapperRootFrame(root);
            this.stack.push(rootFrame);
            while (this.stack.size() > 0) {
                this.stack.pop().doWork();
            }
            return rootFrame.result;
        }

        private class MapperDataPendingNodeFrame
        extends MapperNodeFrame
        implements MapperResultFrame<T> {
            @NotNull
            public final List<T> childrenData;
            @NotNull
            public final TreeMapperCallback<T, C> translation;

            public MapperDataPendingNodeFrame(@NotNull STMTreeNode node, @NotNull MapperResultFrame<T> parent, TreeMapperCallback<T, C> translation) {
                super(node, parent);
                this.childrenData = new LinkedList();
                this.translation = translation;
            }

            @Override
            public void aggregate(@NotNull T result) {
                this.childrenData.add(result);
            }

            @Override
            public void doWork() {
                this.parent.aggregate(this.translation.apply(this.node, this.childrenData, TreeMapper.this.context));
            }
        }

        private static interface MapperFrame {
            public void doWork();
        }

        private abstract class MapperNodeFrame
        implements MapperFrame {
            @NotNull
            public final STMTreeNode node;
            @NotNull
            public final MapperResultFrame<T> parent;

            public MapperNodeFrame(@NotNull STMTreeNode node, MapperResultFrame<T> parent) {
                this.node = node;
                this.parent = parent;
            }
        }

        private class MapperQueuedNodeFrame
        extends MapperNodeFrame {
            public MapperQueuedNodeFrame(@NotNull STMTreeNode node, MapperResultFrame<T> parent) {
                super(node, parent);
            }

            @Override
            public void doWork() {
                MapperResultFrame aggregator;
                TreeMapperCallback translation = TreeMapper.this.translations.get(this.node.getNodeName());
                MapperResultFrame mapperResultFrame = aggregator = translation == null ? this.parent : new MapperDataPendingNodeFrame(this.node, this.parent, translation);
                if (translation != null) {
                    TreeMapper.this.stack.push(aggregator);
                }
                int i = this.node.getChildCount() - 1;
                while (i >= 0) {
                    if (TreeMapper.this.transparentNodeNames.contains(this.node.getNodeName())) {
                        TreeMapper.this.stack.push(new MapperQueuedNodeFrame((STMTreeNode)this.node.getChild(i), aggregator));
                    }
                    --i;
                }
            }
        }

        private static interface MapperResultFrame<T>
        extends MapperFrame {
            public void aggregate(@NotNull T var1);
        }

        private class MapperRootFrame
        implements MapperResultFrame<T> {
            @NotNull
            public final STMTreeNode node;
            @Nullable
            public T result = null;

            public MapperRootFrame(STMTreeNode node) {
                this.node = node;
            }

            @Override
            public void aggregate(@NotNull T result) {
                this.result = result;
            }

            @Override
            public void doWork() {
                TreeMapper.this.stack.push(new MapperQueuedNodeFrame(this.node, this));
            }
        }
    }

    @FunctionalInterface
    private static interface TreeMapperCallback<T, C> {
        public T apply(STMTreeNode var1, List<T> var2, C var3);
    }
}

