/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.semantics.OffsetKeyedTreeMap;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLTokenEntryAtOffset;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModel;

public class SQLDocumentScriptItemSyntaxContext {
    private static final Log log = Log.getLog(SQLDocumentScriptItemSyntaxContext.class);
    @NotNull
    private final Object lock = new Object();
    @NotNull
    private final OffsetKeyedTreeMap<SQLQuerySymbolEntry> entries = new OffsetKeyedTreeMap();
    @NotNull
    private final String originalText;
    @NotNull
    private final SQLQueryModel queryModel;
    private int length;
    private boolean isDirty = false;

    public SQLDocumentScriptItemSyntaxContext(@NotNull String originalText, @NotNull SQLQueryModel queryModel, int length) {
        this.originalText = originalText;
        this.queryModel = queryModel;
        this.length = length;
    }

    @NotNull
    public String getOriginalText() {
        return this.originalText;
    }

    @NotNull
    public SQLQueryModel getQueryModel() {
        return this.queryModel;
    }

    public int length() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        Object object = this.lock;
        synchronized (object) {
            return this.isDirty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SQLTokenEntryAtOffset findToken(int offset) {
        Object object = this.lock;
        synchronized (object) {
            OffsetKeyedTreeMap.NodesIterator<SQLQuerySymbolEntry> it = this.entries.nodesIteratorAt(offset);
            SQLQuerySymbolEntry entry = it.getCurrValue();
            int entryOffset = it.getCurrOffset();
            if (entry == null && it.prev()) {
                entry = it.getCurrValue();
                entryOffset = it.getCurrOffset();
            }
            if (entry != null && entryOffset <= offset && entryOffset + entry.getInterval().length() > offset) {
                return new SQLTokenEntryAtOffset(entryOffset, entry);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerToken(int offset, @NotNull SQLQuerySymbolEntry token) {
        Object object = this.lock;
        synchronized (object) {
            this.entries.put(offset, token);
            this.isDirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyDelta(int offset, int oldLength, int newLength) {
        Object object = this.lock;
        synchronized (object) {
            if (oldLength > 0) {
                throw new UnsupportedOperationException();
            }
            this.entries.applyOffset(offset, newLength);
            this.length += newLength - oldLength;
            this.isDirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.entries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCompleted() {
        Object object = this.lock;
        synchronized (object) {
            this.isDirty = false;
        }
    }
}

