/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.schema.SQLSchemaScriptSource;

public class ClassLoaderScriptSource
implements SQLSchemaScriptSource {
    private final ClassLoader classLoader;
    private final String createScriptPath;
    private final String updateScriptPrefix;

    public ClassLoaderScriptSource(ClassLoader classLoader, String createScriptPath, String updateScriptPrefix) {
        this.classLoader = classLoader;
        this.createScriptPath = createScriptPath;
        this.updateScriptPrefix = updateScriptPrefix;
    }

    @Override
    @NotNull
    public Reader openSchemaCreateScript(@NotNull DBRProgressMonitor monitor) throws IOException, DBException {
        InputStream resource = this.classLoader.getResourceAsStream(this.createScriptPath);
        if (resource == null) {
            throw new IOException("Resource '" + this.createScriptPath + "' not found in " + this.classLoader.getClass().getName());
        }
        return new InputStreamReader(resource);
    }

    @Override
    @Nullable
    public Reader openSchemaUpdateScript(@NotNull DBRProgressMonitor monitor, int versionNumber, @Nullable String specificPrefix) throws IOException, DBException {
        InputStream resource = this.classLoader.getResourceAsStream(this.updateScriptPrefix + versionNumber + "_" + specificPrefix + ".sql");
        if (resource == null) {
            resource = this.classLoader.getResourceAsStream(this.updateScriptPrefix + versionNumber + ".sql");
        }
        return resource == null ? null : new InputStreamReader(resource);
    }
}

