/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.tokens.predicates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.parser.TrieNode;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TrieLookupComparator;
import org.jkiss.dbeaver.utils.ListNode;

public class Trie<T, V> {
    private final Comparator<T> strongComparer;
    private final TrieLookupComparator<T> lookupPartialComparer;
    private TreeNode root = new TreeNode(null);

    public Trie(@NotNull Comparator<T> strongComparer, @NotNull TrieLookupComparator<T> lookupComparer) {
        this.strongComparer = strongComparer;
        this.lookupPartialComparer = lookupComparer;
    }

    @NotNull
    public TrieNode<T, V> getRoot() {
        return this.root;
    }

    public void add(@NotNull Iterable<T> key, @NotNull V value) {
        this.add(key.iterator(), value);
    }

    public void add(@NotNull Iterator<T> key, @NotNull V value) {
        TreeNode node = this.root;
        while (key.hasNext()) {
            T term = key.next();
            node = node.addOrCreateChild(term);
        }
        node.values.add(value);
    }

    @Nullable
    private ListNode<Set<V>> lookupImpl(@NotNull Iterator<T> key) {
        ListNode nextNodes;
        if (!key.hasNext()) {
            if (this.root.values.size() > 0) {
                return ListNode.of(this.root.values);
            }
            return null;
        }
        ListNode activeNodes = ListNode.of((Object)this.root);
        ListNode results = null;
        do {
            T term = key.next();
            nextNodes = null;
            ListNode currNode = activeNodes;
            while (currNode != null) {
                TrieNode node = (TrieNode)currNode.data;
                Set values = node.getValues();
                if (values.size() > 0) {
                    results = ListNode.push(results, (Object)values);
                }
                nextNodes = node.accumulateSubnodesByTerm(term, nextNodes);
                currNode = currNode.next;
            }
        } while ((activeNodes = nextNodes) != null && key.hasNext());
        ListNode currNode = activeNodes;
        while (currNode != null) {
            results = ListNode.push((ListNode)results, (Object)((TrieNode)currNode.data).getValues());
            currNode = currNode.next;
        }
        return results;
    }

    @NotNull
    public Set<V> collectValuesOnPath(@NotNull Iterator<T> key) {
        ListNode values = this.lookupImpl(key);
        if (values == null) {
            return Collections.emptySet();
        }
        HashSet result = new HashSet();
        ListNode currNode = values;
        while (currNode != null) {
            result.addAll((Collection)currNode.data);
            currNode = currNode.next;
        }
        return result;
    }

    private class TreeNode
    implements TrieNode<T, V> {
        public final T term;
        public final Set<V> values;
        public boolean isStronglyOrdered = true;
        public boolean isPartiallyOrdered = true;
        public final List<T> childKeys;
        public final List<TreeNode> childNodes;

        public TreeNode(T term) {
            this.term = term;
            this.values = new HashSet();
            this.childKeys = new ArrayList();
            this.childNodes = new ArrayList<TreeNode>();
        }

        @NotNull
        public Set<V> getValues() {
            return this.values;
        }

        @NotNull
        public TreeNode addOrCreateChild(@NotNull T term) {
            int index = Collections.binarySearch(this.childKeys, term, Trie.this.strongComparer);
            if (index >= 0) {
                return this.childNodes.get(index);
            }
            TreeNode newNode = new TreeNode(term);
            this.childKeys.add(index ^= 0xFFFFFFFF, term);
            this.childNodes.add(index, newNode);
            if (!Trie.this.lookupPartialComparer.isStronglyComparable(term)) {
                this.isStronglyOrdered = false;
            }
            if (!Trie.this.lookupPartialComparer.isPartiallyComparable(term)) {
                this.isPartiallyOrdered = false;
            }
            return newNode;
        }

        @Nullable
        public ListNode<TrieNode<T, V>> accumulateSubnodesByTerm(@NotNull T term, @NotNull ListNode<TrieNode<T, V>> results) {
            int index;
            Object accumulatedResults = this.isStronglyOrdered && Trie.this.lookupPartialComparer.isStronglyComparable(term) ? ((index = Collections.binarySearch(this.childKeys, term, Trie.this.strongComparer)) >= 0 ? ListNode.push(results, (Object)this.childNodes.get(index)) : results) : (this.isPartiallyOrdered && Trie.this.lookupPartialComparer.isPartiallyComparable(term) ? this.accumulatePartiallyComparableSubnodes(term, results) : this.accumulateNonComparableSubnodes(term, results));
            return accumulatedResults;
        }

        @Nullable
        private ListNode<TrieNode<T, V>> accumulateNonComparableSubnodes(@NotNull T term, @NotNull ListNode<TrieNode<T, V>> results) {
            TrieLookupComparator comparer = Trie.this.lookupPartialComparer;
            ListNode accumulatedResults = results;
            int i = 0;
            while (i < this.childKeys.size()) {
                if (comparer.match(this.childKeys.get(i), term)) {
                    accumulatedResults = ListNode.push(accumulatedResults, (Object)this.childNodes.get(i));
                }
                ++i;
            }
            return accumulatedResults;
        }

        @NotNull
        private ListNode<TrieNode<T, V>> accumulatePartiallyComparableSubnodes(@NotNull T term, @NotNull ListNode<TrieNode<T, V>> results) {
            TrieLookupComparator comparer = Trie.this.lookupPartialComparer;
            ListNode accumulatedResults = results;
            int index = Collections.binarySearch(this.childKeys, term, comparer);
            if (index >= 0) {
                if (comparer.match(this.childKeys.get(index), term)) {
                    accumulatedResults = ListNode.push(accumulatedResults, (Object)this.childNodes.get(index));
                }
                int i = index + 1;
                while (i < this.childKeys.size() && comparer.compare(this.childKeys.get(i), term) == 0) {
                    if (comparer.match(this.childKeys.get(i), term)) {
                        accumulatedResults = ListNode.push((ListNode)accumulatedResults, (Object)this.childNodes.get(i));
                    }
                    ++i;
                }
                i = index - 1;
                while (i >= 0 && comparer.compare(this.childKeys.get(i), term) == 0) {
                    if (comparer.match(this.childKeys.get(i), term)) {
                        accumulatedResults = ListNode.push((ListNode)accumulatedResults, (Object)this.childNodes.get(i));
                    }
                    --i;
                }
            }
            return accumulatedResults;
        }
    }
}

