/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.statistics;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.internal.statistics.StatisticCollectionMessages;
import org.jkiss.dbeaver.ui.statistics.PrefPageUsageStatistics;
import org.jkiss.dbeaver.ui.statistics.UIStatisticsActivator;

public class StatisticsCollectionConfirmDialog
extends BaseDialog {
    private Button shareData;

    public StatisticsCollectionConfirmDialog(Shell parentShell) {
        super(parentShell, StatisticCollectionMessages.statistic_collection_dialog_title, (DBPImage)DBIcon.STATUS_INFO);
    }

    protected Composite createDialogArea(@NotNull Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        Composite composite = UIUtils.createComposite((Composite)dialogArea, (int)1);
        Label label = UIUtils.createLabel((Composite)composite, (String)"Data share");
        label.setFont(JFaceResources.getFont((String)"org.eclipse.jface.headerfont"));
        UIUtils.createHorizontalLine((Composite)composite);
        PrefPageUsageStatistics.createDataShareComposite(composite);
        UIUtils.createEmptyLabel((Composite)composite, (int)1, (int)1);
        UIUtils.createLink((Composite)composite, (String)StatisticCollectionMessages.statistic_collection_pref_link, (SelectionListener)SelectionListener.widgetSelectedAdapter(selectionEvent -> {
            Shell parentShell = this.getParentShell();
            this.close();
            UIUtils.showPreferencesFor((Shell)parentShell, null, (String[])new String[]{"org.jkiss.dbeaver.preferences.main.usageStatistics"});
        }));
        UIUtils.createEmptyLabel((Composite)composite, (int)1, (int)1);
        this.shareData = UIUtils.createCheckbox((Composite)composite, (String)StatisticCollectionMessages.statistic_collection_dont_share_lbl, (boolean)false);
        return composite;
    }

    protected void createButtonsForButtonBar(@NotNull Composite parent) {
        this.createButton(parent, 2, StatisticCollectionMessages.statistic_collection_confirm_lbl, true);
    }

    protected void buttonPressed(int buttonId) {
        if (this.shareData.getSelection()) {
            UIStatisticsActivator.setTrackingEnabled(buttonId == 3);
        } else {
            UIStatisticsActivator.setTrackingEnabled(buttonId == 2);
        }
        UIStatisticsActivator.setSkipDataShareConfirmation(true);
        this.close();
        super.buttonPressed(buttonId);
    }
}

