/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.GenericMessages;
import org.jkiss.dbeaver.ext.generic.model.ConstraintKeysCache;
import org.jkiss.dbeaver.ext.generic.model.ForeignKeysCache;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericPackage;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSynonym;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.IndexCache;
import org.jkiss.dbeaver.ext.generic.model.TableCache;
import org.jkiss.dbeaver.ext.generic.model.TableTriggerCache;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public abstract class GenericObjectContainer
implements GenericStructContainer,
DBPRefreshableObject {
    private static final Log log = Log.getLog(GenericObjectContainer.class);
    @NotNull
    private final GenericDataSource dataSource;
    private final TableCache tableCache;
    private final IndexCache indexCache;
    private final ForeignKeysCache foreignKeysCache;
    private final ConstraintKeysCache constraintKeysCache;
    private final ContainerTriggerCache containerTriggerCache;
    private final TableTriggerCache tableTriggerCache;
    private final GenericSequenceCache sequenceCache;
    private final GenericSynonymCache synonymCache;
    private List<GenericPackage> packages;
    protected List<GenericProcedure> procedures;
    protected List<? extends GenericSequence> sequences;
    protected List<? extends GenericSynonym> synonyms;

    protected GenericObjectContainer(@NotNull GenericDataSource dataSource) {
        this.dataSource = dataSource;
        this.tableCache = this.createTableCache(dataSource);
        this.indexCache = new IndexCache(this.tableCache);
        this.constraintKeysCache = new ConstraintKeysCache(this.tableCache);
        this.foreignKeysCache = new ForeignKeysCache(this.tableCache);
        this.containerTriggerCache = new ContainerTriggerCache();
        this.tableTriggerCache = new TableTriggerCache(this.tableCache);
        this.sequenceCache = new GenericSequenceCache();
        this.synonymCache = new GenericSynonymCache();
    }

    public TableCache createTableCache(GenericDataSource datasource) {
        return new TableCache(datasource);
    }

    @Override
    public final TableCache getTableCache() {
        return this.tableCache;
    }

    @Override
    public final IndexCache getIndexCache() {
        return this.indexCache;
    }

    @Override
    public final ConstraintKeysCache getConstraintKeysCache() {
        return this.constraintKeysCache;
    }

    @Override
    public final ForeignKeysCache getForeignKeysCache() {
        return this.foreignKeysCache;
    }

    @Override
    public TableTriggerCache getTableTriggerCache() {
        return this.tableTriggerCache;
    }

    @Override
    public GenericSequenceCache getSequenceCache() {
        return this.sequenceCache;
    }

    @Override
    public GenericSynonymCache getSynonymCache() {
        return this.synonymCache;
    }

    @Override
    @NotNull
    public GenericDataSource getDataSource() {
        return this.dataSource;
    }

    public boolean isPersisted() {
        return true;
    }

    @Override
    public List<? extends GenericView> getViews(DBRProgressMonitor monitor) throws DBException {
        List<? extends GenericTableBase> tables = this.getTables(monitor);
        if (tables != null) {
            ArrayList<GenericView> filtered = new ArrayList<GenericView>();
            for (GenericTableBase genericTableBase : tables) {
                if (!(genericTableBase instanceof GenericView)) continue;
                filtered.add((GenericView)genericTableBase);
            }
            return filtered;
        }
        return null;
    }

    @Override
    public List<? extends GenericTable> getPhysicalTables(DBRProgressMonitor monitor) throws DBException {
        List<? extends GenericTableBase> tables = this.getTables(monitor);
        if (tables != null) {
            ArrayList<GenericTable> filtered = new ArrayList<GenericTable>();
            for (GenericTableBase genericTableBase : tables) {
                if (!genericTableBase.isPhysicalTable()) continue;
                filtered.add((GenericTable)genericTableBase);
            }
            return filtered;
        }
        return null;
    }

    @Override
    public List<? extends GenericTableBase> getTables(DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Override
    public GenericTableBase getTable(DBRProgressMonitor monitor, String name) throws DBException {
        return (GenericTableBase)this.tableCache.getObject(monitor, (DBSObject)this, name);
    }

    public Collection<GenericTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        this.cacheIndexes(monitor, true);
        return this.indexCache.getObjects(monitor, (DBSObject)this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheIndexes(DBRProgressMonitor monitor, boolean readFromTables) throws DBException {
        IndexCache indexCache = this.indexCache;
        synchronized (indexCache) {
            if (!this.indexCache.isFullyCached()) {
                ArrayList<? extends GenericTableIndex> newIndexCache;
                List oldCache = this.indexCache.getCachedObjects();
                this.indexCache.clearCache();
                try {
                    newIndexCache = this.indexCache.getObjects(monitor, (DBSObject)this, null);
                }
                catch (DBException e) {
                    log.debug((Object)"Error reading catalog/schema indexes. Get indexes from tables", (Throwable)e);
                    newIndexCache = new ArrayList<GenericTableIndex>();
                }
                if (readFromTables && newIndexCache.isEmpty()) {
                    newIndexCache = new ArrayList();
                    this.indexCache.clearCache();
                    List<? extends GenericTableBase> tables = this.getTables(monitor);
                    monitor.beginTask("Cache indexes from tables", tables.size());
                    try {
                        for (GenericTableBase genericTableBase : tables) {
                            if (monitor.isCanceled()) {
                                return;
                            }
                            monitor.subTask("Read indexes for '" + genericTableBase.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'");
                            Collection<? extends GenericTableIndex> tableIndexes = genericTableBase.getIndexes(monitor);
                            if (!CommonUtils.isEmpty(tableIndexes)) {
                                newIndexCache.addAll(tableIndexes);
                            }
                            monitor.worked(1);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
                for (GenericTableIndex oldIndex : oldCache) {
                    if (!oldIndex.isPersisted()) {
                        newIndexCache.add(oldIndex);
                        continue;
                    }
                    int i = 0;
                    while (i < newIndexCache.size()) {
                        GenericTableIndex newIndex = (GenericTableIndex)((Object)newIndexCache.get(i));
                        if (oldIndex.getContainer() == newIndex.getContainer() && CommonUtils.equalObjects((Object)oldIndex.getName(), (Object)newIndex.getName())) {
                            newIndexCache.set(i, oldIndex);
                        }
                        ++i;
                    }
                }
                this.indexCache.setCache(newIndexCache);
            }
        }
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        if ((scope & 1) != 0) {
            monitor.subTask("Cache tables");
            this.tableCache.getAllObjects(monitor, (DBSObject)this);
        }
        if ((scope & 2) != 0 && this.dataSource.supportsStructCache()) {
            try {
                monitor.subTask("Cache tables' columns");
                this.tableCache.loadChildren(monitor, (DBSObject)this, null);
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
        if ((scope & 4) != 0 && this.dataSource.supportsStructCache()) {
            try {
                monitor.subTask("Cache primary keys");
                List objects = this.constraintKeysCache.getObjects(monitor, (DBSObject)this, null);
                if (CommonUtils.isEmpty((Collection)objects)) {
                    this.constraintKeysCache.clearCache();
                }
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
            if (this.dataSource.getInfo().supportsIndexes()) {
                monitor.subTask("Cache indexes");
                this.cacheIndexes(monitor, false);
            }
            if (this.dataSource.getInfo().supportsReferentialIntegrity()) {
                try {
                    monitor.subTask("Cache foreign keys");
                    List foreignKeys = this.foreignKeysCache.getObjects(monitor, (DBSObject)this, null);
                    if (CommonUtils.isEmpty((Collection)foreignKeys)) {
                        this.foreignKeysCache.clearCache();
                    }
                }
                catch (Exception e) {
                    log.debug((Object)e);
                }
            }
        }
    }

    public Collection<GenericPackage> getPackages(DBRProgressMonitor monitor) throws DBException {
        if (this.procedures == null) {
            this.loadProcedures(monitor);
        }
        return this.packages;
    }

    public GenericPackage getPackage(DBRProgressMonitor monitor, String name) throws DBException {
        return (GenericPackage)DBUtils.findObject(this.getPackages(monitor), (String)name);
    }

    public List<GenericProcedure> getProcedureCache() {
        return this.procedures;
    }

    public List<GenericProcedure> getProcedures(DBRProgressMonitor monitor) throws DBException {
        if (this.procedures == null) {
            this.loadProcedures(monitor);
        }
        return this.procedures;
    }

    @Override
    public GenericProcedure getProcedure(DBRProgressMonitor monitor, String uniqueName) throws DBException {
        for (GenericProcedure procedure : CommonUtils.safeCollection((Collection)this.getProcedures(monitor))) {
            if (!uniqueName.equals(procedure.getUniqueName())) continue;
            return procedure;
        }
        return null;
    }

    public List<GenericProcedure> getProcedures(DBRProgressMonitor monitor, String name) throws DBException {
        return DBUtils.findObjects((Collection)this.getProcedures(monitor), (String)name);
    }

    public List<? extends GenericProcedure> getProceduresOnly(DBRProgressMonitor monitor) throws DBException {
        if (!this.dataSource.splitProceduresAndFunctions()) {
            return this.getProcedures(monitor);
        }
        ArrayList<GenericProcedure> filteredProcedures = new ArrayList<GenericProcedure>();
        for (GenericProcedure proc : CommonUtils.safeList((List)this.getProcedures(monitor))) {
            if (proc.getProcedureType() != DBSProcedureType.PROCEDURE) continue;
            filteredProcedures.add(proc);
        }
        return filteredProcedures;
    }

    @Override
    public Collection<? extends GenericProcedure> getFunctionsOnly(DBRProgressMonitor monitor) throws DBException {
        ArrayList<GenericProcedure> filteredProcedures = new ArrayList<GenericProcedure>();
        for (GenericProcedure proc : CommonUtils.safeList((List)this.getProcedures(monitor))) {
            if (proc.getProcedureType() != DBSProcedureType.FUNCTION) continue;
            filteredProcedures.add(proc);
        }
        return filteredProcedures;
    }

    @Override
    public Collection<? extends GenericSequence> getSequences(DBRProgressMonitor monitor) throws DBException {
        return this.sequenceCache.getAllObjects(monitor, (DBSObject)this);
    }

    public GenericSequence getSequence(DBRProgressMonitor monitor, String name) throws DBException {
        return (GenericSequence)this.sequenceCache.getObject(monitor, (DBSObject)this, name);
    }

    @Override
    public Collection<? extends GenericSynonym> getSynonyms(DBRProgressMonitor monitor) throws DBException {
        return this.synonymCache.getAllObjects(monitor, (DBSObject)this);
    }

    public GenericSynonym getSynonym(DBRProgressMonitor monitor, String name) throws DBException {
        return (GenericSynonym)this.synonymCache.getObject(monitor, (DBSObject)this, name);
    }

    @Override
    public Collection<? extends GenericTrigger> getTriggers(DBRProgressMonitor monitor) throws DBException {
        return this.getDataSource().getMetaModel().supportsDatabaseTriggers(this.getDataSource()) ? this.containerTriggerCache.getAllObjects(monitor, (DBSObject)this) : Collections.emptyList();
    }

    @Override
    public Collection<? extends GenericTrigger> getTableTriggers(DBRProgressMonitor monitor) throws DBException {
        return this.getDataSource().getMetaModel().supportsTriggers(this.getDataSource()) ? this.tableTriggerCache.getAllObjects(monitor, (DBSObject)this) : Collections.emptyList();
    }

    @Association
    @Nullable
    public GenericTrigger getTableTrigger(@NotNull DBRProgressMonitor monitor, String triggerName) throws DBException {
        return this.getDataSource().getMetaModel().supportsTriggers(this.getDataSource()) ? (GenericTrigger)this.tableTriggerCache.getObject(monitor, (DBSObject)this, triggerName) : null;
    }

    @Override
    @Association
    public Collection<? extends DBSDataType> getDataTypes(DBRProgressMonitor monitor) throws DBException {
        return this.getDataSource().getDataTypes(monitor);
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        ArrayList<? extends GenericTableBase> childrenList = new ArrayList<GenericTableBase>(this.getTables(monitor));
        if (this.dataSource.getMetaModel().supportsSynonyms(this.dataSource)) {
            childrenList.addAll(this.getSynonyms(monitor));
        }
        return childrenList;
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.getTable(monitor, childName);
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        boolean needsStructureCaching = !this.getTableCache().isEmpty();
        this.tableCache.clearCache();
        this.indexCache.clearCache();
        this.constraintKeysCache.clearCache();
        this.foreignKeysCache.clearCache();
        this.containerTriggerCache.clearCache();
        this.tableTriggerCache.clearCache();
        this.sequenceCache.clearCache();
        this.synonymCache.clearCache();
        this.packages = null;
        this.procedures = null;
        this.sequences = null;
        this.synonyms = null;
        if (needsStructureCaching) {
            this.cacheStructure(monitor, 7);
        }
        return this;
    }

    public String toString() {
        return this.getName() == null ? GenericMessages.generic_object_container_none : this.getName();
    }

    private synchronized void loadProcedures(DBRProgressMonitor monitor) throws DBException {
        this.dataSource.getMetaModel().loadProcedures(monitor, this);
        if (this.procedures != null) {
            DBUtils.orderObjects(this.procedures);
        }
        if (this.packages != null) {
            for (GenericPackage pack : this.packages) {
                pack.orderProcedures();
            }
        }
    }

    public void addProcedure(GenericProcedure procedure) {
        if (this.procedures == null) {
            this.procedures = new ArrayList<GenericProcedure>();
        }
        this.procedures.add(procedure);
    }

    public boolean hasProcedure(String name) {
        if (this.procedures != null) {
            for (GenericProcedure proc : this.procedures) {
                if (!proc.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public void addPackage(GenericPackage procedurePackage) {
        if (this.packages == null) {
            this.packages = new ArrayList<GenericPackage>();
        }
        this.packages.add(procedurePackage);
    }

    public class ContainerTriggerCache
    extends JDBCObjectCache<GenericStructContainer, GenericTrigger> {
        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container) throws SQLException {
            return container.getDataSource().getMetaModel().prepareContainerTriggersLoadStatement(session, container);
        }

        @Nullable
        protected GenericTrigger fetchObject(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return container.getDataSource().getMetaModel().createContainerTriggerImpl(container, resultSet);
        }
    }

    class GenericSequenceCache
    extends JDBCObjectCache<GenericObjectContainer, GenericSequence> {
        GenericSequenceCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull GenericObjectContainer container) throws SQLException {
            return container.getDataSource().getMetaModel().prepareSequencesLoadStatement(session, container);
        }

        @Nullable
        protected GenericSequence fetchObject(@NotNull JDBCSession session, @NotNull GenericObjectContainer container, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return container.getDataSource().getMetaModel().createSequenceImpl(session, container, resultSet);
        }

        protected boolean handleCacheReadError(Exception error) {
            return GenericObjectContainer.this.getDataSource().getMetaModel().handleSequenceCacheReadingError(error);
        }
    }

    class GenericSynonymCache
    extends JDBCObjectCache<GenericObjectContainer, GenericSynonym> {
        GenericSynonymCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull GenericObjectContainer container) throws SQLException {
            return container.getDataSource().getMetaModel().prepareSynonymsLoadStatement(session, container);
        }

        @Nullable
        protected GenericSynonym fetchObject(@NotNull JDBCSession session, @NotNull GenericObjectContainer container, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return container.getDataSource().getMetaModel().createSynonymImpl(session, container, resultSet);
        }
    }
}

