/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBConstants;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class GenericTableColumnManager
extends SQLTableColumnManager<GenericTableColumn, GenericTableBase> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, GenericTableColumn> getObjectsCache(GenericTableColumn object) {
        return ((GenericStructContainer)((GenericTableBase)object.getParentObject()).getContainer()).getTableCache().getChildrenCache((DBSObject)((GenericTableBase)object.getParentObject()));
    }

    public boolean canCreateObject(Object container) {
        return container instanceof GenericTable && GenericUtils.canAlterTable((DBSObject)((GenericTable)((Object)container)));
    }

    public boolean canEditObject(GenericTableColumn object) {
        return GenericUtils.canAlterTable((DBSObject)object);
    }

    public boolean canDeleteObject(GenericTableColumn object) {
        return GenericUtils.canAlterTable((DBSObject)object);
    }

    protected GenericTableColumn createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        GenericTableBase tableBase = (GenericTableBase)((Object)container);
        DBSDataType columnType = GenericTableColumnManager.findBestDataType((DBSObject)tableBase, (String[])DBConstants.DEFAULT_DATATYPE_NAMES);
        int columnSize = columnType != null && columnType.getDataKind() == DBPDataKind.STRING ? 100 : 0;
        GenericTableColumn column = ((GenericDataSource)tableBase.getDataSource()).getMetaModel().createTableColumnImpl(monitor, null, tableBase, this.getNewColumnName(monitor, context, (DBSEntity)tableBase), columnType == null ? "INTEGER" : columnType.getName(), columnType == null ? 4 : columnType.getTypeID(), columnType == null ? 4 : columnType.getTypeID(), -1, columnSize, columnSize, null, null, 10, false, null, null, false, false);
        column.setPersisted(false);
        return column;
    }

    public StringBuilder getNestedDeclaration(@NotNull DBRProgressMonitor monitor, @NotNull GenericTableBase owner, @NotNull DBECommandAbstract<GenericTableColumn> command, @NotNull Map<String, Object> options) {
        StringBuilder decl = super.getNestedDeclaration(monitor, (DBSEntity)owner, command, options);
        this.addIncrementClauseToNestedDeclaration(command, decl);
        return decl;
    }

    public void addIncrementClauseToNestedDeclaration(DBECommandAbstract<GenericTableColumn> command, StringBuilder decl) {
        String autoIncrementClause;
        GenericTableColumn column = (GenericTableColumn)command.getObject();
        if (column.isAutoIncrement() && (autoIncrementClause = column.getDataSource().getMetaModel().getAutoIncrementClause(column)) != null && !autoIncrementClause.isEmpty()) {
            decl.append(" ").append(autoIncrementClause);
        }
    }

    protected SQLTableColumnManager.ColumnModifier[] getSupportedModifiers(GenericTableColumn column, Map<String, Object> options) {
        GenericMetaModel metaModel = column.getDataSource().getMetaModel();
        if (!metaModel.supportsNotNullColumnModifiers((DBSObject)column)) {
            return new SQLTableColumnManager.ColumnModifier[]{this.DataTypeModifier, this.DefaultModifier};
        }
        return new SQLTableColumnManager.ColumnModifier[]{this.DataTypeModifier, this.DefaultModifier, metaModel.isColumnNotNullByDefault() ? this.NullNotNullModifier : this.NotNullModifier};
    }

    protected long getDDLFeatures(GenericTableColumn object) {
        long features = 0L;
        if (CommonUtils.toBoolean((Object)object.getDataSource().getContainer().getDriver().getDriverParameter("ddl-drop-column-short"))) {
            features |= 1L;
        }
        if (CommonUtils.toBoolean((Object)object.getDataSource().getContainer().getDriver().getDriverParameter("ddl-drop-column-brackets"))) {
            features |= 2L;
        }
        if (CommonUtils.toBoolean((Object)object.getDataSource().getContainer().getDriver().getDriverParameter("alter-table-add-column"))) {
            features |= 4L;
        }
        return features;
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) throws DBException {
        GenericTableColumn column = (GenericTableColumn)command.getObject();
        if (command.hasProperty((Object)"description")) {
            GenericTableColumnManager.addColumnCommentAction(actionList, (DBSEntityAttribute)column, (DBSEntity)column.getTable());
        }
    }
}

