/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.edit;

import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKey;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLForeignKeyManager;
import org.jkiss.dbeaver.model.impl.struct.AbstractTable;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyDeferability;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.utils.CommonUtils;

public class GenericForeignKeyManager
extends SQLForeignKeyManager<GenericTableForeignKey, GenericTableBase> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, GenericTableForeignKey> getObjectsCache(GenericTableForeignKey object) {
        return ((GenericStructContainer)((GenericTableBase)object.getParentObject()).getContainer()).getForeignKeysCache();
    }

    public boolean canCreateObject(Object container) {
        return container instanceof GenericTable && ((GenericDataSource)((GenericTable)((Object)container)).getDataSource()).getInfo().supportsReferentialIntegrity() && GenericUtils.canAlterTable((DBSObject)((GenericTable)((Object)container)));
    }

    public boolean canEditObject(GenericTableForeignKey object) {
        return GenericUtils.canAlterTable((DBSObject)object);
    }

    public boolean canDeleteObject(GenericTableForeignKey object) {
        return GenericUtils.canAlterTable((DBSObject)object);
    }

    protected GenericTableForeignKey createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object from, Map<String, Object> options) {
        GenericTableBase tableBase = (GenericTableBase)((Object)container);
        GenericTableForeignKey foreignKey = ((GenericDataSource)tableBase.getDataSource()).getMetaModel().createTableForeignKeyImpl(tableBase, null, null, null, DBSForeignKeyModifyRule.NO_ACTION, DBSForeignKeyModifyRule.NO_ACTION, DBSForeignKeyDeferability.NOT_DEFERRABLE, false);
        foreignKey.setName(this.getNewConstraintName(monitor, (AbstractTableConstraint)foreignKey));
        return foreignKey;
    }

    protected StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, GenericTableBase owner, DBECommandAbstract<GenericTableForeignKey> command, Map<String, Object> options) {
        if (options.get("composite.object") instanceof DBSEntity && !((GenericDataSource)owner.getDataSource()).getMetaModel().supportNestedForeignKeys()) {
            return null;
        }
        return super.getNestedDeclaration(monitor, (AbstractTable)owner, command, options);
    }

    protected boolean isLegacyForeignKeySyntax(GenericTableBase owner) {
        return GenericUtils.isLegacySQLDialect((DBSObject)owner);
    }

    protected void appendUpdateDeleteRule(GenericTableForeignKey foreignKey, StringBuilder decl) {
        String onUpdateFK;
        String onDeleteRule = foreignKey.getDataSource().getMetaModel().generateOnDeleteFK(foreignKey.getDeleteRule());
        if (!CommonUtils.isEmpty((String)onDeleteRule)) {
            decl.append(" ").append(onDeleteRule);
        }
        if (!CommonUtils.isEmpty((String)(onUpdateFK = foreignKey.getDataSource().getMetaModel().generateOnUpdateFK(foreignKey.getUpdateRule())))) {
            decl.append(" ").append(onUpdateFK);
        }
    }

    protected boolean isFKConstraintDuplicated(GenericTableBase owner) {
        return ((GenericDataSource)owner.getDataSource()).getMetaModel().isFKConstraintWordDuplicated();
    }
}

