/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.ui.security;

import com.dbeaver.model.security.DBPasswordValidator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class NewPasswordDialog
extends BaseDialog {
    private String hint;
    private Text passwordText;
    private Text confirmPasswordText;
    private Button showPasswordCheckbox;
    private CLabel statusLabel;
    private String password;
    private final DBPasswordValidator validator;

    public NewPasswordDialog(@NotNull Shell parentShell, @NotNull String title, @Nullable String hint, @Nullable DBPasswordValidator validator) {
        super(parentShell, title, null);
        this.hint = hint;
        this.validator = validator;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        Group credGroup = UIUtils.createControlGroup((Composite)dialogArea, (String)"Password", (int)2, (int)768, (int)0);
        GridData gd = new GridData(768);
        gd.widthHint = UIUtils.getFontHeight((Font)credGroup.getFont()) * 20;
        this.passwordText = UIUtils.createLabelText((Composite)credGroup, (String)"Password", (String)"", (int)0x400800, (Object)gd);
        this.confirmPasswordText = UIUtils.createLabelText((Composite)credGroup, (String)"Confirm Password", (String)"", (int)0x400800, (Object)gd);
        ModifyListener checkPassListener = e -> this.updateCompletion();
        this.passwordText.addModifyListener(checkPassListener);
        this.confirmPasswordText.addModifyListener(checkPassListener);
        this.showPasswordCheckbox = UIUtils.createCheckbox((Composite)credGroup, (String)"Show password", (String)"Show password text on screen", (boolean)false, (int)2);
        this.showPasswordCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            int style = this.showPasswordCheckbox.getSelection() ? 2048 : 0x400800;
            this.passwordText = UIUtils.recreateTextControl((Text)this.passwordText, (int)style);
            this.confirmPasswordText = UIUtils.recreateTextControl((Text)this.confirmPasswordText, (int)style);
        }));
        if (this.password != null) {
            this.passwordText.setText(this.password);
        }
        this.statusLabel = new CLabel(dialogArea, 0);
        this.statusLabel.setLayoutData((Object)new GridData(768));
        this.updateCompletion();
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
    }

    protected void okPressed() {
        this.password = this.passwordText.getText();
        super.okPressed();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private void updateCompletion() {
        boolean valid = true;
        boolean complete = true;
        String status = this.hint;
        if (this.passwordText.getText().isEmpty()) {
            complete = false;
        } else if (!this.passwordText.getText().equals(this.confirmPasswordText.getText())) {
            valid = false;
            complete = false;
            status = "Passwords don't match";
        }
        if (valid && complete && this.validator != null) {
            try {
                this.validator.validate(this.passwordText.getText());
            }
            catch (DBException e) {
                valid = false;
                complete = false;
                status = e.getMessage();
            }
        }
        this.statusLabel.setText(status);
        this.statusLabel.setImage(DBeaverIcons.getImage((DBPImage)(valid ? DBIcon.SMALL_INFO : DBIcon.SMALL_ERROR)));
        this.statusLabel.setVisible(status != null);
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(complete);
        }
    }

    @Nullable
    public static String getNewPassword(@NotNull Shell shell, @NotNull String title, @Nullable String hint, @Nullable String password) {
        return NewPasswordDialog.getNewPassword(shell, title, hint, password, null);
    }

    @Nullable
    public static String getNewPassword(@NotNull Shell shell, @NotNull String title, @Nullable String hint, @Nullable String password, @Nullable DBPasswordValidator validator) {
        NewPasswordDialog dialog = new NewPasswordDialog(shell, title, hint, validator);
        dialog.setPassword(password);
        if (dialog.open() == 0) {
            return dialog.password;
        }
        return null;
    }
}

