/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.ui.security;

import com.dbeaver.ee.runtime.LocalProjectAdvanced;
import com.dbeaver.ee.runtime.internal.ui.UiMessages;
import org.eclipse.equinox.internal.security.storage.friends.InternalExchangeUtils;
import org.eclipse.equinox.internal.security.ui.storage.PasswordRecoveryDialog;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.provider.IPreferencesContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSecurity;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public class EnterPasswordDialog
extends BaseDialog {
    private static final String PREFERENCES_PROJECT_SECURITY_PAGE_ID = "com.dbeaver.preferences.projectSecurity";
    private static final Log log = Log.getLog(EnterPasswordDialog.class);
    private String message;
    private Text passwordText;
    private String password;
    private Button showPasswordCheckbox;
    private Runnable recoveryHandler;
    private boolean recoverPassword;
    private boolean isSupportRecovery;
    private DBPProject project;

    public EnterPasswordDialog(Shell parentShell, String title, String message, Runnable recoveryHandler, boolean isSupportRecovery) {
        super(parentShell, title, null);
        if (parentShell == null) {
            this.setShellStyle(96);
        }
        this.message = message;
        this.recoveryHandler = recoveryHandler;
        this.isSupportRecovery = isSupportRecovery;
    }

    /*
     * WARNING - void declaration
     */
    protected Composite createDialogArea(Composite parent) {
        DBPProject dBPProject;
        Label label;
        Composite dialogArea = super.createDialogArea(parent);
        Composite cmpsBase = UIUtils.createComposite((Composite)dialogArea, (int)2);
        GridData gd = new GridData(768);
        gd.widthHint = 400;
        cmpsBase.setLayoutData((Object)gd);
        if (this.message != null && !this.message.isEmpty()) {
            label = UIUtils.createLabel((Composite)cmpsBase, (String)this.message);
            label.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        }
        gd = new GridData(768);
        gd.widthHint = UIUtils.getFontHeight((Font)cmpsBase.getFont()) * 20;
        this.passwordText = UIUtils.createLabelText((Composite)cmpsBase, (String)UiMessages.password_dialog_label, (String)"", (int)0x400800, (Object)gd);
        this.passwordText.addModifyListener(e -> this.enableButton(0, !this.passwordText.getText().isEmpty()));
        if (this.password != null) {
            this.passwordText.setText(this.password);
        }
        this.showPasswordCheckbox = UIUtils.createCheckbox((Composite)cmpsBase, (String)UiMessages.password_dialog_show_checkbox_label, (String)UiMessages.password_dialog_show_checkbox_label, (boolean)false, (int)2);
        this.showPasswordCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            int style = this.showPasswordCheckbox.getSelection() ? 2048 : 0x400800;
            this.passwordText = UIUtils.recreateTextControl((Text)this.passwordText, (int)style);
        }));
        if (this.project != null && (dBPProject = this.project) instanceof LocalProjectAdvanced) {
            label = (LocalProjectAdvanced)dBPProject;
            LocalProjectAdvanced cfr_ignored_0 = (LocalProjectAdvanced)dBPProject;
            if (!CommonUtils.toBoolean((Object)this.project.getProjectProperty("usePasswordManagement"))) {
                void advancedProject;
                UIUtils.createInfoLabel((Composite)dialogArea, (String)UiMessages.password_dialog_password_management_link, () -> this.lambda$2((LocalProjectAdvanced)advancedProject));
            }
        }
        if (this.recoveryHandler != null && !this.isSupportRecovery) {
            UIUtils.createInfoLabel((Composite)dialogArea, (String)UiMessages.password_dialog_password_recovery_link, () -> {
                this.recoverPassword = true;
                this.cancelPressed();
            });
        }
        UIUtils.centerShell((Shell)this.getParentShell(), (Shell)this.getShell());
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        this.password = this.passwordText.getText();
        super.okPressed();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static String askPassword(@NotNull Shell shell, @NotNull String title, @NotNull String message, @NotNull String password, boolean isSupportRecovery) {
        EnterPasswordDialog dialog = new EnterPasswordDialog(shell, title, message, EnterPasswordDialog::recoverPassword, isSupportRecovery);
        int dialogStyle = 0;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null || workbench.getActiveWorkbenchWindow() == null || !workbench.getActiveWorkbenchWindow().getShell().isVisible()) {
            dialogStyle |= 0x24000;
        }
        dialog.setShellStyle(dialog.getShellStyle() | dialogStyle);
        dialog.setPassword(password);
        if (dialog.open() == 0) {
            return dialog.password;
        }
        if (dialog.recoverPassword) {
            return EnterPasswordDialog.recoverPassword();
        }
        return null;
    }

    public static String askPassword(@NotNull Shell shell, @NotNull DBPProject project, @NotNull String title, @NotNull String message, @NotNull String password, boolean isSupportRecovery) {
        EnterPasswordDialog dialog = new EnterPasswordDialog(shell, title, message, EnterPasswordDialog::recoverPassword, isSupportRecovery);
        dialog.setProject(project);
        int dialogStyle = 0;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null || workbench.getActiveWorkbenchWindow() == null || !workbench.getActiveWorkbenchWindow().getShell().isVisible()) {
            dialogStyle |= 0x24000;
        }
        dialog.setShellStyle(dialog.getShellStyle() | dialogStyle);
        dialog.setPassword(password);
        if (dialog.open() == 0) {
            return dialog.password;
        }
        if (dialog.recoverPassword) {
            return EnterPasswordDialog.recoverPassword();
        }
        return null;
    }

    private void setProject(DBPProject project) {
        this.project = project;
    }

    public static String recoverPassword() {
        ISecurePreferences rootNode = SecurePreferencesFactory.getDefault();
        String curModuleId = null;
        try {
            IPreferencesContainer container = (IPreferencesContainer)BeanUtils.invokeObjectMethod((Object)rootNode, (String)"getContainer");
            curModuleId = CommonUtils.toString((Object)container.getOption((Object)"org.eclipse.equinox.security.storage.requiredID"), null);
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
        if (curModuleId == null) {
            curModuleId = "com.dbeaver.app.advanced.dbeaverpasswordprovider";
        }
        Shell shell = UIUtils.getActiveWorkbenchShell();
        String[] questions = InternalExchangeUtils.getPasswordRecoveryQuestions((ISecurePreferences)rootNode, (String)curModuleId);
        if (questions.length == 0) {
            UIUtils.showMessageBox((Shell)shell, (String)UiMessages.password_dialog_password_recovery_dialog_title, (String)UiMessages.password_dialog_password_recovery_dialog_msg, (int)1);
            return null;
        }
        ProjectPasswordRecoveryDialog dialog = new ProjectPasswordRecoveryDialog(questions, shell, curModuleId);
        if (dialog.open() == 0) {
            return dialog.getPassword();
        }
        return null;
    }

    private /* synthetic */ void lambda$2(LocalProjectAdvanced localProjectAdvanced) {
        boolean applyPasswordReset = false;
        applyPasswordReset = UIUtils.confirmAction((Shell)this.getShell(), (String)UiMessages.pref_page_project_security_project_password_remove_confirm_title, (String)NLS.bind((String)UiMessages.pref_page_project_security_project_password_remove_confirm_message, (Object)this.project.getName()), (DBPImage)DBIcon.STATUS_WARNING, (String[])new String[]{"Reset password", "Cancel"});
        if (applyPasswordReset && localProjectAdvanced.isEncryptedProject()) {
            applyPasswordReset = UIUtils.confirmAction((Shell)this.getShell(), (String)UiMessages.pref_page_project_security_project_password_remove_confirm_title, (String)NLS.bind((String)UiMessages.pref_page_project_security_project_password_remove_encrypted_confirm_message, (Object)this.project.getName()), (DBPImage)DBIcon.STATUS_WARNING, (String[])new String[]{"Delete configuration", "Cancel"});
        }
        if (applyPasswordReset) {
            UIServiceSecurity serviceSecurity = (UIServiceSecurity)DBWorkbench.getService(UIServiceSecurity.class);
            if (serviceSecurity != null) {
                this.close();
                UIUtils.asyncExec(() -> {
                    try {
                        log.info((Object)("Action delete project pasword for [" + this.project.getName() + "] is confirmed."));
                        serviceSecurity.resetProjectPassword((DBPProject)localProjectAdvanced);
                        localProjectAdvanced.getDataSourceRegistry().refreshConfig();
                    }
                    catch (DBException e) {
                        log.error((Object)e);
                    }
                });
            }
        } else {
            log.info((Object)("Action delete project pasword for [" + this.project.getName() + "] is canceled."));
        }
    }

    private static class ProjectPasswordRecoveryDialog
    extends PasswordRecoveryDialog {
        ProjectPasswordRecoveryDialog(String[] questions, Shell shell, String curModuleId) {
            super(questions, shell, curModuleId);
        }

        public String getPassword() {
            return InternalExchangeUtils.recoverPassword((String[])this.answersText, (ISecurePreferences)SecurePreferencesFactory.getDefault(), (String)this.moduleID);
        }
    }
}

