/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.ui.connections.k8s;

import com.dbeaver.ee.runtime.core.DBeaverEnterprisePreferences;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class PrefPageKubernetes
extends AbstractPrefPage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "com.dbeaver.ee.runtime.ui.preferencePages.page.k8s";
    private TextWithOpen kubectlCliExecutablePath;

    public PrefPageKubernetes() {
        this.setTitle("AWS preferences");
    }

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Group cliGroup = UIUtils.createControlGroup((Composite)parent, (String)"kubectl settings", (int)2, (int)768, (int)0);
        UIUtils.createControlLabel((Composite)cliGroup, (String)"Path to kubectl");
        Object execName = "kubectl";
        if (RuntimeUtils.isWindows()) {
            execName = (String)execName + ".exe";
        }
        this.kubectlCliExecutablePath = new TextWithOpenFile((Composite)cliGroup, "Path to kubectl", new String[]{execName, "*"});
        this.kubectlCliExecutablePath.setLayoutData((Object)new GridData(4, 1, true, false));
        this.kubectlCliExecutablePath.getTextControl().setMessage("If kubectl cannot be found in path then you can specify exact location");
        this.kubectlCliExecutablePath.setText(DBeaverEnterprisePreferences.getPreferences().getString("kubectlPath"));
        this.performDefaults();
        return cliGroup;
    }

    protected void performDefaults() {
        this.kubectlCliExecutablePath.setText("kubectl");
        super.performDefaults();
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBeaverEnterprisePreferences.getPreferences();
        store.setValue("kubectlPath", this.kubectlCliExecutablePath.getText());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return true;
    }
}

