/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.internal.ui.preferences;

import com.dbeaver.ee.runtime.LocalProjectAdvanced;
import com.dbeaver.ee.runtime.core.DBeaverEnterprisePreferences;
import com.dbeaver.ee.runtime.internal.ui.UiMessages;
import com.dbeaver.ee.runtime.ui.security.EnterPasswordDialog;
import com.dbeaver.ee.runtime.ui.security.NewPasswordDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.runtime.DBInterruptedException;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSecurity;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.utils.CommonUtils;

public class PrefPageProjectSecurity
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private static final String DUMMY_PASSWORD = "dummypassword";
    private static final String BAD_PASSWORD = String.valueOf('\u0000');
    private IProject project;
    private DBPProject dbProject;
    private Button encryptConfiguration;
    private String projectPassword = "dummypassword";
    private String lastSavedPassword = BAD_PASSWORD;
    private boolean lastEncryptProject;
    private boolean passwordChanged = false;
    private Button clearProjectPasswordButton;
    private Button setProjectPasswordButton;
    private Control passwordChangedNotice;
    private boolean stateClearProjectPassword;

    public PrefPageProjectSecurity() {
        this.setDescription("Project security settings");
    }

    private DBPProject getProjectMetadata() {
        DBPProject projectMeta = DBPPlatformDesktop.getInstance().getWorkspace().getProject(this.project);
        if (projectMeta == null) {
            throw new IllegalStateException("Project '" + this.project.getName() + "' metadata not found");
        }
        return projectMeta;
    }

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        Group projectPasswordGroup = UIUtils.createControlGroup((Composite)composite, (String)UiMessages.pref_page_project_security_project_password_label, (int)1, (int)0, (int)0);
        UIUtils.createInfoLabel((Composite)projectPasswordGroup, (String)UiMessages.pref_page_project_security_project_password_details);
        Composite buttonsPanel = UIUtils.createComposite((Composite)projectPasswordGroup, (int)3);
        this.setProjectPasswordButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)UiMessages.pref_page_project_security_project_password_set_label, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PrefPageProjectSecurity.this.validateCurrentPassword()) {
                    PrefPageProjectSecurity.this.setProjectPassword();
                    PrefPageProjectSecurity.this.passwordChanged = true;
                    PrefPageProjectSecurity.this.setValid(true);
                }
            }
        });
        this.clearProjectPasswordButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)UiMessages.pref_page_project_security_project_password_clear_label, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UIUtils.confirmAction((Shell)PrefPageProjectSecurity.this.getShell(), (String)UiMessages.pref_page_project_security_project_password_confirm_clear_title, (String)UiMessages.pref_page_project_security_project_password_confirm_clear_label)) {
                    PrefPageProjectSecurity.this.passwordChanged = true;
                    PrefPageProjectSecurity.this.stateClearProjectPassword = true;
                    PrefPageProjectSecurity.this.projectPassword = null;
                } else {
                    PrefPageProjectSecurity.this.setValid(false);
                }
            }
        });
        this.passwordChangedNotice = UIUtils.createWarningLabel((Composite)buttonsPanel, (String)UiMessages.pref_page_project_security_project_password_changed_label, (int)0, (int)1);
        this.passwordChangedNotice.setVisible(false);
        Group encryptConfig = UIUtils.createControlGroup((Composite)composite, (String)UiMessages.pref_page_project_security_project_password_configuration_encrypt_label, (int)1, (int)0, (int)0);
        UIUtils.createInfoLabel((Composite)encryptConfig, (String)UiMessages.pref_page_project_security_project_password_configuration_encrypt_details);
        this.encryptConfiguration = UIUtils.createCheckbox((Composite)encryptConfig, (String)UiMessages.pref_page_project_security_project_password_configuration_encrypt_label, (String)UiMessages.pref_page_project_security_project_password_configuration_encrypt_tooltip, (boolean)false, (int)1);
        this.performDefaults();
        return composite;
    }

    @Deprecated
    private void recoverCurrentPassword() {
        EnterPasswordDialog.recoverPassword();
    }

    private boolean validateCurrentPassword() {
        this.dbProject = this.getProjectMetadata();
        UIServiceSecurity serviceSecurity = (UIServiceSecurity)DBWorkbench.getService(UIServiceSecurity.class);
        if (serviceSecurity != null) {
            return serviceSecurity.validatePassword(this.dbProject, UiMessages.pref_page_project_security_project_password_validation_title, NLS.bind((String)UiMessages.pref_page_project_security_project_password_validation_message, (Object)this.dbProject.getDisplayName()), false);
        }
        UIUtils.showMessageBox((Shell)this.getShell(), (String)UiMessages.pref_page_project_security_project_password_validation_service_error_title, (String)UiMessages.pref_page_project_security_project_password_validation_service_error_message, (int)1);
        return false;
    }

    private void setProjectPassword() {
        this.projectPassword = NewPasswordDialog.getNewPassword(this.getShell(), "Set project password", null, null);
        if (!this.passwordChangedNotice.isVisible() && CommonUtils.isNotEmpty((String)this.projectPassword)) {
            this.passwordChangedNotice.setVisible(true);
        }
    }

    protected void performDefaults() {
        this.dbProject = this.getProjectMetadata();
        this.dbProject.ensureOpen();
        this.dbProject.setProjectProperty("usePasswordManagement", (Object)true);
        DBPDataSourceRegistry dataSourceRegistry = this.dbProject.getDataSourceRegistry();
        if (dataSourceRegistry == null) {
            this.setErrorMessage(UiMessages.pref_page_project_security_project_password_datasource_not_loaded_error);
            this.setValid(false);
            this.setProjectPasswordButton.setEnabled(false);
            this.clearProjectPasswordButton.setEnabled(false);
            return;
        }
        this.dbProject.setProjectProperty("usePasswordManagement", (Object)false);
        this.lastEncryptProject = CommonUtils.toBoolean((Object)this.dbProject.getProjectProperty("secureProject"));
        this.encryptConfiguration.setSelection(this.lastEncryptProject);
        boolean usePassword = CommonUtils.toBoolean((Object)this.dbProject.getProjectProperty("useProjectPassword"));
        this.clearProjectPasswordButton.setEnabled(usePassword);
        this.setProjectPasswordButton.setEnabled(!usePassword);
        if (usePassword) {
            this.projectPassword = DUMMY_PASSWORD;
        }
        super.performDefaults();
    }

    /*
     * WARNING - void declaration
     */
    public boolean performOk() {
        boolean encryptProject;
        Boolean newUsePassword;
        DBPProject projectMetadata = this.getProjectMetadata();
        DBPDataSourceRegistry dataSourceRegistry = projectMetadata.getDataSourceRegistry();
        boolean configChanged = false;
        boolean requireRefreshConfig = false;
        boolean passwordEnterCanced = false;
        boolean oldUsePassword = CommonUtils.toBoolean((Object)projectMetadata.getProjectProperty("useProjectPassword"));
        Boolean bl = newUsePassword = this.passwordChanged ? null : Boolean.valueOf(oldUsePassword);
        if (this.passwordChanged && !CommonUtils.equalObjects((Object)this.projectPassword, (Object)this.lastSavedPassword)) {
            if (CommonUtils.isEmpty((String)this.projectPassword)) {
                if (oldUsePassword) {
                    if (UIUtils.confirmAction((Shell)this.getShell(), (String)UiMessages.pref_page_project_security_project_password_remove_confirm_title, (String)NLS.bind((String)UiMessages.pref_page_project_security_project_password_remove_confirm_message, (Object)projectMetadata.getName()), (DBPImage)DBIcon.STATUS_WARNING)) {
                        requireRefreshConfig = true;
                    } else {
                        return false;
                    }
                }
                newUsePassword = false;
            } else if (!this.projectPassword.equals(DUMMY_PASSWORD) && (oldUsePassword ? !UIUtils.confirmAction((Shell)this.getShell(), (String)UiMessages.pref_page_project_security_project_password_change_confirm_title, (String)NLS.bind((String)UiMessages.pref_page_project_security_project_password_change_confirm_message, (Object)projectMetadata.getName())) : !UIUtils.confirmAction((Shell)this.getShell(), (String)UiMessages.pref_page_project_security_project_password_set_confirm_title, (String)NLS.bind((String)UiMessages.pref_page_project_security_project_password_set_confirm_message, (Object)projectMetadata.getName()), (DBPImage)DBIcon.STATUS_WARNING))) {
                return false;
            }
            if (!DUMMY_PASSWORD.equals(this.projectPassword)) {
                DBPProject dBPProject = projectMetadata;
                if (dBPProject instanceof LocalProjectAdvanced) {
                    void advancedProject;
                    LocalProjectAdvanced localProjectAdvanced = (LocalProjectAdvanced)dBPProject;
                    LocalProjectAdvanced cfr_ignored_0 = (LocalProjectAdvanced)dBPProject;
                    advancedProject.setProjectPassword(this.projectPassword);
                }
                newUsePassword = this.projectPassword == null ? null : Boolean.valueOf(true);
            }
            this.lastSavedPassword = this.projectPassword;
            configChanged = true;
        }
        if (this.lastEncryptProject != (encryptProject = this.encryptConfiguration.getSelection())) {
            configChanged = true;
        }
        if (newUsePassword != null && newUsePassword.booleanValue() && projectMetadata.isUseSecretStorage()) {
            try {
                secretController = DBSSecretController.getProjectSecretController((DBPProject)this.getProjectMetadata());
                dataSourceRegistry.resolveSecrets(secretController);
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError(UiMessages.pref_page_project_security_project_password_resolve_error_title, UiMessages.pref_page_project_security_project_password_resolve_error_message, (Throwable)e);
            }
        } else if (newUsePassword == null && DBeaverEnterprisePreferences.useSecurePreferences()) {
            try {
                secretController = DBSSecretController.getProjectSecretController((DBPProject)this.getProjectMetadata());
                dataSourceRegistry.persistSecrets(secretController);
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError(UiMessages.pref_page_project_security_project_password_resolve_error_title, UiMessages.pref_page_project_security_project_password_resolve_error_message, (Throwable)e);
            }
        }
        if (configChanged) {
            Throwable lastLoadError = dataSourceRegistry.getLastError();
            if (lastLoadError instanceof DBInterruptedException) {
                passwordEnterCanced = true;
            } else if (lastLoadError != null) {
                DBWorkbench.getPlatformUI().showError(UiMessages.pref_page_project_security_project_password_resolve_error_title, UiMessages.pref_page_project_security_project_password_resolve_error_details, lastLoadError);
                return false;
            }
            if (this.stateClearProjectPassword && passwordEnterCanced) {
                UIServiceSecurity serviceSecurity = (UIServiceSecurity)DBWorkbench.getService(UIServiceSecurity.class);
                if (serviceSecurity != null) {
                    try {
                        serviceSecurity.resetProjectPassword(projectMetadata);
                    }
                    catch (DBException e) {
                        DBWorkbench.getPlatformUI().showError(UiMessages.pref_page_project_security_project_password_resolve_error_title, e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                projectMetadata.setProjectProperty("useProjectPassword", (Object)newUsePassword);
                if (this.lastEncryptProject != encryptProject) {
                    projectMetadata.setProjectProperty("secureProject", (Object)encryptProject);
                    this.lastEncryptProject = encryptProject;
                }
                dataSourceRegistry.flushConfig();
            }
            if (requireRefreshConfig && passwordEnterCanced && !projectMetadata.isEncryptedProject()) {
                projectMetadata.getDataSourceRegistry().refreshConfig();
            }
        }
        this.passwordChangedNotice.setVisible(false);
        return super.performOk();
    }

    public IAdaptable getElement() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    public void setElement(IAdaptable element) {
        IAdaptable iAdaptable = element;
        if (iAdaptable instanceof IProject) {
            void adpProject;
            IProject iProject = (IProject)iAdaptable;
            IProject cfr_ignored_0 = (IProject)iAdaptable;
            this.project = adpProject;
        } else {
            IAdaptable iAdaptable2 = element;
            if (iAdaptable2 instanceof DBNNode) {
                void node;
                DBNNode dBNNode = (DBNNode)iAdaptable2;
                DBNNode cfr_ignored_1 = (DBNNode)iAdaptable2;
                this.project = node.getOwnerProject().getEclipseProject();
            } else {
                this.project = (IProject)DBUtils.getAdapter(IProject.class, (Object)element);
            }
        }
    }
}

